/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.config.library.PhpRuntimeLibraryRootsProvider;
import gnu.trove.THashMap;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PhpRuntimeConfiguration", storages={@Storage(value="php.xml")})
public class PhpRuntimeConfiguration
implements PersistentStateComponent<State>,
Disposable {
    public static final Map<String, Boolean> DEFAULT_EXTENSIONS = ImmutableMap.builder().put((Object)"aerospike", (Object)false).put((Object)"ast", (Object)false).put((Object)"blackfire", (Object)false).put((Object)"ds", (Object)false).put((Object)"crypto", (Object)false).put((Object)"event", (Object)false).put((Object)"expect", (Object)false).put((Object)"FFI", (Object)false).put((Object)"com_dotnet", (Object)false).put((Object)"leveldb", (Object)false).put((Object)"lua", (Object)false).put((Object)"LuaSandbox", (Object)false).put((Object)"lzf", (Object)false).put((Object)"mapscript", (Object)false).put((Object)"msgpack", (Object)false).put((Object)"meminfo", (Object)false).put((Object)"mosquitto", (Object)false).put((Object)"pcov", (Object)false).put((Object)"pq", (Object)false).put((Object)"rpminfo", (Object)false).put((Object)"solr", (Object)false).put((Object)"stats", (Object)false).put((Object)"stomp", (Object)false).put((Object)"svm", (Object)false).put((Object)"sync", (Object)false).put((Object)"Parle", (Object)false).put((Object)"parallel", (Object)false).put((Object)"phpdbg", (Object)false).put((Object)"Radius", (Object)false).put((Object)"SaxonC", (Object)false).put((Object)"rdkafka", (Object)false).put((Object)"uopz", (Object)false).put((Object)"winbinder", (Object)false).put((Object)"yaf", (Object)false).put((Object)"yar", (Object)false).put((Object)"uuid", (Object)false).put((Object)"uv", (Object)false).put((Object)"xcache", (Object)false).put((Object)"ZendCache", (Object)false).put((Object)"zookeeper", (Object)false).put((Object)"zstd", (Object)false).put((Object)"xxtea", (Object)false).build();
    public static final Set<String> WHITE_LISTED_THIRD_PARTY_EXTENSIONS = ImmutableSet.builder().add((Object)"amqp").add((Object)"blackfire").add((Object)"decimal").add((Object)"expect").add((Object)"FFI").add((Object)"phpdbg").add((Object)"com_dotnet").add((Object)"couchbase").add((Object)"Ev").add((Object)"fann").add((Object)"ffmpeg").add((Object)"gnupg").add((Object)"grpc").add((Object)"igbinary").add((Object)"judy").add((Object)"lua").add((Object)"libsodium").add((Object)"mapscript").add((Object)"mosquitto").add((Object)"mqseries").add((Object)"newrelic").add((Object)"pcov").add((Object)"pq").add((Object)"radius").add((Object)"rar").add((Object)"redis").add((Object)"rrd").add((Object)"suhosin").add((Object)"stats").add((Object)"uuid").add((Object)"v8js").add((Object)"winbinder").add((Object)"win32service").add((Object)"xcache").add((Object)"xdebug").add((Object)"zend").add((Object)"ZendCache").add((Object)"ZendDebugger").add((Object)"ZendUtils").add((Object)"zmq").add((Object)"xxtea").build();
    private final Project myProject;
    private State myState;

    @NotNull
    public static PhpRuntimeConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(0);
        }
        PhpRuntimeConfiguration phpRuntimeConfiguration = (PhpRuntimeConfiguration)ServiceManager.getService((Project)project, PhpRuntimeConfiguration.class);
        if (phpRuntimeConfiguration == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(1);
        }
        return phpRuntimeConfiguration;
    }

    public PhpRuntimeConfiguration(@NotNull Project project) {
        if (project == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(2);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(3);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(4);
        }
        this.myState = state;
    }

    @NotNull
    public Map<String, Boolean> getExtensions() {
        Map map = ContainerUtil.union(DEFAULT_EXTENSIONS, this.getState().getExtensions());
        if (map == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(5);
        }
        return map;
    }

    public void setExtensions(@NotNull Map<String, Boolean> extensions) {
        if (extensions == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(6);
        }
        Map<String, Boolean> userExtensions = PhpRuntimeConfiguration.getExtensionsWithoutDefault(extensions);
        this.getState().setExtensions(userExtensions);
        PhpRuntimeLibraryRootsProvider.fireRootsChanged(this.myProject);
    }

    public static Map<String, Boolean> getExtensionsWithoutDefault(@NotNull Map<String, Boolean> extensions) {
        if (extensions == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(7);
        }
        Map diff = ContainerUtil.diff(DEFAULT_EXTENSIONS, extensions);
        return ((StreamEx)((StreamEx)StreamEx.of(diff.entrySet()).filter(entry -> ((Couple)entry.getValue()).getSecond() != null)).filter(entry -> ((Couple)entry.getValue()).getFirst() != null || (Boolean)((Couple)entry.getValue()).getSecond() == false)).toMap(Map.Entry::getKey, e -> (Boolean)((Couple)e.getValue()).getSecond());
    }

    @NotNull
    @NlsSafe
    public String getDefaultStubsPath() {
        String string = StringUtil.notNullize((String)this.getState().getDefaultStubsPath());
        if (string == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setDefaultStubsPath(@NotNull String defaultStubsPath) {
        String previousDefaultStubsPath;
        if (defaultStubsPath == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(9);
        }
        if (!(previousDefaultStubsPath = this.getDefaultStubsPath()).equals(defaultStubsPath)) {
            PhpRuntimeLibraryRootsProvider.applyNewStubsPath(previousDefaultStubsPath, defaultStubsPath, this.myProject);
            this.getState().setDefaultStubsPath(defaultStubsPath);
            ((DefaultStubsPathListener)this.myProject.getMessageBus().syncPublisher(DefaultStubsPathListener.TOPIC)).pathChanged(previousDefaultStubsPath, defaultStubsPath);
            PhpRuntimeLibraryRootsProvider.fireRootsChanged(this.myProject);
        }
    }

    @NotNull
    @NlsSafe
    public String getDocumentRootPath() {
        String string = StringUtil.notNullize((String)this.getState().getDocumentRootPath());
        if (string == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(10);
        }
        return string;
    }

    public String getResolvedDocumentRootPath() {
        String path = this.getDocumentRootPath();
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        if (this.myProject.isDefault() || FileUtil.isAbsolute((String)path)) {
            return path;
        }
        VirtualFile baseDir = this.myProject.getBaseDir();
        if (baseDir == null) {
            return path;
        }
        path = FileUtil.toSystemIndependentName((String)path);
        return FileUtil.toCanonicalPath((String)(baseDir.getPath() + "/" + path));
    }

    public void setDocumentRootPath(@NotNull String documentRootPath) {
        String previousDocumentRoot;
        if (documentRootPath == null) {
            PhpRuntimeConfiguration.$$$reportNull$$$0(11);
        }
        if (!(previousDocumentRoot = this.getDocumentRootPath()).equals(documentRootPath)) {
            this.getState().setDocumentRootPath(documentRootPath);
            PhpRuntimeLibraryRootsProvider.fireRootsChanged(this.myProject);
        }
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpRuntimeConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultStubsPath";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpRuntimeConfiguration";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultStubsPath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocumentRootPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setExtensions";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtensionsWithoutDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultStubsPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setDocumentRootPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class State {
        private Map<String, Boolean> myExtensions = new THashMap();
        private String myDefaultStubsPath;
        private String myDocumentRoot;

        @Tag(value="extensions")
        @MapAnnotation(surroundWithTag=false, surroundValueWithTag=false, surroundKeyWithTag=false, entryTagName="extension", keyAttributeName="name", valueAttributeName="enabled")
        @NotNull
        public Map<String, Boolean> getExtensions() {
            Map<String, Boolean> map = this.myExtensions;
            if (map == null) {
                State.$$$reportNull$$$0(0);
            }
            return map;
        }

        public void setExtensions(@NotNull Map<String, Boolean> extensions) {
            if (extensions == null) {
                State.$$$reportNull$$$0(1);
            }
            this.myExtensions = extensions;
        }

        @Attribute(value="default_stubs_path")
        @Nullable
        public String getDefaultStubsPath() {
            return this.myDefaultStubsPath;
        }

        public void setDefaultStubsPath(@Nullable String value) {
            this.myDefaultStubsPath = StringUtil.nullize((String)value);
        }

        @Attribute(value="document_root_path")
        @Nullable
        public String getDocumentRootPath() {
            return this.myDocumentRoot;
        }

        public void setDocumentRootPath(@Nullable String value) {
            this.myDocumentRoot = StringUtil.nullize((String)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/config/PhpRuntimeConfiguration$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extensions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getExtensions";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/config/PhpRuntimeConfiguration$State";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setExtensions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static interface DefaultStubsPathListener {
        public static final Topic<DefaultStubsPathListener> TOPIC = new Topic(DefaultStubsPathListener.class, Topic.BroadcastDirection.NONE);

        public void pathChanged(String var1, String var2);
    }
}

