/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurableForm;
import com.jetbrains.php.ui.PhpUiUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpProjectConfigurable
implements SearchableConfigurable {
    private final Project myProject;
    private PhpProjectConfigurableForm myForm;
    private final Disposable myDisposable;

    public PhpProjectConfigurable(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(0);
        }
        this.myDisposable = Disposer.newDisposable();
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("configurable.PhpProjectConfigurable.display.name", new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.webide.settings.project.settings.php";
    }

    public JComponent createComponent() {
        if (this.myForm == null) {
            this.myForm = new PhpProjectConfigurableForm(this.myProject, false, this.myDisposable);
        }
        return this.myForm.getComponent();
    }

    public boolean isModified() {
        if (this.myForm != null) {
            return this.myForm.isModified();
        }
        return false;
    }

    public void apply() throws ConfigurationException {
        if (this.myForm != null) {
            this.myForm.apply();
        }
    }

    public void reset() {
        if (this.myForm != null) {
            this.myForm.reset();
        }
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void openPhpRuntimeTab(boolean openDefaultStubsPanel) {
        this.openPhpRuntimeTab(openDefaultStubsPanel, null);
    }

    public void openAnalysisTab() {
        this.createComponent();
        this.reset();
        this.myForm.openAnalysisTab();
    }

    public void openPhpRuntimeTab(boolean openDefaultStubsPanel, @Nullable String extension) {
        this.createComponent();
        this.reset();
        this.myForm.openPhpRuntimeTab(openDefaultStubsPanel, extension);
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    @NotNull
    public static Runnable createFix(@NotNull Project project) {
        if (project == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(2);
        }
        Runnable runnable = () -> PhpUiUtil.editConfigurable(project, (Configurable)new PhpProjectConfigurable(project));
        if (runnable == null) {
            PhpProjectConfigurable.$$$reportNull$$$0(3);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpProjectConfigurable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpProjectConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

