/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.config;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageFeatureUsagesTracker;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PhpLanguageFeatureUsagesStatistics", storages={@Storage(value="$CACHE_FILE$")})
public class PhpLanguageFeatureUsagesTrackerImpl
implements PersistentStateComponent<Element>,
PhpLanguageFeatureUsagesTracker {
    private final Map<String, EnumSet<PhpLanguageFeature>> myUsedFeatures = new ConcurrentHashMap<String, EnumSet<PhpLanguageFeature>>();

    @Override
    @NotNull
    public EnumSet<PhpLanguageFeature> getUsedFeatures(@NotNull Project project) {
        if (project == null) {
            PhpLanguageFeatureUsagesTrackerImpl.$$$reportNull$$$0(0);
        }
        return this.getUsedFeatures(project.getLocationHash());
    }

    @NotNull
    private EnumSet<PhpLanguageFeature> getUsedFeatures(@NotNull String hash) {
        if (hash == null) {
            PhpLanguageFeatureUsagesTrackerImpl.$$$reportNull$$$0(1);
        }
        EnumSet enumSet = this.myUsedFeatures.computeIfAbsent(hash, key -> EnumSet.noneOf(PhpLanguageFeature.class));
        if (enumSet == null) {
            PhpLanguageFeatureUsagesTrackerImpl.$$$reportNull$$$0(2);
        }
        return enumSet;
    }

    @Nullable
    public Element getState() {
        Element state = new Element("state");
        for (Map.Entry<String, EnumSet<PhpLanguageFeature>> entry : this.myUsedFeatures.entrySet()) {
            Element project = new Element("project");
            project.setAttribute("hash", entry.getKey());
            for (PhpLanguageFeature value : entry.getValue()) {
                Element feature = new Element("feature");
                feature.setAttribute("name", value.name());
                project.addContent(feature);
            }
            state.addContent(project);
        }
        return state;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            PhpLanguageFeatureUsagesTrackerImpl.$$$reportNull$$$0(3);
        }
        for (Element project : element.getChildren()) {
            Attribute hash = project.getAttribute("hash");
            if (hash == null) continue;
            EnumSet<PhpLanguageFeature> features = this.getUsedFeatures(hash.getValue());
            for (Element feature : project.getChildren()) {
                Attribute name = feature.getAttribute("name");
                if (name == null) continue;
                try {
                    features.add(PhpLanguageFeature.valueOf(name.getValue()));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/config/PhpLanguageFeatureUsagesTrackerImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/config/PhpLanguageFeatureUsagesTrackerImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedFeatures";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsedFeatures";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

