/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.statistics;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.validator.rules.impl.LocalFileCustomValidationRule;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.executable.ExecutableComposerExecution;
import com.jetbrains.php.composer.execution.phar.PharComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerExecutorStatProvider;
import com.jetbrains.php.composer.statistics.ComposerPackageVersion;
import com.jetbrains.php.composer.statistics.ComposerPackageVersionParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerConfigCollector
extends ProjectUsagesCollector {
    @NotNull
    public String getGroupId() {
        return "php.composer.config";
    }

    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(0);
        }
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        FeatureUsageData data = new FeatureUsageData();
        data.addData("state", this.getComposerJsonStatus(project));
        result.add(MetricEventFactoryKt.newMetric((String)"json", (FeatureUsageData)data));
        String pathToConfig = this.getPathToConfig(project);
        if (!StringUtil.isEmptyOrSpaces((String)pathToConfig)) {
            result.add(ComposerConfigCollector.getSyncMetrics(project));
            result.addAll(this.getConfigMetrics(pathToConfig));
        }
        result.add(ComposerConfigCollector.getExecutorMetric(project));
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            ComposerConfigCollector.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @NotNull
    Set<MetricEvent> getConfigMetrics(@Nullable String pathToConfig) {
        JsonElement config = this.loadConfig(pathToConfig);
        if (config instanceof JsonObject) {
            JsonObject obj = config.getAsJsonObject();
            HashSet<MetricEvent> result = new HashSet<MetricEvent>();
            ComposerConfigCollector.addPackages(result, obj.get("require"), false);
            ComposerConfigCollector.addPackages(result, obj.get("require-dev"), true);
            ComposerConfigCollector.addRepositories(result, obj.get("repositories"));
            HashSet<MetricEvent> hashSet = result;
            if (hashSet == null) {
                ComposerConfigCollector.$$$reportNull$$$0(2);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            ComposerConfigCollector.$$$reportNull$$$0(3);
        }
        return set;
    }

    private static void addRepositories(@NotNull Set<MetricEvent> result, @Nullable JsonElement repositories) {
        if (result == null) {
            ComposerConfigCollector.$$$reportNull$$$0(4);
        }
        if (!(repositories instanceof JsonArray)) {
            return;
        }
        for (JsonElement repository : (JsonArray)repositories) {
            JsonObject repositoryObject;
            JsonElement type;
            if (!(repository instanceof JsonObject) || (type = (repositoryObject = (JsonObject)repository).get("type")) == null) continue;
            FeatureUsageData data = new FeatureUsageData().addData("repository_type", type.getAsString());
            result.add(MetricEventFactoryKt.newMetric((String)"repository", (FeatureUsageData)data));
        }
    }

    private static void addPackages(@NotNull Set<MetricEvent> result, @Nullable JsonElement require, boolean isDev) {
        if (result == null) {
            ComposerConfigCollector.$$$reportNull$$$0(5);
        }
        if (require instanceof JsonObject) {
            Set entries = ((JsonObject)require).entrySet();
            for (Map.Entry entry : entries) {
                FeatureUsageData data = new FeatureUsageData().addData("name", (String)entry.getKey()).addData("dev", isDev);
                List<ComposerPackageVersion> versions = ComposerConfigCollector.parseVersions((JsonElement)entry.getValue());
                for (ComposerPackageVersion version : versions) {
                    FeatureUsageData newData = data.copy().addData("version", version.getVersion()).addData("constraint", version.getConstraint().toString());
                    result.add(MetricEventFactoryKt.newMetric((String)"package", (FeatureUsageData)newData));
                }
            }
        }
    }

    @NotNull
    private static List<ComposerPackageVersion> parseVersions(@NotNull JsonElement value) {
        List<ComposerPackageVersion> versions;
        if (value == null) {
            ComposerConfigCollector.$$$reportNull$$$0(6);
        }
        List<ComposerPackageVersion> list = versions = value instanceof JsonPrimitive ? ComposerPackageVersionParser.parseAllVersions(value.getAsString()) : ContainerUtil.emptyList();
        if (versions.isEmpty()) {
            return new SmartList((Object)new ComposerPackageVersion("undefined", ComposerPackageVersion.PackageVersionConstraint.EQUAL));
        }
        List<ComposerPackageVersion> list2 = versions;
        if (list2 == null) {
            ComposerConfigCollector.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    protected JsonElement loadConfig(@Nullable String pathToConfig) {
        if (StringUtil.isNotEmpty((String)pathToConfig)) {
            try {
                VirtualFile config = VirtualFileManager.getInstance().findFileByUrl(VfsUtilCore.pathToUrl((String)pathToConfig));
                return config != null ? ComposerConfigUtils.parseJson(config) : null;
            }
            catch (JsonParseException | IOException throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    protected String getPathToConfig(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(8);
        }
        return ComposerDataService.getInstance(project).getConfigPath();
    }

    @NotNull
    private String getComposerJsonStatus(@NotNull Project project) {
        String path;
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(9);
        }
        if (!StringUtil.isEmptyOrSpaces((String)(path = this.getPathToConfig(project)))) {
            return "configured";
        }
        VirtualFile dir = project.getBaseDir();
        if (dir != null && dir.findChild("composer.json") != null) {
            return "foundInBaseDir";
        }
        Collection files = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)project, (String)"composer.json", (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        return files == null || files.isEmpty() ? "none" : "foundOutOfBaseDir";
    }

    @NotNull
    private static MetricEvent getSyncMetrics(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(10);
        }
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        FeatureUsageData data = new FeatureUsageData();
        data.addData("libs", dataService.isUpdateLibrary());
        data.addData("settings", dataService.getSynchronizationState().name());
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"sync", (FeatureUsageData)data);
        if (metricEvent == null) {
            ComposerConfigCollector.$$$reportNull$$$0(11);
        }
        return metricEvent;
    }

    @NotNull
    private static MetricEvent getExecutorMetric(@NotNull Project project) {
        if (project == null) {
            ComposerConfigCollector.$$$reportNull$$$0(12);
        }
        FeatureUsageData data = new FeatureUsageData();
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        ComposerExecution execution = dataService.getComposerExecution();
        String name = execution.getClass().getName();
        if (execution instanceof ComposerExecutorStatProvider && (ExecutableComposerExecution.class.getName().equals(name) || PharComposerExecution.class.getName().equals(name) || "com.jetbrains.php.remote.composer.ComposerRemoteInterpreterExecution".equals(name))) {
            ComposerExecutorStatProvider provider = (ComposerExecutorStatProvider)((Object)execution);
            data.addData("type", provider.getClass().getSimpleName());
            data.addData("configured", provider.isConfigured());
            data.addData("default", provider.isDefault());
            String remoteInterpreterType = provider.getRemoteInterpreterType(project);
            if (remoteInterpreterType != null) {
                data.addData("interpreterType", remoteInterpreterType);
            }
        } else {
            data.addData("type", "unknown");
        }
        MetricEvent metricEvent = MetricEventFactoryKt.newMetric((String)"executor", (FeatureUsageData)data);
        if (metricEvent == null) {
            ComposerConfigCollector.$$$reportNull$$$0(13);
        }
        return metricEvent;
    }

    public int getVersion() {
        return 4;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/statistics/ComposerConfigCollector";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/statistics/ComposerConfigCollector";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigMetrics";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSyncMetrics";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutorMetric";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addRepositories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPackages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parseVersions";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getPathToConfig";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getComposerJsonStatus";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSyncMetrics";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExecutorMetric";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ComposerPackageWhitelistRule
    extends LocalFileCustomValidationRule {
        protected ComposerPackageWhitelistRule() {
            super("composer_package", ComposerConfigCollector.class, "composer_packages.txt");
        }
    }
}

