/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.run.ComposerScriptRunConfiguration;
import com.jetbrains.php.composer.run.ComposerScriptRunConfigurationSettings;
import com.jetbrains.php.composer.run.ComposerScriptRunConfigurationType;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerScriptRunConfigurationProducer
extends LazyRunConfigurationProducer<ComposerScriptRunConfiguration> {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ConfigurationFactory configurationFactory = ComposerScriptRunConfigurationType.getInstance().getFactory();
        if (configurationFactory == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return configurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull ComposerScriptRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        ComposerScriptRunConfigurationSettings fromContext;
        if (configuration == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((fromContext = ComposerScriptRunConfigurationProducer.createConfigurationSettingsFromContext(context)) == null) {
            return false;
        }
        ComposerScriptRunConfigurationSettings fromConfiguration = (ComposerScriptRunConfigurationSettings)configuration.getSettings();
        fromConfiguration.setPathToComposerJson(fromContext.getPathToComposerJson());
        fromConfiguration.setScript(fromContext.getScript());
        configuration.setName(fromContext.getScript());
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull ComposerScriptRunConfiguration configuration, @NotNull ConfigurationContext context) {
        if (configuration == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        ComposerScriptRunConfigurationSettings fromConfiguration = (ComposerScriptRunConfigurationSettings)configuration.getSettings();
        ComposerScriptRunConfigurationSettings fromContext = ComposerScriptRunConfigurationProducer.createConfigurationSettingsFromContext(context);
        if (fromContext == null) {
            return false;
        }
        if (!Objects.equals(fromContext.getPathToComposerJson(), fromConfiguration.getPathToComposerJson())) {
            return false;
        }
        return Objects.equals(fromContext.getScript(), fromConfiguration.getScript());
    }

    @Nullable
    private static ComposerScriptRunConfigurationSettings createConfigurationSettingsFromContext(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (!((location = context.getLocation()) instanceof PsiLocation)) {
            return null;
        }
        PsiElement element = location.getPsiElement();
        String path = ComposerScriptRunConfigurationProducer.getContainingComposerJsonPath(element);
        if (path == null) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        String script = ComposerConfigUtils.getScriptName(property);
        if (script == null) {
            return null;
        }
        ComposerScriptRunConfigurationSettings settings = new ComposerScriptRunConfigurationSettings();
        settings.setScript(script);
        settings.setPathToComposerJson(path);
        return settings;
    }

    @Nullable
    private static String getContainingComposerJsonPath(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            ComposerScriptRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((file = ComposerConfigUtils.getContainingComposerJsonFile(element)) == null) {
            return null;
        }
        return file.getPath();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/run/ComposerScriptRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/run/ComposerScriptRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurationSettingsFromContext";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingComposerJsonPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

