/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.lib;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.lib.ComposerLibraryManager;
import com.jetbrains.php.config.library.PhpExternalLibrariesNodePatcher;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ComposerLibrariesNodePatcher
implements TreeStructureProvider,
DumbAware {
    @NotNull
    public Collection<AbstractTreeNode<?>> modify(@NotNull AbstractTreeNode<?> parent, @NotNull Collection<AbstractTreeNode<?>> children, ViewSettings settings) {
        if (parent == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(0);
        }
        if (children == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(1);
        }
        if (parent instanceof ExternalLibrariesNode) {
            Collection<AbstractTreeNode<?>> collection = ComposerLibrariesNodePatcher.filterPhpLibIfEmpty(parent, children);
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(2);
            }
            return collection;
        }
        SyntheticLibraryElementNode parentNode = PhpExternalLibrariesNodePatcher.getAsPhpLibraryNode(parent);
        if (parentNode == null) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(3);
            }
            return collection;
        }
        return ComposerLibrariesNodePatcher.filterComposerRoots(children, parentNode);
    }

    private static Collection<AbstractTreeNode<?>> filterPhpLibIfEmpty(AbstractTreeNode parent, Collection<AbstractTreeNode<?>> children) {
        Project project = parent.getProject();
        if (project == null) {
            return children;
        }
        ComposerLibraryManager libraryManager = ComposerLibraryManager.getInstance(project);
        if (!libraryManager.isUpdatingLibrary()) {
            return children;
        }
        return ContainerUtil.filter(children, abstractTreeNode -> !ComposerLibrariesNodePatcher.isEmptyPhpLib(abstractTreeNode, libraryManager));
    }

    private static boolean isEmptyPhpLib(AbstractTreeNode node, ComposerLibraryManager manager) {
        SyntheticLibraryElementNode libraryNode = PhpExternalLibrariesNodePatcher.getAsPhpLibraryNode(node);
        if (libraryNode == null) {
            return false;
        }
        Object nodeValue = node.getValue();
        if (!(nodeValue instanceof SyntheticLibrary)) {
            return false;
        }
        SyntheticLibrary syntheticLibrary = (SyntheticLibrary)nodeValue;
        Collection roots = syntheticLibrary.getSourceRoots();
        for (VirtualFile root : roots) {
            if (manager.isRootToAdd(root)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Collection<AbstractTreeNode<?>> filterComposerRoots(@NotNull Collection<AbstractTreeNode<?>> children, SyntheticLibraryElementNode parentNode) {
        Project project;
        if (children == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(4);
        }
        if ((project = parentNode.getProject()) == null) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(5);
            }
            return collection;
        }
        ComposerLibraryManager libraryManager = ComposerLibraryManager.getInstance(project);
        if (!libraryManager.isUpdatingLibrary()) {
            Collection<AbstractTreeNode<?>> collection = children;
            if (collection == null) {
                ComposerLibrariesNodePatcher.$$$reportNull$$$0(6);
            }
            return collection;
        }
        List list = ContainerUtil.filter(children, abstractTreeNode -> !ComposerLibrariesNodePatcher.isComposerRoot(abstractTreeNode, libraryManager));
        if (list == null) {
            ComposerLibrariesNodePatcher.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean isComposerRoot(AbstractTreeNode node, ComposerLibraryManager libraryManager) {
        if (!(node instanceof PsiDirectoryNode)) {
            return false;
        }
        VirtualFile file = ((PsiDirectoryNode)node).getVirtualFile();
        return libraryManager.isRootToAdd(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/lib/ComposerLibrariesNodePatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/lib/ComposerLibrariesNodePatcher";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "modify";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "filterComposerRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "modify";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterComposerRoots";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

