/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.ide.DataManager;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.actions.ComposerUpdateAction;
import com.jetbrains.php.composer.actions.ComposerUpdatePackageAction;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import com.jetbrains.php.composer.lib.ComposerLibraryManager;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhpNotInstalledPackagesInspection
extends PhpInspection {
    private static final List<String> REQUIRED_SECTIONS = ContainerUtil.newArrayList((Object[])new String[]{"require", "require-dev"});
    @NonNls
    private static final String PHP = "php";
    private static final LocalQuickFix[] ALL_QUICK_FIXES = new LocalQuickFix[]{UpdatePackagesFix.INSTANCE, UpdatePackageFix.INSTANCE};
    private static final LocalQuickFix[] INSTALL_FIXES = new LocalQuickFix[]{InstallPackagesFix.INSTANCE};
    @NonNls
    public static final String EXT_PREFIX = "ext-";

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PhpNotInstalledPackagesInspection.$$$reportNull$$$0(0);
        }
        if (!JsonDialectUtil.isStandardJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpNotInstalledPackagesInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        ComposerDataService dataService = ComposerDataService.getInstance(holder.getProject());
        if (dataService == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpNotInstalledPackagesInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        String path = dataService.getConfigPath();
        if (path == null || !FileUtil.pathsEqual((String)path, (String)file.getVirtualFile().getPath())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpNotInstalledPackagesInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        final List<InstalledPackageData> installedPackagesFromConfig = ComposerConfigUtils.getInstalledPackagesFromConfig(file.getVirtualFile());
        return new JsonElementVisitor(){

            public void visitProperty(@NotNull JsonProperty o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (REQUIRED_SECTIONS.contains(o.getName())) {
                    JsonObject requires = (JsonObject)ObjectUtils.tryCast((Object)o.getValue(), JsonObject.class);
                    if (requires == null) {
                        return;
                    }
                    List packages = requires.getPropertyList();
                    if (packages.isEmpty()) {
                        return;
                    }
                    if (!ComposerLibraryManager.getInstance(o.getProject()).vendorDirExists() && !ApplicationManager.getApplication().isUnitTestMode()) {
                        holder.registerProblem((PsiElement)o.getNameElement(), PhpBundle.message("inspection.json.all.not.installed.packages", PhpNotInstalledPackagesInspection.this.getDisplayName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly ? INSTALL_FIXES : LocalQuickFix.EMPTY_ARRAY);
                        return;
                    }
                    for (JsonProperty composerPackage : packages) {
                        if (composerPackage.getName().equalsIgnoreCase(PhpNotInstalledPackagesInspection.PHP) || composerPackage.getName().startsWith(PhpNotInstalledPackagesInspection.EXT_PREFIX)) continue;
                        if (!ApplicationManager.getApplication().isUnitTestMode() && !ComposerPackagesCache.getPackageNames().contains(composerPackage.getName())) {
                            return;
                        }
                        if (ContainerUtil.exists((Iterable)installedPackagesFromConfig, i -> StringUtil.equalsIgnoreCase((CharSequence)i.getName(), (CharSequence)composerPackage.getName()))) continue;
                        holder.registerProblem((PsiElement)composerPackage.getNameElement(), PhpBundle.message("inspection.json.not.installed.packages", PhpNotInstalledPackagesInspection.this.getDisplayName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly ? ALL_QUICK_FIXES : LocalQuickFix.EMPTY_ARRAY);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$1", "visitProperty"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class BasePackagesFix
    extends PhpQuickFixBase {
        private BasePackagesFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                BasePackagesFix.$$$reportNull$$$0(0);
            }
            if (descriptor == null) {
                BasePackagesFix.$$$reportNull$$$0(1);
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(context -> this.getComposerAction(descriptor).actionPerformed(new AnActionEvent(null, context, "composer.json", new Presentation(), ActionManager.getInstance(), 0)));
        }

        @NotNull
        abstract ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor var1);

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$BasePackagesFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class InstallPackagesFix
    extends BasePackagesFix {
        static InstallPackagesFix INSTANCE = new InstallPackagesFix();

        private InstallPackagesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.packages.install.fix", new Object[0]);
            if (string == null) {
                InstallPackagesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                InstallPackagesFix.$$$reportNull$$$0(1);
            }
            return new ComposerInstallAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$InstallPackagesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$InstallPackagesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UpdatePackageFix
    extends BasePackagesFix {
        static UpdatePackageFix INSTANCE = new UpdatePackageFix();

        private UpdatePackageFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.package.update.fix", new Object[0]);
            if (string == null) {
                UpdatePackageFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                UpdatePackageFix.$$$reportNull$$$0(1);
            }
            return new ComposerUpdatePackageAction(descriptor.getPsiElement().getText());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackageFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackageFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class UpdatePackagesFix
    extends BasePackagesFix {
        static UpdatePackagesFix INSTANCE = new UpdatePackagesFix();

        private UpdatePackagesFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.not.installed.packages.update.fix", new Object[0]);
            if (string == null) {
                UpdatePackagesFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        @NotNull
        ComposerAbstractAction getComposerAction(@NotNull ProblemDescriptor descriptor) {
            if (descriptor == null) {
                UpdatePackagesFix.$$$reportNull$$$0(1);
            }
            return new ComposerUpdateAction();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackagesFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpNotInstalledPackagesInspection$UpdatePackagesFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getComposerAction";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

