/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpComposerDuplicatedRequirementInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(0);
        }
        if (!PhpComposerJsonUtils.insideComposerJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        JsonFile composerJson = (JsonFile)ObjectUtils.tryCast((Object)file, JsonFile.class);
        final JsonObject topLevelObject = JsonUtil.getTopLevelObject((JsonFile)composerJson);
        if (topLevelObject == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpComposerDuplicatedRequirementInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!o.equals(topLevelObject)) {
                    return;
                }
                JsonObject requireSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)o, (String)"require", JsonObject.class);
                JsonObject requireDevSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)o, (String)"require-dev", JsonObject.class);
                if (requireDevSection == null || requireSection == null) {
                    return;
                }
                List requireProperties = requireSection.getPropertyList();
                List requireDevProperties = requireDevSection.getPropertyList();
                Collection intersection = ContainerUtil.intersection((Collection)ContainerUtil.map((Collection)requireProperties, JsonProperty::getName), (Collection)ContainerUtil.map((Collection)requireDevProperties, JsonProperty::getName));
                if (intersection.isEmpty()) {
                    return;
                }
                ContainerUtil.filter((Collection)ContainerUtil.union((Collection)requireDevProperties, (Collection)requireProperties), i -> intersection.contains(i.getName())).forEach(this::markProblem);
            }

            private void markProblem(@NotNull JsonProperty property) {
                if (property == null) {
                    1.$$$reportNull$$$0(1);
                }
                holder.registerProblem((PsiElement)property.getNameElement(), PhpBundle.message("inspection.json.duplicated.packages.0", property.getName()), new LocalQuickFix[]{RemoveRequireDevDuplicateQuickFix.INSTANCE});
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "o";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitObject";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "markProblem";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RemoveRequireDevDuplicateQuickFix
    extends PhpQuickFixBase {
        static RemoveRequireDevDuplicateQuickFix INSTANCE = new RemoveRequireDevDuplicateQuickFix();

        private RemoveRequireDevDuplicateQuickFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.json.duplicated.packages.fix", new Object[0]);
            if (string == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            JsonProperty duplicate;
            JsonObject requireDevSection;
            JsonProperty element;
            JsonObject topLevelObject;
            if (project == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                RemoveRequireDevDuplicateQuickFix.$$$reportNull$$$0(2);
            }
            if ((topLevelObject = JsonUtil.getTopLevelObject((JsonFile)((JsonFile)(element = (JsonProperty)descriptor.getPsiElement().getParent()).getContainingFile()))) != null && (requireDevSection = (JsonObject)JsonUtil.getPropertyValueOfType((JsonObject)topLevelObject, (String)"require-dev", JsonObject.class)) != null && (duplicate = requireDevSection.findProperty(element.getName())) != null) {
                PsiElement forward = PsiTreeUtil.skipWhitespacesForward((PsiElement)duplicate);
                PsiElement backward = PsiTreeUtil.skipWhitespacesBackward((PsiElement)duplicate);
                duplicate.delete();
                if (RemoveRequireDevDuplicateQuickFix.isComma(forward)) {
                    forward.delete();
                } else if (RemoveRequireDevDuplicateQuickFix.isComma(backward)) {
                    backward.delete();
                }
            }
        }

        private static boolean isComma(PsiElement forward) {
            return forward instanceof LeafPsiElement && ((LeafPsiElement)forward).getElementType() == JsonElementTypes.COMMA;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$RemoveRequireDevDuplicateQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/json/PhpComposerDuplicatedRequirementInspection$RemoveRequireDevDuplicateQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

