/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.QuickDocUtil;
import com.intellij.icons.AllIcons;
import com.intellij.json.JsonLanguage;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonPsiUtil;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.Language;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.composer.addDependency.ComposerPackage;
import com.jetbrains.php.composer.addDependency.ComposerPackagesUtil;
import com.jetbrains.php.composer.json.PhpComposerJsonUtils;
import com.jetbrains.php.composer.json.cache.ComposerPackagesCache;
import java.io.IOException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerJsonDocumentationProvider
implements DocumentationProvider,
ExternalDocumentationProvider {
    @NlsSafe
    public static final String NBSP = "&nbsp;";
    @NlsSafe
    public static final String PLACE_HOLDER = "<place>";

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        List<String> urls = null;
        if (element != null) {
            urls = this.getUrls(element);
        }
        if (urls == null && originalElement != null) {
            urls = this.getUrls(originalElement);
        }
        return urls;
    }

    @Nullable
    public List<String> getUrls(PsiElement element) {
        JsonProperty jsonProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if (ComposerJsonDocumentationProvider.hasDocumentationFor(element) && jsonProperty != null) {
            return Collections.singletonList("https://packagist.org/packages/" + jsonProperty.getName());
        }
        return null;
    }

    @Nullable
    public String fetchExternalDocumentation(Project project, PsiElement element, List<String> docUrls, boolean onHover) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                String source;
                String homePage;
                ComposerPackage composerPackage = ComposerPackagesUtil.getPackagistPackage(StringUtil.trimStart((String)((String)docUrls.get(0)), (String)"https://packagist.org/packages/"));
                StringBuilder builder = new StringBuilder();
                builder.append("<div class='definition'><pre>");
                builder.append(composerPackage.getName());
                builder.append(NBSP);
                builder.append("<span class='grayed'>");
                ComposerJsonDocumentationProvider.appendImage(builder, "/plugins/downloads.svg");
                builder.append(NBSP).append(ComposerJsonDocumentationProvider.format(composerPackage.getDownloads()));
                builder.append(NBSP);
                ComposerJsonDocumentationProvider.appendImage(builder, "/plugins/rating.svg");
                builder.append(NBSP).append(ComposerJsonDocumentationProvider.format(composerPackage.getStars()));
                builder.append("</span>");
                builder.append("</pre></div>");
                String description = composerPackage.getDescription();
                if (!StringUtil.isEmptyOrSpaces((String)description)) {
                    builder.append("<div class='content'>");
                    builder.append(description);
                    builder.append("</div>");
                }
                if (!StringUtil.isEmptyOrSpaces((String)(homePage = composerPackage.getHomePage()))) {
                    builder.append("<div class='content'>");
                    ComposerJsonDocumentationProvider.appendLink(builder, homePage, "Homepage");
                    builder.append("</div>");
                }
                if (!StringUtil.isEmptyOrSpaces((String)(source = composerPackage.getSources()))) {
                    builder.append("<div class='content'>");
                    ComposerJsonDocumentationProvider.appendLink(builder, source, "Sources");
                    builder.append("</div>");
                }
                String info = builder.toString();
                ComposerJsonDocumentationProvider.updateQuickDoc(element, info);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
        return PLACE_HOLDER;
    }

    private static void updateQuickDoc(@NotNull PsiElement element, @NotNull @NlsSafe String placeHolderText) {
        if (element == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(0);
        }
        if (placeHolderText == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(1);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            String docText;
            Project project = element.getProject();
            if (project.isDisposed()) {
                return;
            }
            DocumentationComponent component = QuickDocUtil.getActiveDocComponent((Project)project);
            if (component != null && (docText = component.getText()) != null) {
                component.replaceText(docText.replace(PLACE_HOLDER, placeHolderText), element);
            }
        });
    }

    private static String format(long number) {
        return number < 1000000L ? new DecimalFormat("###.#K").format((double)number / 1000.0) : new DecimalFormat("###.#M").format((double)number / 1000000.0);
    }

    private static void appendImage(@NotNull StringBuilder builder, @NotNull String path) {
        if (builder == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(2);
        }
        if (path == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(3);
        }
        builder.append("<img src=\"").append(ComposerJsonDocumentationProvider.getIconUrl(path)).append("\"/>");
    }

    private static void appendLink(@NotNull StringBuilder builder, @NotNull String link, @NotNull String linkText) {
        if (builder == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(4);
        }
        if (link == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(5);
        }
        if (linkText == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(6);
        }
        builder.append("<a href=\"").append(link).append("\">").append(linkText).append("</a>");
    }

    @Nullable
    private static String getIconUrl(String icon) {
        String imgURL = null;
        URL resource = AllIcons.class.getClassLoader().getResource(icon);
        try {
            imgURL = resource != null ? resource.toURI().toURL().toExternalForm() : null;
        }
        catch (Exception exception2) {
            // empty catch block
        }
        return imgURL;
    }

    @Nullable
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof ComposerPackage) {
            Project project;
            Project project2 = project = psiManager != null ? psiManager.getProject() : null;
            if (project != null) {
                return ComposerJsonDocumentationProvider.generateElement(project, ((ComposerPackage)object).getName());
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement generateElement(@NotNull Project project, @NotNull String entry) {
        if (project == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(7);
        }
        if (entry == null) {
            ComposerJsonDocumentationProvider.$$$reportNull$$$0(8);
        }
        @NonNls String jsonText = "{\"require\": {" + StringUtil.wrapWithDoubleQuote((String)entry) + ":\"*\"}}";
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("composer.json", (Language)JsonLanguage.INSTANCE, (CharSequence)jsonText);
        JsonObject topLevelObject = JsonUtil.getTopLevelObject((JsonFile)((JsonFile)psiFile));
        if (topLevelObject == null) {
            return null;
        }
        JsonProperty require = topLevelObject.findProperty("require");
        if (require == null) {
            return null;
        }
        if (require.getValue() != null) {
            JsonProperty entryProperty = ((JsonObject)require.getValue()).findProperty(entry);
            return entryProperty != null ? entryProperty.getNameElement() : null;
        }
        return null;
    }

    public boolean hasDocumentationFor(PsiElement element, PsiElement originalElement) {
        return ComposerJsonDocumentationProvider.hasDocumentationFor(originalElement) || ComposerJsonDocumentationProvider.hasDocumentationFor(element);
    }

    private static boolean hasDocumentationFor(@Nullable PsiElement originalElement) {
        if (originalElement == null) {
            return false;
        }
        JsonProperty jsonProperty = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)originalElement, JsonProperty.class);
        JsonValue jsonValue = (JsonValue)PsiTreeUtil.getParentOfType((PsiElement)originalElement, JsonValue.class, (boolean)false);
        return PhpComposerJsonUtils.insideComposerJson(originalElement) && PhpComposerJsonUtils.insidePackagesSection(originalElement) && jsonProperty != null && ComposerPackagesCache.getPackageNames().contains(jsonProperty.getName()) && jsonValue != null && JsonPsiUtil.isPropertyKey((PsiElement)jsonValue);
    }

    public boolean canPromptToConfigureDocumentation(PsiElement element) {
        return false;
    }

    public void promptToConfigureDocumentation(PsiElement element) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeHolderText";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkText";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/json/ComposerJsonDocumentationProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "updateQuickDoc";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "appendImage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "appendLink";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "generateElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

