/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.json;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.lib.ComposerLibraryManager;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInstallNotifier
implements ComposerConfigFileListener,
Disposable {
    private static final long INITIAL_DELAY_SECONDS = 1L;
    private static final long COMPOSER_CHANGE_DELAY_SECONDS = 3L;
    private static final ComposerInstallAction INSTALL_ACTION = new ComposerInstallAction(){

        @Override
        protected boolean isAllowedPlace(@Nullable String place) {
            return true;
        }
    };
    private final Alarm mySchedulingAlarm;
    private final Project myProject;
    @NonNls
    private static final String NOTIFICATION_GROUP_ID = "Run 'composer install'";
    private final AtomicBoolean isNotificationShown = new AtomicBoolean(false);

    public ComposerInstallNotifier(Project project) {
        this.myProject = project;
        this.mySchedulingAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        ComposerDataService.getInstance(project).addConfigListener(new ComposerConfigListener(){

            @Override
            public void notifyAboutMissingVendorChanged(boolean newStatus) {
                if (newStatus) {
                    ComposerInstallNotifier.this.scheduleComposerInstallNotification(1L);
                }
            }
        });
    }

    @Override
    public void composerConfigInitialized() {
        this.scheduleComposerInstallNotification(3L);
    }

    @Override
    public void composerJsonChanged() {
        this.scheduleComposerInstallNotification(3L);
    }

    @Override
    public void composerLockChanged() {
    }

    public static ComposerInstallNotifier getInstance(Project project) {
        return (ComposerInstallNotifier)ServiceManager.getService((Project)project, ComposerInstallNotifier.class);
    }

    public void dispose() {
    }

    private void scheduleComposerInstallNotification(long delayInSeconds) {
        if (!this.isEnabled()) {
            return;
        }
        this.mySchedulingAlarm.cancelAllRequests();
        this.mySchedulingAlarm.addRequest(() -> ReadAction.nonBlocking(this::composerFileWithoutVendorExists).finishOnUiThread(ModalityState.NON_MODAL, composerFileWithoutVendorExists -> {
            if (composerFileWithoutVendorExists.booleanValue()) {
                this.showNotification();
            }
        }).expireWith((Disposable)this).submit((Executor)NonUrgentExecutor.getInstance()), TimeUnit.SECONDS.toMillis(delayInSeconds));
    }

    private boolean isEnabled() {
        return ComposerDataService.getInstance(this.myProject).isNotifyAboutMissingVendor() && !ApplicationManager.getApplication().isUnitTestMode();
    }

    private void showNotification() {
        Notification notification2 = NotificationGroupManager.getInstance().getNotificationGroup(NOTIFICATION_GROUP_ID).createNotification(PhpBundle.message("notification.content.vendor.directory.not.found", new Object[0]), NotificationType.INFORMATION);
        notification2.addAction((AnAction)NotificationAction.create((String)PhpBundle.message("action.run.composer.install.text", new Object[0]), (e, n) -> {
            INSTALL_ACTION.actionPerformed((AnActionEvent)e);
            notification2.expire();
        }));
        notification2.addAction((AnAction)NotificationAction.createSimple((String)PhpBundle.message("do.not.ask.again", new Object[0]), () -> {
            ComposerDataService.getInstance(this.myProject).setNotifyAboutMissingVendor(false);
            notification2.expire();
        }));
        this.notify(notification2);
    }

    private void notify(Notification notification2) {
        if (!this.isEnabled() || !this.isNotificationShown.compareAndSet(false, true)) {
            return;
        }
        notification2.notify(this.myProject);
        Balloon balloon = notification2.getBalloon();
        if (balloon != null) {
            balloon.addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ComposerInstallNotifier.this.isNotificationShown.set(false);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/json/ComposerInstallNotifier$3", "onClosed"));
                }
            });
        }
        if (notification2.isExpired()) {
            this.isNotificationShown.set(false);
        }
    }

    private void onProjectOpened() {
        this.scheduleComposerInstallNotification(1L);
    }

    private boolean composerFileWithoutVendorExists() {
        ComposerDataService dataService = ComposerDataService.getInstance(this.myProject);
        if (dataService == null) {
            return false;
        }
        String path = dataService.getConfigPath();
        if (path == null) {
            return false;
        }
        VirtualFile configFile = LocalFileSystem.getInstance().findFileByPath(path);
        return configFile != null && !ComposerLibraryManager.getInstance(this.myProject).vendorDirExists();
    }

    public static class MyStartupActivity
    implements StartupActivity.Background {
        public void runActivity(@NotNull Project project) {
            if (project == null) {
                MyStartupActivity.$$$reportNull$$$0(0);
            }
            ComposerInstallNotifier.getInstance(project).onProjectOpened();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/json/ComposerInstallNotifier$MyStartupActivity", "runActivity"));
        }
    }
}

