/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.execution.executable;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerExecutorStatProvider;
import java.util.List;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutableComposerExecution
implements ComposerExecution,
ComposerExecutorStatProvider {
    private static final String ROOT_TAG_NAME = "executable";
    private static final String EXECUTABLE_PATH_ATTRIBUTE = "path";
    @NotNull
    private final String executablePath;

    public ExecutableComposerExecution() {
        this(null);
    }

    public ExecutableComposerExecution(@Nullable String executablePath) {
        this.executablePath = StringUtil.notNullize((String)executablePath);
    }

    @Override
    @NotNull
    public ProcessHandler createProcessHandler(@NotNull Project project, String workingDir, @NotNull List<String> command, @NotNull String commandText) throws ExecutionException {
        if (project == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(0);
        }
        if (command == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(1);
        }
        if (commandText == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(2);
        }
        OSProcessHandler oSProcessHandler = ScriptRunnerUtil.execute((String)this.executablePath, (String)workingDir, null, (String[])ArrayUtilRt.toStringArray(command), null, commandLine -> {
            KillableProcessHandler handler = new KillableProcessHandler(commandLine);
            handler.setShouldKillProcessSoftly(false);
            return handler;
        });
        if (oSProcessHandler == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(3);
        }
        return oSProcessHandler;
    }

    @Override
    public void cancelProcess(@NotNull ProcessHandler handler) {
        if (handler == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(4);
        }
        OSProcessUtil.killProcessTree((Process)((OSProcessHandler)handler).getProcess());
    }

    @Override
    public boolean isWellConfigured(@NotNull Project project, boolean quick) {
        String path;
        if (project == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path = this.executablePath))) {
            return false;
        }
        if (!path.contains("\\") && !path.contains("/")) {
            return true;
        }
        return ComposerDataService.isWellConfigured(path);
    }

    @NotNull
    @NlsSafe
    public String getExecutablePath() {
        String string = this.executablePath;
        if (string == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public boolean isConfigured() {
        return !StringUtil.isEmptyOrSpaces((String)this.executablePath);
    }

    @Override
    public boolean isDefault() {
        return "composer".equals(this.executablePath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutableComposerExecution execution = (ExecutableComposerExecution)o;
        return this.getExecutablePath().equals(execution.getExecutablePath());
    }

    public int hashCode() {
        return Objects.hash(this.getExecutablePath());
    }

    @Override
    @NotNull
    public Element save() {
        Element element = new Element(ROOT_TAG_NAME);
        ComposerUtils.writeAttribute(element, EXECUTABLE_PATH_ATTRIBUTE, this.executablePath);
        Element element2 = element;
        if (element2 == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(7);
        }
        return element2;
    }

    @Nullable
    public static ExecutableComposerExecution load(@NotNull Element element) {
        if (element == null) {
            ExecutableComposerExecution.$$$reportNull$$$0(8);
        }
        if (!ROOT_TAG_NAME.equals(element.getName())) {
            return null;
        }
        String executablePath = element.getAttributeValue(EXECUTABLE_PATH_ATTRIBUTE);
        return new ExecutableComposerExecution(executablePath);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandText";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/execution/executable/ExecutableComposerExecution";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/execution/executable/ExecutableComposerExecution";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecutablePath";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "save";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProcessHandler";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "cancelProcess";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isWellConfigured";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "load";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

