/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.editor;

import com.intellij.codeInsight.intention.IntentionActionWithOptions;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ClickListener;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.HyperlinkLabel;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Objects;
import javax.swing.JLabel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerEditorNotificationPanel
extends EditorNotificationPanel
implements DataProvider {
    @NotNull
    private final VirtualFile myJson;

    ComposerEditorNotificationPanel(@NotNull Project project, @NotNull VirtualFile composerJson) {
        if (project == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(0);
        }
        if (composerJson == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(1);
        }
        this.myJson = composerJson;
        this.createActionLabel(PhpBundle.message("framework.composer.add.dependency.install.button", new Object[0]), "ComposerInstallAction").setToolTipText(PhpBundle.message("action.ComposerInstallAction.description", new Object[0]));
        this.createActionLabel(PhpBundle.message("framework.composer.add.dependency.update.button", new Object[0]), "ComposerUpdateAction").setToolTipText(PhpBundle.message("action.ComposerUpdateAction.description", new Object[0]));
        HyperlinkLabel logLabel = this.createActionLabel(PhpBundle.message("show.log", new Object[0]), () -> ComposerLogService.getInstance(project).getConsoleView().show(null));
        logLabel.setToolTipText(PhpBundle.message("show.log.of.composer.related.actions", new Object[0]));
        final JLabel moreActionsLabel = new JLabel();
        this.myLinksPanel.add(moreActionsLabel);
        moreActionsLabel.setIcon(AllIcons.General.GearPlain);
        moreActionsLabel.setToolTipText(PhpBundle.message("more.actions", new Object[0]));
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                ActionManager manager = ActionManager.getInstance();
                DefaultActionGroup actionGroup = new DefaultActionGroup(new AnAction[]{manager.getAction("ComposerAddDependencyAction"), manager.getAction("ComposerValidateAction"), manager.getAction("ComposerDumpAutoloadAction"), manager.getAction("ComposerStatusAction"), manager.getAction("ComposerClearCacheAction"), manager.getAction("ComposerLicensesAction"), manager.getAction("ComposerDiagnoseAction"), manager.getAction("ComposerDryRunUpdate"), manager.getAction("ComposerSelfUpdateAction")});
                ActionPopupMenu popupMenu = manager.createActionPopupMenu("ComposerEditorNotificationPanel.ExtraActions", (ActionGroup)actionGroup);
                popupMenu.getComponent().show(moreActionsLabel, 0, Objects.requireNonNull(moreActionsLabel).getHeight());
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/editor/ComposerEditorNotificationPanel$1", "onClick"));
            }
        }.installOn((Component)moreActionsLabel);
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        if (dataId == null) {
            ComposerEditorNotificationPanel.$$$reportNull$$$0(2);
        }
        if (CommonDataKeys.VIRTUAL_FILE.is(dataId)) {
            return this.myJson;
        }
        return null;
    }

    @NotNull
    protected String getActionPlace() {
        return "ComposerEditorNotificationPanel";
    }

    public Color getBackground() {
        return EditorNotificationPanel.getToolbarBackground();
    }

    @Nullable
    public IntentionActionWithOptions getIntentionAction() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composerJson";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/editor/ComposerEditorNotificationPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

