/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandRunner;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.actions.update.ComposerUpdateOutputParser;
import com.jetbrains.php.composer.execution.ComposerExecution;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerUpdateAvailabilityService
implements ComposerConfigFileListener,
Disposable {
    private final Project myProject;
    private final Map<String, String> myPackageToAvailableVersions;
    private ProgressIndicator myProgressIndicator;
    private final Object myLock;
    @Nullable
    private Disposable myFileOpenListenerDisposable;

    ComposerUpdateAvailabilityService(@NotNull Project project) {
        if (project == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(0);
        }
        this.myPackageToAvailableVersions = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        this.myLock = new Object();
        this.myProject = project;
        this.createOrUpdateFileOpenedListener();
        ComposerDataService.getInstance(project).addConfigListener(new ComposerConfigListener(){

            @Override
            public void loadUpdateAvailabilityStatusChanged() {
                ComposerUpdateAvailabilityService.this.createOrUpdateFileOpenedListener();
                ComposerUpdateAvailabilityService.this.updateAvailablePackageVersions();
            }
        });
    }

    private void createOrUpdateFileOpenedListener() {
        if (this.myFileOpenListenerDisposable != null) {
            Disposer.dispose((Disposable)this.myFileOpenListenerDisposable);
        }
        if (this.isLoadUpdateAvailability()) {
            this.myFileOpenListenerDisposable = Disposer.newDisposable();
            Disposer.register((Disposable)this, (Disposable)this.myFileOpenListenerDisposable);
            this.myProject.getMessageBus().connect(this.myFileOpenListenerDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

                public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file) {
                    ComposerDataService dataService;
                    if (source == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (file == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if (Objects.equals((dataService = ComposerDataService.getInstance(ComposerUpdateAvailabilityService.this.myProject)).getConfigPath(), file.getPath())) {
                        ComposerUpdateAvailabilityService.this.updateAvailablePackageVersions();
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "source";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "file";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$2";
                    objectArray[2] = "fileOpened";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Override
    public void composerConfigInitialized() {
        this.updateAvailablePackageVersions();
    }

    @Override
    public void composerJsonChanged() {
        this.updateAvailablePackageVersions();
    }

    @Override
    public void composerLockChanged() {
        this.updateAvailablePackageVersions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAvailablePackageVersions() {
        if (!this.isLoadUpdateAvailability()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            ComposerDataService dataService;
            ComposerExecution execution;
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.cancel();
            }
            if (!(execution = (dataService = ComposerDataService.getInstance(this.myProject)).getComposerExecution()).isWellConfigured(this.myProject, true)) {
                return;
            }
            final VirtualFile file = dataService.getCurrentConfigFile();
            if (file == null) {
                return;
            }
            Task.Backgroundable task = new Task.Backgroundable(this.myProject, PhpBundle.message("framework.composer.loading.update.availability", new Object[0])){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    CheckForUpdateResult checkForUpdateResult = ComposerUpdateAvailabilityService.this.executeCommand(indicator, execution, ComposerUpdateAvailabilityService.this.myProject, file);
                    if (indicator.isCanceled()) {
                        return;
                    }
                    ComposerUpdateAvailabilityService.this.updateAvailableVersions(checkForUpdateResult.myReadyToUpdatePackages);
                    ReadAction.run(() -> {
                        if (ComposerUpdateAvailabilityService.this.myProject.isDisposed()) {
                            return;
                        }
                        PsiFile psiFile = PsiManager.getInstance((Project)ComposerUpdateAvailabilityService.this.myProject).findFile(file);
                        if (psiFile != null) {
                            DaemonCodeAnalyzer.getInstance((Project)ComposerUpdateAvailabilityService.this.myProject).restart(psiFile);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$3", "run"));
                }
            };
            this.myProgressIndicator = new BackgroundableProcessIndicator(task);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, this.myProgressIndicator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAvailableVersions(@NotNull Map<String, String> readyToUpdatePackages) {
        if (readyToUpdatePackages == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(1);
        }
        if (!this.isLoadUpdateAvailability()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPackageToAvailableVersions.clear();
            this.myPackageToAvailableVersions.putAll(readyToUpdatePackages);
        }
    }

    private boolean isLoadUpdateAvailability() {
        return ComposerDataService.getInstance(this.myProject).isLoadUpdateAvailability();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getUpdateAvailableVersion(@NotNull String packageName) {
        if (packageName == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(2);
        }
        if (!this.isLoadUpdateAvailability()) {
            return null;
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myPackageToAvailableVersions.get(packageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateAvailableVersion(@NotNull String packageName) {
        if (packageName == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(3);
        }
        if (!this.isLoadUpdateAvailability()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPackageToAvailableVersions.remove(packageName);
        }
    }

    @NotNull
    public CheckForUpdateResult executeCommand(@NotNull ProgressIndicator indicator, @NotNull ComposerExecution execution, @NotNull Project project, @NotNull VirtualFile configFile) {
        if (indicator == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(4);
        }
        if (execution == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(5);
        }
        if (project == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(6);
        }
        if (configFile == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(7);
        }
        ComposerCommandRunner executor = new ComposerCommandRunner(execution, project, configFile.getParent().getPath(), indicator);
        List<String> basicCommand = ComposerUtils.getUpdateSimulationCommand();
        List options = ParametersListUtil.parse((String)"--no-interaction --no-ansi");
        OutputCapturingAdapter outputCapturingAdapter = new OutputCapturingAdapter();
        ComposerCommandRunner.ExecutionResult executionResult = executor.runCommand(ContainerUtil.concat(basicCommand, (List)options), (ProcessListener)outputCapturingAdapter);
        String output = outputCapturingAdapter.getOutput();
        return new CheckForUpdateResult(executionResult, ComposerUpdateOutputParser.parseReadyToUpdatePackages(output));
    }

    public void dispose() {
    }

    public static ComposerUpdateAvailabilityService getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerUpdateAvailabilityService.$$$reportNull$$$0(8);
        }
        return (ComposerUpdateAvailabilityService)ServiceManager.getService((Project)project, ComposerUpdateAvailabilityService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readyToUpdatePackages";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateAvailableVersions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getUpdateAvailableVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeUpdateAvailableVersion";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "executeCommand";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class CheckForUpdateResult {
        @NotNull
        public final ComposerCommandRunner.ExecutionResult myExecutionResult;
        public final @NotNull Map<@NlsSafe String, @NlsSafe String> myReadyToUpdatePackages;

        private CheckForUpdateResult(@NotNull ComposerCommandRunner.ExecutionResult executionResult, @NotNull Map<@NlsSafe String, @NlsSafe String> readyToUpdatePackages) {
            if (executionResult == null) {
                CheckForUpdateResult.$$$reportNull$$$0(0);
            }
            if (readyToUpdatePackages == null) {
                CheckForUpdateResult.$$$reportNull$$$0(1);
            }
            this.myExecutionResult = executionResult;
            this.myReadyToUpdatePackages = readyToUpdatePackages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executionResult";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "readyToUpdatePackages";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$CheckForUpdateResult";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class OutputCapturingAdapter
    extends ProcessAdapter {
        private final StringBuffer myOutputBuilder = new StringBuffer();

        private OutputCapturingAdapter() {
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                OutputCapturingAdapter.$$$reportNull$$$0(0);
            }
            if (outputType == null) {
                OutputCapturingAdapter.$$$reportNull$$$0(1);
            }
            this.myOutputBuilder.append(event.getText());
        }

        public String getOutput() {
            return this.myOutputBuilder.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "event";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "outputType";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/update/ComposerUpdateAvailabilityService$OutputCapturingAdapter";
            objectArray[2] = "onTextAvailable";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

