/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.codeInsight.hints.FactoryInlayHintsCollector;
import com.intellij.codeInsight.hints.InlayHintsSink;
import com.intellij.codeInsight.hints.presentation.InlayPresentation;
import com.intellij.codeInsight.hints.presentation.PresentationFactory;
import com.intellij.json.JsonElementTypes;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.actions.update.ComposerUpdateAvailabilityService;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerPackageVersionInlayCollector
extends FactoryInlayHintsCollector {
    public ComposerPackageVersionInlayCollector(@NotNull Editor editor) {
        if (editor == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(0);
        }
        super(editor);
    }

    public boolean collect(@NotNull PsiElement element, @NotNull Editor editor, @NotNull InlayHintsSink sink) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(2);
        }
        if (sink == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(3);
        }
        this.collectInlayHints(element, sink);
        return true;
    }

    private void collectInlayHints(@NotNull PsiElement element, @NotNull InlayHintsSink sink) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(5);
        }
        Project project = element.getProject();
        if (!(element instanceof JsonProperty)) {
            return;
        }
        String packageName = ComposerPackageVersionInlayCollector.getPackageNameByElement(element);
        if (packageName == null) {
            return;
        }
        String currentVersion = ComposerInstalledPackagesService.getInstance(project).getCurrentPackageVersion(packageName);
        if (currentVersion == null) {
            return;
        }
        String availableVersion = ComposerUpdateAvailabilityService.getInstance(project).getUpdateAvailableVersion(packageName);
        int offset = ComposerPackageVersionInlayCollector.getOffset(element);
        sink.addInlineElement(offset, true, this.formatHintPresentation(ComposerPackageVersionInlayCollector.buildInlayText(currentVersion, availableVersion)), false);
    }

    @NotNull
    private static String buildInlayText(@NotNull String currentVersion, @Nullable String availableVersion) {
        if (currentVersion == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(6);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(currentVersion);
        if (availableVersion != null) {
            stringBuilder.append(", ");
            stringBuilder.append(PhpBundle.message("framework.composer.package.version.available.0", availableVersion));
        }
        String string = stringBuilder.toString();
        if (string == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static int getOffset(@NotNull PsiElement element) {
        if (element == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(8);
        }
        int offset = element.getTextRange().getEndOffset();
        PsiElement nextSibling = element.getNextSibling();
        if (nextSibling instanceof LeafPsiElement && ((LeafPsiElement)nextSibling).getElementType() == JsonElementTypes.COMMA) {
            offset = nextSibling.getTextRange().getEndOffset();
        }
        return offset;
    }

    @NotNull
    private InlayPresentation formatHintPresentation(@NotNull String message) {
        if (message == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(9);
        }
        PresentationFactory factory = this.getFactory();
        InlayPresentation inlayPresentation = factory.roundWithBackground(factory.smallText(message));
        if (inlayPresentation == null) {
            ComposerPackageVersionInlayCollector.$$$reportNull$$$0(10);
        }
        return inlayPresentation;
    }

    @Contract(value="null -> null")
    @Nullable
    private static String getPackageNameByElement(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        if (property == null) {
            return null;
        }
        String packageName = ComposerConfigUtils.getPackageName(property);
        if (packageName == null) {
            return null;
        }
        return packageName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentVersion";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/update/ComposerPackageVersionInlayCollector";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerPackageVersionInlayCollector";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "buildInlayText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "formatHintPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collect";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInlayHints";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildInlayText";
                break;
            }
            case 7: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "formatHintPresentation";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

