/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.InstalledPackageData;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInstalledPackagesService
implements ComposerConfigFileListener {
    private final Map<String, String> myPackageToCurrentVersion;
    private final Object myLock;
    private final Project myProject;

    ComposerInstalledPackagesService(@NotNull Project project) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(0);
        }
        this.myPackageToCurrentVersion = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        this.myLock = new Object();
        this.myProject = project;
    }

    @Override
    public void composerConfigInitialized() {
        this.updateInstalledPackagesVersions();
    }

    @Override
    public void composerJsonChanged() {
    }

    @Override
    public void composerLockChanged() {
        this.updateInstalledPackagesVersions();
    }

    private void updateInstalledPackagesVersions() {
        VirtualFile file = ComposerDataService.getInstance(this.myProject).getCurrentConfigFile();
        if (file == null) {
            return;
        }
        List<InstalledPackageData> installedPackages = ComposerConfigUtils.getInstalledPackagesFromConfig(file);
        this.updateCurrentPackageVersions(installedPackages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateCurrentPackageVersions(@NotNull List<InstalledPackageData> installedPackages) {
        if (installedPackages == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(1);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myPackageToCurrentVersion.clear();
            for (InstalledPackageData installedPackage : installedPackages) {
                this.myPackageToCurrentVersion.put(installedPackage.getName(), installedPackage.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getCurrentPackageVersion(@NotNull String packageName) {
        if (packageName == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(2);
        }
        Object object = this.myLock;
        synchronized (object) {
            return this.myPackageToCurrentVersion.get(packageName);
        }
    }

    public static ComposerInstalledPackagesService getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerInstalledPackagesService.$$$reportNull$$$0(3);
        }
        return (ComposerInstalledPackagesService)ServiceManager.getService((Project)project, ComposerInstalledPackagesService.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerInstalledPackagesService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "updateCurrentPackageVersions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getCurrentPackageVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

