/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.update;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerConfigListener;
import com.jetbrains.php.composer.ComposerConfigUtils;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.update.ComposerConfigFileListener;
import com.jetbrains.php.composer.actions.update.ComposerInstalledPackagesService;
import com.jetbrains.php.composer.actions.update.ComposerUpdateAvailabilityService;
import com.jetbrains.php.composer.json.ComposerInstallNotifier;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerConfigFileChangesTracker
implements Disposable {
    private final VirtualFileListener myComposerJsonListener;
    private final VirtualFileListener myComposerLockListener;
    private VirtualFile myComposerJson;
    private VirtualFile myComposerLock;
    private final List<ComposerConfigFileListener> myConfigFilesListeners;

    public ComposerConfigFileChangesTracker(@NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(0);
        }
        this.myConfigFilesListeners = ContainerUtil.newArrayList((Object[])new ComposerConfigFileListener[]{ComposerInstalledPackagesService.getInstance(project), ComposerUpdateAvailabilityService.getInstance(project), ComposerInstallNotifier.getInstance(project)});
        this.myComposerJsonListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.handleChange(event, null);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                this.handleChange(event, event.getFile());
            }

            private void handleChange(@NotNull VirtualFileEvent event, @Nullable VirtualFile newConfig) {
                VirtualFile file;
                if (event == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (Objects.equals(ComposerConfigFileChangesTracker.this.myComposerJson, file = event.getFile())) {
                    ComposerConfigFileChangesTracker.this.handleComposerJsonChange(newConfig);
                    ComposerConfigFileChangesTracker.this.notifyComposerJsonListeners();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "handleChange";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        this.myComposerLockListener = new VirtualFileListener(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (Objects.equals(ComposerConfigFileChangesTracker.this.myComposerLock, event.getFile())) {
                    LocalFileSystem.getInstance().removeVirtualFileListener(ComposerConfigFileChangesTracker.this.myComposerLockListener);
                    ComposerConfigFileChangesTracker.this.notifyComposerLockListeners();
                }
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (Objects.equals(ComposerConfigFileChangesTracker.this.myComposerLock, event.getFile())) {
                    ComposerConfigFileChangesTracker.this.notifyComposerLockListeners();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contentsChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        final ComposerDataService dataService = ComposerDataService.getInstance(project);
        dataService.addSynchronizationInitListener(newSyncState -> {
            if (newSyncState == ComposerDataService.SynchronizationState.SYNCHRONIZE) {
                this.handleComposerJsonChange(this.myComposerJson);
                this.notifyInitializationListeners();
            }
        });
        dataService.addConfigListener(new ComposerConfigListener(){

            @Override
            public void configPathOrLibraryStatusChanged(boolean oldStatus, boolean newStatus) {
                VirtualFile newConfig = dataService.getCurrentConfigFile();
                if (Objects.equals(newConfig, ComposerConfigFileChangesTracker.this.myComposerJson)) {
                    return;
                }
                ComposerConfigFileChangesTracker.this.handleComposerJsonChange(newConfig);
                ComposerConfigFileChangesTracker.this.notifyInitializationListeners();
            }
        });
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            this.handleComposerJsonChange(dataService.getCurrentConfigFile());
            this.notifyInitializationListeners();
        });
    }

    private void handleComposerJsonChange(@Nullable VirtualFile newConfig) {
        if (this.myComposerJson == null && newConfig != null) {
            LocalFileSystem.getInstance().addVirtualFileListener(this.myComposerJsonListener);
            LocalFileSystem.getInstance().addVirtualFileListener(this.myComposerLockListener);
        } else if (this.myComposerJson != null && newConfig == null) {
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerJsonListener);
            LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerLockListener);
        }
        this.myComposerJson = newConfig;
        this.myComposerLock = ComposerConfigUtils.findLockFile(this.myComposerJson);
    }

    private void notifyInitializationListeners() {
        for (ComposerConfigFileListener listener : this.myConfigFilesListeners) {
            listener.composerConfigInitialized();
        }
    }

    private void notifyComposerJsonListeners() {
        for (ComposerConfigFileListener listener : this.myConfigFilesListeners) {
            listener.composerJsonChanged();
        }
    }

    private void notifyComposerLockListeners() {
        for (ComposerConfigFileListener listener : this.myConfigFilesListeners) {
            listener.composerLockChanged();
        }
    }

    public void dispose() {
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerLockListener);
        LocalFileSystem.getInstance().removeVirtualFileListener(this.myComposerJsonListener);
    }

    public static ComposerConfigFileChangesTracker getInstance(@NotNull Project project) {
        if (project == null) {
            ComposerConfigFileChangesTracker.$$$reportNull$$$0(1);
        }
        return (ComposerConfigFileChangesTracker)ServiceManager.getService((Project)project, ComposerConfigFileChangesTracker.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "com/jetbrains/php/composer/actions/update/ComposerConfigFileChangesTracker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

