/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.lang.lexer.ComposerLogTokenTypes;
import com.jetbrains.php.composer.actions.log.lang.psi.ComposerLogMessage;
import com.jetbrains.php.composer.actions.log.lang.psi.ComposerLogSettingsId;
import com.jetbrains.php.composer.actions.log.lang.psi.ComposerLogText;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;

public class ComposerLogSettingsLineMarkerProvider
implements LineMarkerProvider {
    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        ASTNode node;
        if (element == null) {
            ComposerLogSettingsLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if ((node = element.getNode()).getElementType() != ComposerLogTokenTypes.SUMMARY_TEXT) {
            return null;
        }
        if (element.getPrevSibling() != null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, psi -> psi instanceof ComposerLogMessage);
        if (!(parent instanceof ComposerLogMessage)) {
            return null;
        }
        ComposerLogMessage message = (ComposerLogMessage)parent;
        ComposerLogSettingsId id = message.getComposerLogSettingsId();
        if (id == null) {
            return null;
        }
        ComposerLogText idText = id.getComposerLogText();
        String text = idText.getText();
        ComposerLogMessageBuilder.Settings settings = ComposerLogMessageBuilder.Settings.findById(text);
        if (settings == null) {
            return null;
        }
        return new LineMarkerInfo(element, element.getTextRange(), AllIcons.General.Settings, s -> "Show affected settings", (GutterIconNavigationHandler)new SettingsGutterNavigationHandler(settings), GutterIconRenderer.Alignment.LEFT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/composer/actions/log/ComposerLogSettingsLineMarkerProvider", "getLineMarkerInfo"));
    }

    private static final class SettingsGutterNavigationHandler
    implements GutterIconNavigationHandler<PsiElement> {
        private final ComposerLogMessageBuilder.Settings mySettings;

        private SettingsGutterNavigationHandler(ComposerLogMessageBuilder.Settings settings) {
            this.mySettings = settings;
        }

        public void navigate(MouseEvent e, PsiElement element) {
            this.mySettings.show(element.getProject());
        }
    }
}

