/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions.log;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.util.Alarm;
import com.intellij.util.PathUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.actions.log.ComposerLogConsoleViewInterface;
import com.jetbrains.php.composer.actions.log.ComposerLogFileType;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogPrefixPrinter;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerLogConsoleView
implements ComposerLogConsoleViewInterface {
    private static final Logger LOG = Logger.getInstance(ComposerLogConsoleView.class);
    @NlsSafe
    private static final String CONTENT_NAME = "Composer Log";
    @NlsSafe
    private static final String FILE_NAME = "Composer Log." + ComposerLogFileType.INSTANCE.getDefaultExtension();
    private final MyConsole myConsole;
    private JComponent myComponentForToolwindow;
    private final AtomicReference<ComposerLogService.MessageId> myMessageId;
    private final Semaphore myAttachmentSemaphore;
    private final Queue<PrintingData> myPrintQueue;
    private final Alarm myPrintAlarm;
    private final Object PRINT_LOCK;
    private final ComposerLogPrefixPrinter myPrinter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ComposerLogConsoleView(@NotNull Project project) {
        if (project == null) {
            ComposerLogConsoleView.$$$reportNull$$$0(0);
        }
        this.myMessageId = new AtomicReference<ComposerLogService.MessageId>(ComposerLogService.MessageId.getFirst());
        this.myAttachmentSemaphore = new Semaphore(1, true);
        this.myPrintQueue = new ConcurrentLinkedQueue<PrintingData>();
        this.PRINT_LOCK = new Object();
        this.myConsole = new MyConsole(project);
        this.myPrintAlarm = new Alarm((Disposable)this.myConsole);
        Object object = this.PRINT_LOCK;
        synchronized (object) {
            this.myPrinter = new ComposerLogPrefixPrinter(){

                @Override
                protected void doPrint(String text, @Nullable ConsoleViewContentType contentType, @Nullable HyperlinkInfo info) {
                    if (info == null) {
                        ComposerLogConsoleView.this.myConsole.print(text, contentType == null ? ConsoleViewContentType.NORMAL_OUTPUT : contentType);
                    } else {
                        ComposerLogConsoleView.this.myConsole.printHyperlink(text, info);
                    }
                }
            };
        }
    }

    public void scrollToId(ComposerLogService.MessageId id) {
        Document document = this.myConsole.getEditor().getDocument();
        String text = document.getText();
        int offset = -1;
        if (id != null) {
            offset = text.lastIndexOf(id.getTextPart());
        }
        if (offset != -1) {
            this.myConsole.scrollTo(offset);
        } else {
            this.myConsole.scrollToEnd();
        }
    }

    @Override
    @NotNull
    public ComposerLogMessageBuilder attachMessageBuilder(@Nullable ProgressIndicator indicator, @Nullable ComposerLogMessageBuilder.Settings settings, @Nullable ModalityState modalityState) {
        boolean acquire;
        if (ApplicationManager.getApplication().isDispatchThread()) {
            LOG.error("Waiting for available log might take long.");
        }
        do {
            if (indicator != null) {
                indicator.checkCanceled();
            }
            try {
                acquire = this.myAttachmentSemaphore.tryAcquire(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
        } while (!acquire);
        return new ComposerLogMessageBuilder(this.getNextMessageId(), settings, this, modalityState);
    }

    @Override
    public void detach() {
        this.myAttachmentSemaphore.release();
    }

    public void show(@Nullable ComposerLogService.MessageId id) {
        ComposerLogRunContentDescriptor descriptor;
        ToolWindow toolWindowByDescriptor;
        Project project = this.myConsole.getProject();
        if (project.isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        ComposerLogService service = ComposerLogService.getInstance(project);
        ComposerLogConsoleView consoleView = service.getConsoleView();
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (this.myComponentForToolwindow == null) {
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)this.myConsole.getComponent(), "Center");
            this.myComponentForToolwindow = panel2;
        }
        if ((toolWindowByDescriptor = runContentManager.getToolWindowByDescriptor((RunContentDescriptor)(descriptor = new ComposerLogRunContentDescriptor(this.myComponentForToolwindow)))) != null) {
            runContentManager.toFrontRunContent(executor, (RunContentDescriptor)descriptor);
        } else {
            runContentManager.showRunContent(executor, (RunContentDescriptor)descriptor);
            Content content = descriptor.getAttachedContent();
            if (content != null) {
                content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.FALSE);
                content.setIcon(null);
            }
        }
        consoleView.scrollToId(id);
    }

    @Override
    public void print(ComposerLogConsoleViewInterface.MessagePart messagePart, String text, ConsoleViewContentType type, @Nullable ModalityState modalityState) {
        this.schedulePrinting(modalityState, new PrintingData(messagePart, text, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schedulePrinting(@Nullable ModalityState modalityState, PrintingData printingData) {
        if (!this.myPrintAlarm.isDisposed()) {
            Object object = this.PRINT_LOCK;
            synchronized (object) {
                this.myPrintQueue.add(printingData);
                this.myPrintAlarm.addRequest(this::doPrint, 0, modalityState == null ? ModalityState.defaultModalityState() : modalityState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPrint() {
        while (true) {
            PrintingData poll;
            Object object = this.PRINT_LOCK;
            synchronized (object) {
                poll = this.myPrintQueue.poll();
            }
            if (poll == null) {
                return;
            }
            ApplicationManager.getApplication().runWriteAction(() -> this.myPrinter.print(poll.text, poll.messagePart, poll.type, poll.info));
        }
    }

    @Override
    public void printHyperlink(ComposerLogConsoleViewInterface.MessagePart messagePart, String path, HyperlinkInfo info, @Nullable ModalityState modalityState) {
        this.schedulePrinting(modalityState, new PrintingData(messagePart, path, info));
    }

    @Override
    public void scrollToEnd() {
        ApplicationManager.getApplication().invokeLater(() -> this.myConsole.scrollToEnd());
    }

    @Override
    public boolean isShown() {
        return this.myConsole.getParent() != null;
    }

    private ComposerLogService.MessageId getNextMessageId() {
        return this.myMessageId.getAndUpdate(id -> id.getNextId());
    }

    public Project getProject() {
        return this.myConsole.getProject();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/actions/log/ComposerLogConsoleView", "<init>"));
    }

    private static final class ComposerLogRunContentDescriptor
    extends RunContentDescriptor {
        private ComposerLogRunContentDescriptor(JComponent component) {
            super(null, null, component, ComposerLogConsoleView.CONTENT_NAME);
        }

        public boolean isContentReuseProhibited() {
            return true;
        }

        public int hashCode() {
            return 12;
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == ComposerLogRunContentDescriptor.class;
        }
    }

    private static final class MyConsole
    extends ConsoleViewImpl {
        private VirtualFile myVirtualFile;

        private MyConsole(@NotNull Project project) {
            if (project == null) {
                MyConsole.$$$reportNull$$$0(0);
            }
            super(project, true);
            Disposer.register((Disposable)ComposerLogService.getInstance(project), (Disposable)this);
        }

        @NotNull
        protected EditorEx doCreateConsoleEditor() {
            this.myVirtualFile = MyConsole.createNewLogFile();
            Document document = FileDocumentManager.getInstance().getDocument(this.myVirtualFile);
            LOG.assertTrue(document != null);
            UndoUtil.disableUndoFor((Document)document);
            document.addDocumentListener(new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (event.getOffset() != 0) {
                        return;
                    }
                    if (event.getNewLength() == 0) {
                        String text;
                        if (StringUtil.endsWithChar((CharSequence)event.getOldFragment(), (char)'\n') && (StringUtil.isEmpty((String)(text = event.getDocument().getText())) || StringUtil.startsWith((CharSequence)text, (CharSequence)ComposerLogConsoleViewInterface.MessagePart.ID.getPrefix()))) {
                            int spaceIndex = text.indexOf(32);
                            if (spaceIndex > 0) {
                                ComposerLogService.getInstance(this.getProject()).cleanRerunMap(text.substring(0, spaceIndex));
                            }
                            return;
                        }
                    } else if (StringUtil.startsWith((CharSequence)event.getNewFragment(), (CharSequence)ComposerLogConsoleViewInterface.MessagePart.ID.getPrefix())) {
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                        Document document = this.getEditor().getDocument();
                        String text = document.getText();
                        int index = text.indexOf("\n" + ComposerLogConsoleViewInterface.MessagePart.ID.getPrefix());
                        if (index < 0) {
                            return;
                        }
                        document.deleteString(0, index + 1);
                    }), PhpBundle.message("align.composer.log.console", new Object[0]), null));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/composer/actions/log/ComposerLogConsoleView$MyConsole$1", "documentChanged"));
                }
            }, (Disposable)this);
            EditorFactory editorFactory = EditorFactory.getInstance();
            EditorEx editor = (EditorEx)editorFactory.createEditor(document, this.getProject(), EditorKind.CONSOLE);
            ConsoleViewUtil.setupConsoleEditor((EditorEx)editor, (boolean)true, (boolean)true);
            editor.getGutterComponentEx().setPaintBackground(true);
            EditorEx editorEx = editor;
            if (editorEx == null) {
                MyConsole.$$$reportNull$$$0(1);
            }
            return editorEx;
        }

        private static VirtualFile createNewLogFile() {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            String fullPath = FileUtil.toSystemIndependentName((String)PathManager.getConfigPath()) + "/Composer Log/" + FILE_NAME;
            String ext = PathUtil.getFileExtension((String)FILE_NAME);
            String fileNameExt = PathUtil.getFileName((String)FILE_NAME);
            String fileName = StringUtil.trimEnd((String)fileNameExt, (String)(ext == null ? "" : "." + ext));
            try {
                return (VirtualFile)WriteAction.compute(() -> {
                    VirtualFile dir = VfsUtil.createDirectories((String)PathUtil.getParentPath((String)fullPath));
                    return VfsUtil.createChildSequent((Object)LocalFileSystem.getInstance(), (VirtualFile)dir, (String)fileName, (String)StringUtil.notNullize((String)ext));
                });
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
                return null;
            }
        }

        protected ModalityState getStateForUpdate() {
            return ModalityState.defaultModalityState();
        }

        public void flushDeferredText() {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> super.flushDeferredText()));
        }

        protected void doClear() {
            WriteCommandAction.runWriteCommandAction((Project)this.getProject(), (String)PhpBundle.message("clear.log", new Object[0]), null, () -> super.doClear(), (PsiFile[])new PsiFile[0]);
        }

        public void dispose() {
            super.dispose();
            if (this.myVirtualFile != null) {
                WriteAction.run(() -> {
                    try {
                        this.myVirtualFile.delete((Object)this);
                    }
                    catch (IOException e) {
                        LOG.error((Throwable)e);
                    }
                });
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/composer/actions/log/ComposerLogConsoleView$MyConsole";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/composer/actions/log/ComposerLogConsoleView$MyConsole";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "doCreateConsoleEditor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PrintingData {
        @NotNull
        ComposerLogConsoleViewInterface.MessagePart messagePart;
        @NotNull
        String text;
        @Nullable
        HyperlinkInfo info;
        @Nullable
        ConsoleViewContentType type;

        private PrintingData(@NotNull ComposerLogConsoleViewInterface.MessagePart messagePart, @NotNull String text, @NotNull HyperlinkInfo info) {
            if (messagePart == null) {
                PrintingData.$$$reportNull$$$0(0);
            }
            if (text == null) {
                PrintingData.$$$reportNull$$$0(1);
            }
            if (info == null) {
                PrintingData.$$$reportNull$$$0(2);
            }
            this.messagePart = messagePart;
            this.text = text;
            this.info = info;
        }

        private PrintingData(@NotNull ComposerLogConsoleViewInterface.MessagePart messagePart, @NotNull String text, @NotNull ConsoleViewContentType type) {
            if (messagePart == null) {
                PrintingData.$$$reportNull$$$0(3);
            }
            if (text == null) {
                PrintingData.$$$reportNull$$$0(4);
            }
            if (type == null) {
                PrintingData.$$$reportNull$$$0(5);
            }
            this.messagePart = messagePart;
            this.text = text;
            this.type = type;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "messagePart";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "text";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "info";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/composer/actions/log/ComposerLogConsoleView$PrintingData";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

