/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerUpdateAction
extends ComposerAbstractAction {
    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerUpdateAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerUpdateAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerUpdateAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerUpdateAction.createExecutor(project, configFile, "--no-interaction --no-ansi", placeForStatistics, ComposerActionStatistics.Action.UPDATE_ALL, Collections.singletonList("update"));
        commandExecutor.execute();
    }

    @NotNull
    public static ComposerCommandExecutor createExecutor(final @NotNull Project project, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics, @NotNull ComposerActionStatistics.Action action, final @NotNull List<String> command) {
        if (project == null) {
            ComposerUpdateAction.$$$reportNull$$$0(3);
        }
        if (configFile == null) {
            ComposerUpdateAction.$$$reportNull$$$0(4);
        }
        if (placeForStatistics == null) {
            ComposerUpdateAction.$$$reportNull$$$0(5);
        }
        if (action == null) {
            ComposerUpdateAction.$$$reportNull$$$0(6);
        }
        if (command == null) {
            ComposerUpdateAction.$$$reportNull$$$0(7);
        }
        ComposerExecution execution = ComposerDataService.getInstance(project).getComposerExecution();
        ComposerActionStatistics statistics = ComposerActionStatistics.create(action, placeForStatistics);
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, statistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List list = command;
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.update.task.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.update.action.name", new Object[0]);
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                ComposerUtils.refreshVendorDir(configFile);
                ComposerAbstractAction.refreshConfigAndLockFiles(configFile, () -> PackageComposerConfigClient.updatePackagesSettings(project));
                return success;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                return generatorProject -> {
                    1.checkFileExists(configFile.getPath(), configFile);
                    return ComposerUpdateAction.createExecutor(generatorProject, configFile, commandLineOptions, "ComposerLogRerun", ComposerActionStatistics.Action.UPDATE_ALL, command);
                };
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.update.composer.packages.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("All packages for ").appendFileLink(this.myComposerJson, this.myProject).appendText(" have been updated.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to update packages for  ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerUpdateAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerUpdateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "createExecutor";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

