/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.configData.PackageComposerConfigClient;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerInstallAction
extends ComposerAbstractAction {
    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerInstallAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerInstallAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerInstallAction.$$$reportNull$$$0(2);
        }
        ComposerCommandExecutor commandExecutor = ComposerInstallAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), configFile, "--no-interaction --no-ansi", placeForStatistics, false);
        commandExecutor.execute();
    }

    @NotNull
    public static ComposerCommandExecutor createExecutor(final @NotNull Project project, @NotNull ComposerExecution execution, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @Nullable String placeForStatistics, boolean isLogCommand) {
        if (project == null) {
            ComposerInstallAction.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerInstallAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerInstallAction.$$$reportNull$$$0(5);
        }
        ComposerActionStatistics statistics = placeForStatistics != null ? ComposerActionStatistics.create(ComposerActionStatistics.Action.INSTALL, placeForStatistics) : null;
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, statistics, true, isLogCommand){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = Collections.singletonList("install");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.install.task.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.install.action.name", new Object[0]);
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                ComposerUtils.refreshVendorDir(configFile);
                ComposerAbstractAction.refreshConfigAndLockFiles(configFile, () -> PackageComposerConfigClient.updatePackagesSettings(project));
                return success;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                return ComposerInstallAction.createGenerator(this.myExecution, configFilePath, commandLineOptions);
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("install.composer.packages.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("All packages for ").appendFileLink(this.myComposerJson, this.myProject).appendText(" have been installed.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage().appendText("Failed to install packages for  ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerInstallAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createGenerator(@NotNull ComposerExecution execution, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (execution == null) {
            ComposerInstallAction.$$$reportNull$$$0(6);
        }
        if (configFilePath == null) {
            ComposerInstallAction.$$$reportNull$$$0(7);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerInstallAction.createExecutor(generatorProject, execution, generatorConfigFile, commandLineOptions, "ComposerLogRerun", false);
        };
        if (throwableNotNullFunction == null) {
            ComposerInstallAction.$$$reportNull$$$0(8);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerInstallAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerInstallAction";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createGenerator";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

