/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.actions.ComposerAbstractAction;
import com.jetbrains.php.composer.actions.ComposerActionCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerDumpAutoloadDialog;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerDumpAutoloadAction
extends ComposerAbstractAction {
    @NonNls
    public static final String ID = "ComposerDumpAutoloadAction";

    @Override
    protected void doPerformAction(@NotNull Project project, @NotNull VirtualFile configFile, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(0);
        }
        if (configFile == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(1);
        }
        if (placeForStatistics == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(2);
        }
        String options = ComposerOptionsManager.getCommandLineOptions(project, ComposerOptionsManager.Command.DUMP_AUTOLOAD, configFile);
        ComposerDumpAutoloadDialog dialog = new ComposerDumpAutoloadDialog(project);
        dialog.setCommandLineOptions(options);
        boolean ok = dialog.showAndGet();
        if (!ok) {
            return;
        }
        options = dialog.getCommandLineOptions();
        ComposerOptionsManager.setCommandLineOptions(project, ComposerOptionsManager.Command.DUMP_AUTOLOAD, configFile, options);
        ComposerCommandExecutor commandExecutor = ComposerDumpAutoloadAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), configFile, options, placeForStatistics);
        commandExecutor.execute();
    }

    @NotNull
    protected static ComposerCommandExecutor createExecutor(@NotNull Project project, @NotNull ComposerExecution execution, final @NotNull VirtualFile configFile, final @Nullable String commandLineOptions, @NotNull String placeForStatistics) {
        if (project == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(3);
        }
        if (execution == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(4);
        }
        if (configFile == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(5);
        }
        if (placeForStatistics == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(6);
        }
        ComposerActionStatistics actionStatistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.DUMP_AUTOLOAD, placeForStatistics);
        return new ComposerActionCommandExecutor.WithConfig(project, execution, configFile, commandLineOptions, actionStatistics, true, false){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = Collections.singletonList("dump-autoload");
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                String configFilePath = configFile.getPath();
                return ComposerDumpAutoloadAction.createExecutorGenerator(this.myExecution, configFilePath, commandLineOptions);
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Autoloader is successfully updated for ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Composer failed to update autoloader for ").appendFileLink(this.myComposerJson, this.myProject).appendText(".");
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("generating.autoloader", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return "dump-autoload";
            }

            @Override
            @Nls(capitalization=Nls.Capitalization.Title)
            @NotNull
            protected String getTaskTitle() {
                String string = PhpBundle.message("composer.generating.autoloader.task.title", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/jetbrains/php/composer/actions/ComposerDumpAutoloadAction$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBasicCommand";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getTaskTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    private static ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> createExecutorGenerator(@NotNull ComposerExecution execution, @NotNull String configFilePath, @Nullable String commandLineOptions) {
        if (execution == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(7);
        }
        if (configFilePath == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(8);
        }
        ThrowableNotNullFunction throwableNotNullFunction = generatorProject -> {
            VirtualFile generatorConfigFile = LocalFileSystem.getInstance().findFileByPath(configFilePath);
            ComposerCommandExecutor.checkFileExists(configFilePath, generatorConfigFile);
            return ComposerDumpAutoloadAction.createExecutor(generatorProject, execution, generatorConfigFile, commandLineOptions, "ComposerLogRerun");
        };
        if (throwableNotNullFunction == null) {
            ComposerDumpAutoloadAction.$$$reportNull$$$0(9);
        }
        return throwableNotNullFunction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeForStatistics";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerDumpAutoloadAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerDumpAutoloadAction";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createExecutorGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPerformAction";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createExecutor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createExecutorGenerator";
                break;
            }
            case 9: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

