/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer.actions;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.actions.ComposerCommandRunner;
import com.jetbrains.php.composer.actions.ComposerExecutionException;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComposerCommandExecutor {
    private static final int MAX_COMMAND_ELEMENT_LENGTH = 25;
    @NotNull
    protected final Project myProject;
    protected final String myWorkingDir;
    @Nullable
    protected final String myCommandLineOptions;
    @NotNull
    protected final ComposerExecution myExecution;
    @Nullable
    private final ComposerActionStatistics myActionStatistics;
    private final boolean myReportInEventLog;
    private final boolean myIsLogCommand;

    protected ComposerCommandExecutor(@NotNull Project project, String dir, @Nullable String commandLineOptions, @NotNull ComposerExecution execution, @Nullable ComposerActionStatistics actionStatistics, boolean reportInEventLog, boolean isLogCommand) {
        if (project == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(0);
        }
        if (execution == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myWorkingDir = dir;
        this.myCommandLineOptions = commandLineOptions;
        this.myExecution = execution;
        this.myActionStatistics = actionStatistics;
        this.myReportInEventLog = reportInEventLog && !isLogCommand;
        this.myIsLogCommand = isLogCommand;
    }

    public abstract void execute();

    /*
     * WARNING - void declaration
     */
    protected void doRun(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(2);
        }
        indicator.setIndeterminate(true);
        if (this.myIsLogCommand) {
            ApplicationManager.getApplication().invokeLater(() -> ComposerLogService.getInstance(this.myProject).getConsoleView().show(null));
        }
        ComposerLogMessageBuilder builder = ComposerLogService.getInstance(this.myProject).getConsoleView().attachMessageBuilder(indicator, null, indicator.getModalityState());
        List<String> basicCommand = this.getBasicCommand();
        List options = this.myCommandLineOptions == null ? Collections.emptyList() : ParametersListUtil.parse((String)this.myCommandLineOptions);
        ArrayList<String> command = new ArrayList<String>(basicCommand.size() + options.size());
        command.addAll(basicCommand);
        command.addAll(options);
        StringBuilder sb = new StringBuilder();
        sb.append(PhpBundle.message("framework.composer.add.dependency.running", new Object[0]));
        for (String string : command) {
            void var8_8;
            if (string.length() > 25) {
                String string2 = "..." + string.substring(string.length() - 25);
            }
            sb.append(" ").append((String)var8_8);
        }
        @NlsSafe String text = sb.toString();
        indicator.setText(text);
        if (this.myActionStatistics != null) {
            this.myActionStatistics.report(this.myProject);
        }
        builder.printCommand(StringUtil.join(command, (String)" "), this.getExecutorGenerator(), this.myProject);
        List<Pair<String, Key>> list = Collections.synchronizedList(new ArrayList());
        ComposerCommandRunner commandExecutor = new ComposerCommandRunner(this.myExecution, this.myProject, this.myWorkingDir, indicator);
        PrintingProcessListener listener = new PrintingProcessListener(this.createTextListener(indicator, builder, list));
        ComposerCommandRunner.ExecutionResult executionResult = commandExecutor.runCommand(command, (ProcessListener)listener);
        boolean cancelledByUser = executionResult.myProgressIndicatorCancelled;
        boolean success = executionResult.isSuccess() && !list.isEmpty();
        success = this.handleAfterCommandExecution(success);
        if (indicator.isCanceled()) {
            cancelledByUser = true;
            success = false;
        }
        this.reportFeedback(builder, command, success, list, executionResult.myException, cancelledByUser);
    }

    @NotNull
    protected ComposerTextListener createTextListener(@NotNull ProgressIndicator indicator, @NotNull ComposerLogMessageBuilder builder, @NotNull List<Pair<String, Key>> output) {
        if (indicator == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(3);
        }
        if (builder == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(4);
        }
        if (output == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(5);
        }
        return new ComposerBaseTextListener(builder, output, indicator);
    }

    protected void reportFeedback(@NotNull ComposerLogMessageBuilder builder, @NotNull List<String> command, boolean success, List<Pair<String, Key>> output, @Nullable ExecutionException exception2, boolean cancelledByUser) {
        ComposerLogMessageBuilder.SummaryMessage summary;
        NotificationType notificationType;
        if (builder == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(6);
        }
        if (command == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(7);
        }
        if (success) {
            notificationType = NotificationType.INFORMATION;
            summary = this.createSuccessfulSummary();
        } else {
            notificationType = NotificationType.ERROR;
            summary = this.createFailureSummary();
            if (cancelledByUser) {
                notificationType = NotificationType.INFORMATION;
                summary.appendText(" Script was cancelled.");
            }
            if (exception2 != null) {
                summary.appendText("\n");
                if (exception2 instanceof ComposerExecutionException) {
                    for (Pair<String, ? extends HyperlinkInfo> pair : ((ComposerExecutionException)exception2).myText) {
                        if (pair.second == null) {
                            summary.appendText((String)pair.first);
                            continue;
                        }
                        summary.appendLink((String)pair.first, (HyperlinkInfo)pair.second);
                    }
                } else {
                    summary.appendText(exception2.getMessage());
                }
            }
        }
        builder.printSummary(summary, success, this.reportInEventLog(), notificationType, this.myProject);
    }

    protected abstract ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary();

    protected abstract ComposerLogMessageBuilder.SummaryMessage createFailureSummary();

    protected boolean reportInEventLog() {
        return this.myReportInEventLog;
    }

    @Nls
    protected abstract String getProgressTitle();

    @NlsSafe
    protected abstract String getActionName();

    @NotNull
    protected abstract List<String> getBasicCommand();

    protected boolean handleAfterCommandExecution(boolean success) {
        return success;
    }

    @Nullable
    protected abstract ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator();

    @NotNull
    public static String createText(@NotNull List<? extends Pair<String, Key>> parts) {
        if (parts == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(8);
        }
        if (parts.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        for (Pair<String, Key> pair : parts) {
            builder.append((String)pair.first);
        }
        String string = builder.toString();
        if (string == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static void checkFileExists(@NotNull String configFilePath, @Nullable VirtualFile configFile) throws ExecutionException {
        if (configFilePath == null) {
            ComposerCommandExecutor.$$$reportNull$$$0(10);
        }
        if (configFile == null) {
            throw new ExecutionException(PhpBundle.message("file.0.does.not.exist", configFilePath));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "execution";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parts";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createTextListener";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reportFeedback";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createText";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkFileExists";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static class ComposerBaseTextListener
    extends ComposerTextListener {
        private final ComposerLogMessageBuilder myBuilder;
        private final List<? super Pair<String, Key>> myOutput;
        private final ProgressIndicator myIndicator;

        public ComposerBaseTextListener(@NotNull ComposerLogMessageBuilder builder, @NotNull List<? super Pair<String, Key>> output, @NotNull ProgressIndicator indicator) {
            if (builder == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(0);
            }
            if (output == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(1);
            }
            if (indicator == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(2);
            }
            this.myBuilder = builder;
            this.myOutput = output;
            this.myIndicator = indicator;
        }

        @Override
        void textAvailable(@NotNull @NlsSafe String text, @NotNull Key attributes, @NotNull Key outputType) {
            if (text == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(3);
            }
            if (attributes == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(4);
            }
            if (outputType == null) {
                ComposerBaseTextListener.$$$reportNull$$$0(5);
            }
            this.myBuilder.printOutputPart(text, attributes);
            this.myOutput.add((Pair<String, Key>)Pair.create((Object)text, (Object)attributes));
            String indicatorText = StringUtil.notNullize((String)this.myIndicator.getText2()) + text;
            if (indicatorText.length() > 60) {
                indicatorText = "..." + indicatorText.substring(indicatorText.length() - 60);
            }
            this.myIndicator.setText2(indicatorText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$ComposerBaseTextListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "textAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static abstract class ComposerTextListener
    implements AnsiEscapeDecoder.ColoredTextAcceptor {
        private Key myOutputType;

        abstract void textAvailable(@NotNull @NlsSafe String var1, @NotNull Key var2, @NotNull Key var3);

        public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
            if (text == null) {
                ComposerTextListener.$$$reportNull$$$0(0);
            }
            if (attributes == null) {
                ComposerTextListener.$$$reportNull$$$0(1);
            }
            this.textAvailable(text, attributes, this.myOutputType);
        }

        public void setOutputType(Key outputType) {
            this.myOutputType = outputType;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                ComposerTextListener.$$$reportNull$$$0(2);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "attributes";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$ComposerTextListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coloredTextAvailable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static final class PrintingProcessListener
    extends ProcessAdapter {
        private final AnsiEscapeDecoder myAnsiEscapeDecoder;
        @NotNull
        private final ComposerTextListener myListener;
        private boolean firstSystemShown;
        private final Object LOCK;

        private PrintingProcessListener(@NotNull ComposerTextListener listener) {
            if (listener == null) {
                PrintingProcessListener.$$$reportNull$$$0(0);
            }
            this.myAnsiEscapeDecoder = new AnsiEscapeDecoder();
            this.firstSystemShown = false;
            this.LOCK = new Object();
            this.myListener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                PrintingProcessListener.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                PrintingProcessListener.$$$reportNull$$$0(2);
            }
            String text = event.getText();
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.firstSystemShown && outputType == ProcessOutputTypes.SYSTEM) {
                    this.firstSystemShown = true;
                    return;
                }
                this.myListener.setOutputType(outputType);
                this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this.myListener);
                this.myListener.setOutputType(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                PrintingProcessListener.$$$reportNull$$$0(3);
            }
            Object object = this.LOCK;
            synchronized (object) {
                this.myListener.processTerminated(event);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/composer/actions/ComposerCommandExecutor$PrintingProcessListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

