/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.TextAccessor;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.config.interpreters.PhpInterpretersManagerImpl;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InterpretersComboWithBrowseButton
extends ComponentWithBrowseButton<EditorComboBox>
implements TextAccessor {
    public InterpretersComboWithBrowseButton(@Nullable Project project) {
        super((JComponent)new EditorComboBox("", project, (FileType)FileTypes.PLAIN_TEXT), null);
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        fileDescriptor.setTitle(PhpBundle.message("framework.composer.path.to.php.executable.titled", new Object[0]));
        fileDescriptor.setDescription(PhpBundle.message("framework.composer.specify.php.executable.0", PhpProjectConfigurationFacade.PHP_EXECUTABLE));
        PhpInterpretersManagerImpl manager = PhpInterpretersManagerImpl.getInstance(project);
        final String initialPhpPath = InterpretersComboWithBrowseButton.getDefaultPhpPath(project);
        HashSet<String> paths = new HashSet<String>();
        paths.add(initialPhpPath);
        LocalFileSystem fileSystem = LocalFileSystem.getInstance();
        for (PhpInterpreter interpreter : manager.getInterpreters()) {
            String phpHome;
            if (interpreter.isRemote() || StringUtil.isEmpty((String)(phpHome = interpreter.getPathToPhpExecutable())) || fileSystem.findFileByPath(phpHome) == null) continue;
            paths.add(phpHome);
        }
        this.getCombo().setHistory(ArrayUtilRt.toStringArray(paths));
        this.getCombo().setSelectedItem((Object)initialPhpPath);
        ComponentWithBrowseButton.BrowseFolderActionListener<EditorComboBox> listener = new ComponentWithBrowseButton.BrowseFolderActionListener<EditorComboBox>(null, null, (ComponentWithBrowseButton)this, null, fileDescriptor, EditorComboBox.COMPONENT_ACCESSOR){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file = LocalFileSystem.getInstance().findFileByPath(initialPhpPath);
                if (file != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        };
        this.addActionListener((ActionListener)listener);
    }

    public ValidationInfo validatePhpPath(@NotNull Project project) {
        if (project == null) {
            InterpretersComboWithBrowseButton.$$$reportNull$$$0(0);
        }
        String path = this.getText();
        EditorComboBox component = this.getCombo();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.empty.path.to.0", PhpProjectConfigurationFacade.PHP_EXECUTABLE), (JComponent)component);
        }
        if ((path = path.trim()).equals(PhpProjectConfigurationFacade.PHP_EXECUTABLE)) {
            return null;
        }
        if (path.equals(InterpretersComboWithBrowseButton.getDefaultProjectInterpreter())) {
            PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
            if (interpreter == null) {
                return new ValidationInfo(PhpBundle.message("framework.composer.default.interpreter.is.not.configured", new Object[0]), (JComponent)component);
            }
            if (interpreter.isRemote()) {
                return new ValidationInfo(PhpBundle.message("framework.composer.default.interpreter.for.this.project.is.remote", new Object[0]), (JComponent)component);
            }
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.file.0.is.not.found", path), (JComponent)component);
        }
        if (file.isDirectory()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.validation.0.is.a.directory", path), (JComponent)component);
        }
        return null;
    }

    @NotNull
    @NlsSafe
    public static String getDefaultPhpPath(Project project) {
        if (project == null) {
            String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            if (string == null) {
                InterpretersComboWithBrowseButton.$$$reportNull$$$0(1);
            }
            return string;
        }
        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
        if (interpreter == null || interpreter.isRemote()) {
            String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
            if (string == null) {
                InterpretersComboWithBrowseButton.$$$reportNull$$$0(2);
            }
            return string;
        }
        String phpHome = interpreter.getPathToPhpExecutable();
        if (!StringUtil.isEmpty((String)phpHome)) {
            String string = phpHome;
            if (string == null) {
                InterpretersComboWithBrowseButton.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PhpProjectConfigurationFacade.PHP_EXECUTABLE;
        if (string == null) {
            InterpretersComboWithBrowseButton.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getText() {
        return this.getCombo().getText().trim();
    }

    public void setText(String text) {
        UIUtil.invokeLaterIfNeeded(() -> this.getCombo().setText(text));
    }

    public EditorComboBox getCombo() {
        return (EditorComboBox)this.getChildComponent();
    }

    @Nullable
    public String getPhpPath() {
        String path = this.getText();
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return "";
        }
        if (path.equals(InterpretersComboWithBrowseButton.getDefaultProjectInterpreter())) {
            return null;
        }
        return path;
    }

    private static String getDefaultProjectInterpreter() {
        return PhpBundle.message("framework.composer.default.project.interpreter", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/InterpretersComboWithBrowseButton";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/InterpretersComboWithBrowseButton";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPhpPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "validatePhpPath";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

