/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerNotifierUtils;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.actions.log.ComposerLogService;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComposerSettingSyncConfigClient<T>
extends ComposerConfigClient<T> {
    public static final Logger LOG = Logger.getInstance(ComposerSettingSyncConfigClient.class);
    public static final String DISABLED = "disabled";
    public static final String ENABLED = "enabled";

    public boolean updateSetting(@NotNull Project var1, @Nullable T var2);

    @NotNull
    public String getSettingTitle();

    @NotNull
    public ComposerLogMessageBuilder.Settings showSettings();

    default public boolean isDefaultSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(0);
        }
        return true;
    }

    @Override
    default public void consume(@Nullable T setting, @NotNull Project project) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(1);
        }
        if (setting == null) {
            return;
        }
        Application app = ApplicationManager.getApplication();
        if (ComposerDataService.getInstance(project).getSynchronizationState() == ComposerDataService.SynchronizationState.SYNCHRONIZE || app.isHeadlessEnvironment() && !app.isUnitTestMode()) {
            LOG.info("Composer synchronization is enabled -> update IDE settings based on composer.json");
            boolean updated = this.updateSetting(project, setting);
            if (updated) {
                ComposerSettingSyncConfigClient.notifyAboutUpdates(project, this.getSettingTitle(), this.showSettings());
            }
        }
    }

    public static void initOrSuggestSync(@NotNull Project project) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(2);
        }
        if (ComposerSettingSyncConfigClient.isDefaultAllSettings(project, ComposerDataService.getInstance(project).getConfigPath())) {
            ComposerSettingSyncConfigClient.setSyncState(ComposerDataService.SynchronizationState.SYNCHRONIZE, project);
        } else {
            String title = PhpBundle.message("actions.detect.common.setting.from.composer.suggest.title", new Object[0]);
            String message = PhpBundle.message("action.detect.user.settings.state.overwritten.short", new Object[0]);
            ComposerNotifierUtils.showNotification(project, title, message, ComposerSettingSyncConfigClient.getSyncStateAction(project, ComposerDataService.SynchronizationState.SYNCHRONIZE), ComposerSettingSyncConfigClient.getSyncStateAction(project, ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE));
        }
    }

    public static void setSyncState(@NotNull ComposerDataService.SynchronizationState state, @NotNull Project project) {
        if (state == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(3);
        }
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(4);
        }
        DumbService.getInstance((Project)project).smartInvokeLater(() -> {
            ComposerDataService.getInstance(project).setSynchronizationState(state);
            String title = PhpBundle.message("actions.detect.common.settings.composer.sync.state.title", state == ComposerDataService.SynchronizationState.SYNCHRONIZE ? ENABLED : DISABLED);
            ComposerLogService.getInstance(project).report(title, ComposerLogMessageBuilder.Settings.COMPOSER, true, null, false);
        });
    }

    public static void notifyAboutUpdates(@NotNull Project project, @NotNull String settingTitle, ComposerLogMessageBuilder.Settings settings) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(5);
        }
        if (settingTitle == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(6);
        }
        String title = PhpBundle.message("actions.detect.common.settings.updated.from.composer.title", settingTitle);
        ComposerLogService.getInstance(project).report(title, settings, true, null, false);
    }

    public static boolean isDefaultAllSettings(@NotNull Project project, @Nullable String composerJsonPath) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(7);
        }
        return Arrays.stream((ComposerConfigClient[])ComposerConfigClient.EP_NAME.getExtensions()).filter(ComposerSettingSyncConfigClient.class::isInstance).map(ComposerSettingSyncConfigClient.class::cast).allMatch(i -> i.isDefaultSettings(project, composerJsonPath));
    }

    public static NotificationAction getSyncStateAction(final @NotNull Project project, final @NotNull ComposerDataService.SynchronizationState state) {
        if (project == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(8);
        }
        if (state == null) {
            ComposerSettingSyncConfigClient.$$$reportNull$$$0(9);
        }
        return new NotificationAction(PhpBundle.message(state == ComposerDataService.SynchronizationState.SYNCHRONIZE ? "actions.detect.common.setting.from.composer.enable" : "actions.detect.common.setting.from.composer.disable", new Object[0])){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                ComposerSettingSyncConfigClient.setSyncState(state, project);
                notification2.expire();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/php/composer/ComposerSettingSyncConfigClient$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingTitle";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/ComposerSettingSyncConfigClient";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "consume";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initOrSuggestSync";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setSyncState";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "notifyAboutUpdates";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isDefaultAllSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getSyncStateAction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

