/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.util.PlatformUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPackagedVersionedCommandExecutor;
import com.jetbrains.php.composer.ComposerProjectPeer;
import com.jetbrains.php.composer.ComposerProjectSettings;
import com.jetbrains.php.composer.ComposerUtils;
import com.jetbrains.php.composer.actions.ComposerCommandExecutor;
import com.jetbrains.php.composer.actions.ComposerInstallAction;
import com.jetbrains.php.composer.actions.ComposerOptionsManager;
import com.jetbrains.php.composer.actions.log.ComposerLogMessageBuilder;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.statistics.ComposerActionStatistics;
import icons.PhpIcons;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerProjectGenerator
extends WebProjectTemplate<ComposerProjectSettings> {
    private static final Logger LOG = Logger.getInstance(ComposerProjectGenerator.class);

    @Nls
    @NotNull
    public String getName() {
        String string = PhpBundle.message("framework.composer.project.generator.name", new Object[0]);
        if (string == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    public String getDescription() {
        return PhpBundle.message("framework.composer.project.generator.description", new Object[0]);
    }

    public Icon getIcon() {
        return PhpIcons.Composer;
    }

    public boolean isPrimaryGenerator() {
        return PlatformUtils.isPhpStorm();
    }

    public void generateProject(final @NotNull Project project, @NotNull VirtualFile baseDir, final @NotNull ComposerProjectSettings settings, final @NotNull Module module) {
        ComposerExecution execution;
        if (project == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(1);
        }
        if (baseDir == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(3);
        }
        if (module == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(4);
        }
        final File baseDirFile = new File(baseDir.getPath());
        final File tempFile = FileUtil.findSequentNonexistentFile((File)baseDirFile, (String)"composer", (String)"");
        tempFile.delete();
        if (settings.isDownload()) {
            VirtualFile file = ComposerUtils.downloadPhar(project, null, baseDir.getPath());
            if (file == null) {
                Notification errorNotification = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer.project.generation.error.title", new Object[0]), PhpBundle.message("framework.composer.failed.to.download.composer.phar", new Object[0]), NotificationType.ERROR, null);
                Notifications.Bus.notify((Notification)errorNotification, (Project)project);
                LOG.warn("Cannot download composer.phar file");
                return;
            }
            ComposerExecution initialData = settings.getExecution();
            execution = initialData.addPharDownloadPath(file.getPath());
        } else {
            execution = settings.getExecution();
        }
        ComposerProjectGenerator.excludeDir(tempFile, module);
        ComposerActionStatistics statistics = ComposerActionStatistics.create(ComposerActionStatistics.Action.CREATE_PROJECT, "unknown");
        ComposerOptionsManager.setCommandLineOptions(null, ComposerOptionsManager.Command.CREATE_PROJECT, null, settings.getOptions());
        ComposerPackagedVersionedCommandExecutor executor = new ComposerPackagedVersionedCommandExecutor(project, settings.getPackage().getName(), settings.getVersion(), baseDir.getPath(), settings.getOptions(), execution, statistics, true){

            @Override
            @NotNull
            protected List<String> getBasicCommand() {
                List<String> list = ComposerUtils.getCreateProjectCommand(settings.getPackage(), this.myVersion, FileUtil.getRelativePath((File)baseDirFile, (File)tempFile));
                if (list == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list;
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createSuccessfulSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Project was successfully created by Composer.");
            }

            @Override
            protected ComposerLogMessageBuilder.SummaryMessage createFailureSummary() {
                return new ComposerLogMessageBuilder.SummaryMessage("Failed to run 'create-project' command.");
            }

            @Override
            @Nls
            protected String getProgressTitle() {
                return PhpBundle.message("framework.composer.create.project.progress.title", new Object[0]);
            }

            @Override
            @NlsSafe
            protected String getActionName() {
                return PhpBundle.message("framework.composer.create.project.from", new Object[0]);
            }

            @Override
            protected boolean handleAfterCommandExecution(boolean success) {
                String[] list;
                if (tempFile.isDirectory() && (list = tempFile.list()) != null && list.length != 0) {
                    try {
                        FileUtil.copyDir((File)tempFile, (File)baseDirFile);
                        VirtualFile baseDir = LocalFileSystem.getInstance().findFileByIoFile(baseDirFile);
                        if (baseDir == null) {
                            ComposerProjectGenerator.showErrorNotification(project, PhpBundle.message("framework.composer.project.generator.notification.content.failed.to.find", baseDirFile.getPath()));
                            success = false;
                        }
                        boolean finalSuccess = success;
                        ApplicationManager.getApplication().invokeLater(() -> {
                            ComposerDataService service = ComposerDataService.getInstance(project);
                            ComposerProjectGenerator.setUpComposerConfigPath(service, baseDirFile);
                            service.setComposerExecution(execution);
                            if (finalSuccess) {
                                ComposerProjectGenerator.runInstall(project);
                            }
                            ComposerProjectGenerator.includeDir(tempFile, module);
                            FileUtil.delete((File)tempFile);
                        });
                    }
                    catch (IOException e) {
                        ComposerProjectGenerator.showErrorNotification(project, PhpBundle.message("framework.composer.project.generator.failed.to.copy.temp.directory.0.content.to.project.root", tempFile.getName()));
                        LOG.warn((Throwable)e);
                    }
                }
                return success;
            }

            @Override
            @Nullable
            protected ThrowableNotNullFunction<Project, ComposerCommandExecutor, ExecutionException> getExecutorGenerator() {
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/composer/ComposerProjectGenerator$1", "getBasicCommand"));
            }
        };
        executor.execute();
    }

    private static void runInstall(@NotNull Project project) {
        VirtualFile configFile;
        if (project == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(5);
        }
        if ((configFile = ComposerProjectGenerator.findConfigFile(project)) == null) {
            ComposerProjectGenerator.showErrorNotification(project, PhpBundle.message("framework.composer.project.generator.notification.content.failed.to.find.composer.json", new Object[0]));
            return;
        }
        ComposerCommandExecutor commandExecutor = ComposerInstallAction.createExecutor(project, ComposerDataService.getInstance(project).getComposerExecution(), configFile, "--no-interaction --no-ansi", null, true);
        commandExecutor.execute();
    }

    @Nullable
    private static VirtualFile findConfigFile(@NotNull Project project) {
        VirtualFile projectDir;
        if (project == null) {
            ComposerProjectGenerator.$$$reportNull$$$0(6);
        }
        if ((projectDir = ProjectUtil.guessProjectDir((Project)project)) == null) {
            return null;
        }
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{projectDir});
        return projectDir.findChild("composer.json");
    }

    private static void setUpComposerConfigPath(ComposerDataService service, File baseDirFile) {
        File[] files = baseDirFile.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !"composer.json".equals(file.getName())) continue;
                String composerJsonPath = FileUtil.toSystemIndependentName((String)file.getPath());
                service.setConfigPathAndLibraryUpdateStatus(composerJsonPath, true);
                break;
            }
        }
    }

    private static void excludeDir(File file, Module module) {
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        ContentEntry[] contentEntries = model.getContentEntries();
        String path = FileUtil.toSystemIndependentName((String)file.getPath());
        String url = VfsUtilCore.pathToUrl((String)path);
        boolean processed = false;
        for (ContentEntry entry : contentEntries) {
            String rootPath = VfsUtilCore.urlToPath((String)entry.getUrl());
            if (!FileUtil.isAncestor((String)rootPath, (String)path, (boolean)false)) continue;
            entry.addExcludeFolder(url);
            processed = true;
            break;
        }
        if (processed) {
            ApplicationManager.getApplication().runWriteAction(() -> model.commit());
        } else {
            model.dispose();
        }
    }

    private static void includeDir(File file, Module module) {
        VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        if (dir == null) {
            return;
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        ContentEntry[] contentEntries = model.getContentEntries();
        if (contentEntries.length == 0) {
            model.dispose();
            return;
        }
        ExcludeFolder toRemove = null;
        String path = dir.getPath();
        for (ExcludeFolder folder : contentEntries[0].getExcludeFolders()) {
            if (!dir.equals(folder.getFile()) && !FileUtil.pathsEqual((String)path, (String)folder.getUrl())) continue;
            toRemove = folder;
            break;
        }
        if (toRemove == null) {
            model.dispose();
            return;
        }
        contentEntries[0].removeExcludeFolder(toRemove);
        ApplicationManager.getApplication().runWriteAction(() -> model.commit());
    }

    @NotNull
    public ProjectGeneratorPeer<ComposerProjectSettings> createPeer() {
        return new ComposerProjectPeer();
    }

    private static void showErrorNotification(Project project, @NlsContexts.NotificationContent String content) {
        Notification errorNotification = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer.project.generation.error.title", new Object[0]), content, NotificationType.ERROR);
        Notifications.Bus.notify((Notification)errorNotification, (Project)project);
    }

    @NonNls
    @Nullable
    public String getHelpId() {
        return "create.composer.project.dialog";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerProjectGenerator";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerProjectGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "runInstall";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findConfigFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

