/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.DynamicBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.ComposerUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerJsonForm {
    private JPanel myConfigPanel;
    private TextFieldWithBrowseButton myConfigPathTextField;
    private JBCheckBox myAddPackagesAsLibrariesCheckBox;
    private JBCheckBox mySyncComposerConfigCheckBox;
    private JBLabel myUserSettingsStateLabel;
    private ActionLink myOpenJsonLink;
    private JBCheckBox myLoadUpdateAvailabilityCheckBox;
    private JPanel myConfigPathPanel;
    private JBCheckBox myShowQuickActionCheckBox;
    private JBCheckBox myNotifyAboutMissingVendor;
    private final boolean isVisible;
    private Project myProject;

    public ComposerJsonForm(@NotNull Project project, boolean visible) {
        if (project == null) {
            ComposerJsonForm.$$$reportNull$$$0(0);
        }
        this.isVisible = visible;
        this.$$$setupUI$$$();
        if (!this.isVisible) {
            this.myConfigPanel.setVisible(false);
            return;
        }
        if (project.isDefault()) {
            this.myConfigPathPanel.setVisible(false);
        }
        this.myProject = project;
        this.myUserSettingsStateLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        FileChooserDescriptor singleFileDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
        this.myConfigPathTextField.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener<JTextField>(PhpBundle.message("framework.composer.path.dialog.path.to.composer.json", new Object[0]), PhpBundle.message("framework.composer.path.dialog.specify.composer.json", new Object[0]), (ComponentWithBrowseButton)this.myConfigPathTextField, null, singleFileDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT){

            @Nullable
            protected VirtualFile getInitialFile() {
                VirtualFile file;
                String text = ComposerJsonForm.this.myConfigPathTextField.getText();
                if (StringUtil.isEmpty((String)text) && (file = ComposerUtils.findFileInProject(ComposerJsonForm.this.myConfigPanel, "composer.json")) != null) {
                    return file;
                }
                return super.getInitialFile();
            }
        });
        this.myConfigPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                ComposerJsonForm.this.configPathUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerJsonForm$2", "textChanged"));
            }
        });
    }

    private void configPathUpdated() {
        boolean enabled = !StringUtil.isEmptyOrSpaces((String)this.myConfigPathTextField.getText()) || this.myProject.isDefault();
        this.myAddPackagesAsLibrariesCheckBox.setEnabled(enabled);
        this.mySyncComposerConfigCheckBox.setEnabled(enabled);
        this.myUserSettingsStateLabel.setEnabled(enabled);
        this.myLoadUpdateAvailabilityCheckBox.setEnabled(enabled);
        this.myShowQuickActionCheckBox.setEnabled(enabled);
        this.myOpenJsonLink.setEnabled(ComposerJsonForm.validateComposerJsonPath(this.myConfigPathTextField.getText(), this.myConfigPathTextField.getChildComponent(), this.myProject) == null);
    }

    boolean isModified(@NotNull ComposerDataService service) {
        boolean oldSelected;
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(1);
        }
        if (!this.isVisible) {
            return false;
        }
        String oldConfigPath = StringUtil.nullize((String)service.getConfigPath());
        String newConfigPath = StringUtil.nullize((String)this.myConfigPathTextField.getText());
        if (!(oldConfigPath != null ? oldConfigPath.equals(newConfigPath) : newConfigPath == null)) {
            return true;
        }
        boolean bl = oldSelected = service.getSynchronizationState() == ComposerDataService.SynchronizationState.SYNCHRONIZE;
        if (this.mySyncComposerConfigCheckBox.isSelected() != oldSelected) {
            return true;
        }
        if (this.myAddPackagesAsLibrariesCheckBox.isSelected() != service.isUpdateLibrary()) {
            return true;
        }
        if (this.myLoadUpdateAvailabilityCheckBox.isSelected() != service.isLoadUpdateAvailability()) {
            return true;
        }
        if (this.myShowQuickActionCheckBox.isSelected() != service.isShowQuickActionsPanel()) {
            return true;
        }
        return this.myNotifyAboutMissingVendor.isSelected() != service.isNotifyAboutMissingVendor();
    }

    void apply(@NotNull ComposerDataService service) {
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(2);
        }
        if (!this.isVisible) {
            return;
        }
        service.setConfigPathAndLibraryUpdateStatus(StringUtil.nullize((String)this.myConfigPathTextField.getText()), this.myAddPackagesAsLibrariesCheckBox.isSelected());
        if (!this.mySyncComposerConfigCheckBox.isSelected()) {
            service.setSynchronizationState(ComposerDataService.SynchronizationState.DONT_SYNCHRONIZE);
        } else {
            service.setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
        }
        service.setLoadUpdateAvailability(this.myLoadUpdateAvailabilityCheckBox.isSelected());
        service.setShowQuickActionsPanel(this.myShowQuickActionCheckBox.isSelected());
        service.setNotifyAboutMissingVendor(this.myNotifyAboutMissingVendor.isSelected());
        DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
    }

    void reset(@NotNull ComposerDataService service) {
        if (service == null) {
            ComposerJsonForm.$$$reportNull$$$0(3);
        }
        if (!this.isVisible) {
            return;
        }
        @NlsSafe String nullize = StringUtil.nullize((String)service.getConfigPath());
        this.myConfigPathTextField.setText(nullize);
        this.configPathUpdated();
        this.myAddPackagesAsLibrariesCheckBox.setSelected(service.isUpdateLibrary());
        if (service.getSynchronizationState() == ComposerDataService.SynchronizationState.NOT_INITIALIZED && ComposerSettingSyncConfigClient.isDefaultAllSettings(this.myProject, service.getConfigPath())) {
            service.setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
        }
        this.mySyncComposerConfigCheckBox.setSelected(service.getSynchronizationState() == ComposerDataService.SynchronizationState.SYNCHRONIZE);
        boolean defaultSettingsOrInitialized = ComposerSettingSyncConfigClient.isDefaultAllSettings(this.myProject, service.getConfigPath()) || service.getSynchronizationState() != ComposerDataService.SynchronizationState.NOT_INITIALIZED;
        this.myUserSettingsStateLabel.setText(defaultSettingsOrInitialized ? ComposerJsonForm.getSupported() : ComposerJsonForm.getOverwritten());
        if (!defaultSettingsOrInitialized) {
            this.myUserSettingsStateLabel.setIcon(UIUtil.getBalloonWarningIcon());
        }
        this.myLoadUpdateAvailabilityCheckBox.setSelected(service.isLoadUpdateAvailability());
        this.myShowQuickActionCheckBox.setSelected(service.isShowQuickActionsPanel());
        this.myNotifyAboutMissingVendor.setSelected(service.isNotifyAboutMissingVendor());
    }

    void setChangeListener(@NotNull DocumentAdapter documentAdapter) {
        if (documentAdapter == null) {
            ComposerJsonForm.$$$reportNull$$$0(4);
        }
        if (!this.isVisible) {
            return;
        }
        this.myConfigPathTextField.getTextField().getDocument().addDocumentListener((DocumentListener)documentAdapter);
    }

    @Nullable
    ValidationInfo validate() {
        if (!this.isVisible) {
            return null;
        }
        return ComposerJsonForm.validateComposerJsonPath(this.myConfigPathTextField.getText(), this.myConfigPathTextField.getChildComponent(), this.myProject);
    }

    private void createUIComponents() {
        this.myOpenJsonLink = new ActionLink(PhpBundle.message("action.detect.composer.json.open", new Object[0]), e -> {
            if (this.myOpenJsonLink.isEnabled()) {
                String path = this.myConfigPathTextField.getText();
                VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
                if (file == null) {
                    String title = PhpBundle.message("action.detect.composer.json.not.found.title", new Object[0]);
                    String message = PhpBundle.message("action.detect.composer.json.not.found", path);
                    Messages.showMessageDialog((Project)this.myProject, (String)message, (String)title, (Icon)Messages.getWarningIcon());
                    return;
                }
                FileEditorManager fileManager = FileEditorManager.getInstance((Project)this.myProject);
                if (fileManager != null) {
                    fileManager.openFile(file, true);
                }
            }
        });
        this.myOpenJsonLink.setRolloverEnabled(false);
    }

    @Nullable
    public static ValidationInfo validateComposerJsonPath(@NotNull String path, @Nullable JComponent component, Project project) {
        if (path == null) {
            ComposerJsonForm.$$$reportNull$$$0(5);
        }
        if (project.isDefault()) {
            return null;
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.form.empty.path.to.composer.json", new Object[0]), component);
        }
        File file = new File(path);
        if (!file.exists()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.file.0.is.not.found", path), component);
        }
        if (file.isDirectory()) {
            return new ValidationInfo(PhpBundle.message("framework.composer.path.validation.0.is.a.directory", path), component);
        }
        if (!"composer.json".equals(file.getName())) {
            return new ValidationInfo(PhpBundle.message("framework.composer.selected.file.is.not.composer.json", new Object[0]), component);
        }
        return null;
    }

    @Nls
    private static String getOverwritten() {
        return PhpBundle.message("action.detect.user.settings.state.overwritten", new Object[0]);
    }

    @Nls
    private static String getSupported() {
        return PhpBundle.message("action.detect.user.settings.state.supported", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "documentAdapter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/composer/ComposerJsonForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "reset";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "setChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "validateComposerJsonPath";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        JBCheckBox jBCheckBox4;
        JBLabel jBLabel;
        JBCheckBox jBCheckBox5;
        JPanel jPanel2;
        this.createUIComponents();
        this.myConfigPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(8, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(7, 0, 1, 3, 0, 2, 1, 6, null, null, null));
        this.mySyncComposerConfigCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setContentAreaFilled(true);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("composer.checkbox.synchronize.ide.settings.with.composer.json"));
        jPanel2.add((Component)jBCheckBox5, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null, 1));
        this.myUserSettingsStateLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("composer.label.the.settings.php.language.level.directories.may.be.updated"));
        jBLabel.setVisible(true);
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 0, 1, 2, 8, 0, 0, 0, null, null, null, 2));
        this.myAddPackagesAsLibrariesCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("checkbox.add.packages.as.libraries"));
        jPanel2.add((Component)jBCheckBox4, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null, 1));
        this.myConfigPathPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(7, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("composer.label.path.to.composer.json"));
        jPanel.add((Component)jLabel, "West");
        this.myConfigPathTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, "Center");
        ActionLink actionLink = this.myOpenJsonLink;
        jPanel.add((Component)actionLink, "East");
        this.myLoadUpdateAvailabilityCheckBox = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("framework.composer.load.update.availability"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myShowQuickActionCheckBox = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("frameworl.composer.show.quick.actions"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myNotifyAboutMissingVendor = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", ComposerJsonForm.class).getString("framework.composer.notify.about.missing.vendor"));
        jPanel2.add((Component)jBCheckBox, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConfigPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

