/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPathForm;
import com.jetbrains.php.composer.execution.ComposerExecution;
import com.jetbrains.php.composer.execution.ComposerExecutionProvider;
import com.jetbrains.php.composer.execution.phar.ComposerPharForm;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerExecutionForm
implements Disposable {
    public static final int VALIDATION_DELAY_MILLIS = 500;
    private JPanel myMainPanel;
    private JPanel myRadioButtonPanel;
    private JPanel mySettingsPanel;
    private final boolean isVisible;
    private final boolean isShowDownloadOption;
    private final Map<JBRadioButton, ComposerExecutionProvider.Form> myFormMap;
    private final Alarm myValidationAlarm;
    private final List<Runnable> myListeners;

    public ComposerExecutionForm(@NotNull Project project, @Nullable Runnable validationListener, boolean visible, boolean showDownloadOption, boolean isFromProjectGenerator, @NotNull Disposable disposable) {
        if (project == null) {
            ComposerExecutionForm.$$$reportNull$$$0(0);
        }
        if (disposable == null) {
            ComposerExecutionForm.$$$reportNull$$$0(1);
        }
        this.$$$setupUI$$$();
        this.myFormMap = new HashMap<JBRadioButton, ComposerExecutionProvider.Form>();
        this.myListeners = ContainerUtil.createConcurrentList(new ArrayList());
        this.isVisible = visible;
        this.isShowDownloadOption = showDownloadOption;
        if (!this.isVisible) {
            this.myMainPanel.setVisible(false);
            this.myValidationAlarm = null;
            return;
        }
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.myValidationAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.mySettingsPanel.setLayout(new ResizingCardLayout());
        List<ComposerExecutionProvider> uiProviderList = ComposerExecutionProvider.getProviders();
        ButtonGroup buttonGroup = new ButtonGroup();
        for (ComposerExecutionProvider provider : uiProviderList) {
            if (isFromProjectGenerator && "ComposerRemoteInterpreterExecutionProvider".equals(provider.getClass().getSimpleName())) continue;
            final String name = provider.getPresentableName();
            JBRadioButton typeButton = new JBRadioButton(name);
            buttonGroup.add((AbstractButton)typeButton);
            this.myRadioButtonPanel.add((Component)typeButton);
            ComposerExecutionProvider.Form form = provider.createForm(project, disposable);
            this.myFormMap.put(typeButton, form);
            JComponent formComponent = form.getComponent();
            this.mySettingsPanel.add((Component)formComponent, name);
            typeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CardLayout layout = (CardLayout)ComposerExecutionForm.this.mySettingsPanel.getLayout();
                    layout.show(ComposerExecutionForm.this.mySettingsPanel, name);
                }
            });
            if (this.isShowDownloadOption || !(form instanceof ComposerPharForm)) continue;
            ((ComposerPharForm)form).hideDownload();
        }
        if (validationListener != null) {
            this.addDataListener(validationListener);
        }
    }

    private void initValidation() {
        if (!this.isVisible) {
            return;
        }
        this.myValidationAlarm.cancelAllRequests();
        if (this.myListeners.isEmpty()) {
            return;
        }
        Runnable validateRequest = () -> {
            if (this.myListeners.isEmpty()) {
                return;
            }
            for (Runnable listener : this.myListeners) {
                listener.run();
            }
            this.initValidation();
        };
        this.myValidationAlarm.addRequest(validateRequest, 500);
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void addDataListener(@NotNull Runnable listener) {
        if (listener == null) {
            ComposerExecutionForm.$$$reportNull$$$0(2);
        }
        if (!this.isVisible) {
            return;
        }
        this.myListeners.add(listener);
        this.initValidation();
    }

    public boolean isModified(ComposerDataService service) {
        if (!this.isVisible) {
            return false;
        }
        ComposerExecution execution = service.getComposerExecution();
        ComposerExecutionProvider.Form form = this.getSelectedForm();
        return form.isModified(execution);
    }

    @NotNull
    private ComposerExecutionProvider.Form getSelectedForm() {
        for (Map.Entry<JBRadioButton, ComposerExecutionProvider.Form> entry : this.myFormMap.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            ComposerExecutionProvider.Form form = entry.getValue();
            if (form == null) {
                ComposerExecutionForm.$$$reportNull$$$0(3);
            }
            return form;
        }
        ComposerExecutionProvider.Form form = (ComposerExecutionProvider.Form)((Map.Entry)ContainerUtil.getFirstItem(this.myFormMap.entrySet())).getValue();
        if (form == null) {
            ComposerExecutionForm.$$$reportNull$$$0(4);
        }
        return form;
    }

    public void apply(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        ComposerExecutionProvider.Form form = this.getSelectedForm();
        form.apply();
        service.setComposerExecution(form.getExecution());
    }

    @NotNull
    public ComposerExecution getExecution() {
        ComposerExecution composerExecution = this.getSelectedForm().getExecution();
        if (composerExecution == null) {
            ComposerExecutionForm.$$$reportNull$$$0(5);
        }
        return composerExecution;
    }

    public void reset(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        this.reset(service.getComposerExecution());
    }

    private void reset(ComposerExecution execution) {
        for (Map.Entry<JBRadioButton, ComposerExecutionProvider.Form> entry : this.myFormMap.entrySet()) {
            if (!entry.getValue().reset(execution)) continue;
            entry.getKey().setSelected(true);
            CardLayout layout = (CardLayout)this.mySettingsPanel.getLayout();
            layout.show(this.mySettingsPanel, entry.getKey().getText());
        }
    }

    public void resetOrGuessDefaults(ComposerDataService service) {
        if (!this.isVisible) {
            return;
        }
        ComposerExecution execution = service.getComposerExecution();
        if (ComposerExecution.DEFAULT.equals(execution)) {
            String validateGlobal = ComposerPathForm.validateExecutableFromPath("composer");
            if (validateGlobal == null) {
                this.reset(ComposerExecution.createDefaultExecutableExecution());
                return;
            }
            if (this.isShowDownloadOption) {
                this.reset(ComposerExecution.createDefaultPharExecution());
                ((ComposerPharForm)this.getSelectedForm()).selectDownload();
                return;
            }
        }
        this.reset(service);
    }

    @Nullable
    public ValidationInfo validate() {
        if (!this.isVisible) {
            return null;
        }
        for (Map.Entry<JBRadioButton, ComposerExecutionProvider.Form> entry : this.myFormMap.entrySet()) {
            if (!entry.getKey().isSelected()) continue;
            return entry.getValue().validate();
        }
        return null;
    }

    public boolean isDownloadPhar() {
        ComposerExecutionProvider.Form form = this.getSelectedForm();
        return form instanceof ComposerPharForm && ((ComposerPharForm)form).isDownloadPhar();
    }

    public void dispose() {
        this.myListeners.clear();
        this.myValidationAlarm.cancelAllRequests();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/composer/ComposerExecutionForm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/composer/ComposerExecutionForm";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedForm";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getExecution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addDataListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        this.myMainPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myRadioButtonPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 5, 5));
        jPanel3.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.mySettingsPanel = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel3.add((Component)jPanel, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static final class ResizingCardLayout
    extends CardLayout {
        private ResizingCardLayout() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension preferredLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getPreferredSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Dimension minimumLayoutSize(Container parent) {
            Object object = parent.getTreeLock();
            synchronized (object) {
                Insets insets = parent.getInsets();
                int ncomponents = parent.getComponentCount();
                int w = 0;
                int h = 0;
                for (int i = 0; i < ncomponents; ++i) {
                    Component comp = parent.getComponent(i);
                    if (!comp.isVisible()) continue;
                    Dimension d = comp.getMinimumSize();
                    if (d.width > w) {
                        w = d.width;
                    }
                    if (d.height <= h) continue;
                    h = d.height;
                }
                return new Dimension(insets.left + insets.right + w + this.getHgap() * 2, insets.top + insets.bottom + h + this.getVgap() * 2);
            }
        }
    }
}

