/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerConfigurable;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerSettingSyncConfigClient;
import com.jetbrains.php.composer.ComposerUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ComposerDetectionManager {
    private ComposerDetectionManager() {
    }

    public static void offerInitialization(final Project project) {
        if (project == null || project.isDefault()) {
            return;
        }
        final ComposerDataService dataService = ComposerDataService.getInstance(project);
        if (!StringUtil.isEmptyOrSpaces((String)dataService.getConfigPath())) {
            dataService.setDoNotAskAgain(true);
            return;
        }
        if (dataService.doNotAskAgain()) {
            return;
        }
        VirtualFile composerJson = ComposerDetectionManager.findConfig(project);
        if (composerJson != null) {
            final ComposerDataService.SynchronizationState oldSyncState = dataService.getSynchronizationState();
            final boolean oldUpdateLibrary = dataService.isUpdateLibrary();
            dataService.setConfigPathAndLibraryUpdateStatus(composerJson.getPath(), true);
            if (ComposerSettingSyncConfigClient.isDefaultAllSettings(project, composerJson.getPath())) {
                dataService.setSynchronizationState(ComposerDataService.SynchronizationState.SYNCHRONIZE);
            }
            String message = PhpBundle.message("framework.composer.initialize.popup", VfsUtilCore.getRelativePath((VirtualFile)composerJson, (VirtualFile)project.getBaseDir()));
            final Notification notification2 = new Notification(ComposerUtils.getComposerGroupDisplayId(), PhpBundle.message("framework.composer", new Object[0]), message, NotificationType.INFORMATION);
            DumbAwareAction showSettingsAction = new DumbAwareAction(PhpBundle.message("show.composer.settings.action.name", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    notification2.expire();
                    ComposerConfigurable configurable = new ComposerConfigurable(project, false);
                    ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerDetectionManager$1", "actionPerformed"));
                }
            };
            DumbAwareAction revertAction = new DumbAwareAction(PhpBundle.message("composer.revert.action.name", new Object[0])){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    ComposerDataService.getInstance(project).setDoNotAskAgain(true);
                    notification2.expire();
                    dataService.setConfigPathAndLibraryUpdateStatus(null, oldUpdateLibrary);
                    dataService.setSynchronizationState(oldSyncState);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/composer/ComposerDetectionManager$2", "actionPerformed"));
                }
            };
            notification2.addAction((AnAction)showSettingsAction);
            notification2.addAction((AnAction)revertAction);
            Notifications.Bus.notify((Notification)notification2, (Project)project);
        }
    }

    @Nullable
    private static VirtualFile findConfig(@NotNull Project project) {
        VirtualFile baseDir;
        if (project == null) {
            ComposerDetectionManager.$$$reportNull$$$0(0);
        }
        if ((baseDir = project.getBaseDir()) == null) {
            return null;
        }
        VirtualFile composerJson = ComposerDetectionManager.findConfig(baseDir);
        if (composerJson != null) {
            return composerJson;
        }
        for (VirtualFile file : baseDir.getChildren()) {
            if (!file.isDirectory() || (composerJson = ComposerDetectionManager.findConfig(file)) == null) continue;
            return composerJson;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findConfig(VirtualFile dir) {
        return dir.findChild("composer.json");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/ComposerDetectionManager", "findConfig"));
    }
}

