/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.composer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.ComposerPathForm;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComposerConfigurable
implements Configurable.NoScroll,
SearchableConfigurable {
    @NotNull
    private final Project myProject;
    private final ComposerDataService myService;
    private ComposerPathForm myForm;
    private final boolean myShowExecution;
    private final Disposable myDisposable;

    public ComposerConfigurable(@NotNull Project project) {
        if (project == null) {
            ComposerConfigurable.$$$reportNull$$$0(0);
        }
        this(project, true);
    }

    public ComposerConfigurable(@NotNull Project project, boolean showExecution) {
        if (project == null) {
            ComposerConfigurable.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myService = ComposerDataService.getInstance(project);
        this.myShowExecution = showExecution;
        this.myDisposable = Disposer.newDisposable();
    }

    @NotNull
    public String getId() {
        return "reference.webide.settings.project.settings.php.composer";
    }

    @Nls
    public String getDisplayName() {
        return PhpBundle.message("framework.composer.configurable.title", new Object[0]);
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.php.composer";
    }

    @Nullable
    public JComponent createComponent() {
        if (this.myForm == null) {
            this.myForm = new ComposerPathForm(this.myProject, null, true, this.myShowExecution, !this.myProject.isDefault(), this.myDisposable);
        }
        return this.myForm.getContentPane();
    }

    public boolean isModified() {
        if (this.myForm == null) {
            return false;
        }
        return this.myForm.isModified(this.myService);
    }

    public void apply() throws ConfigurationException {
        if (this.myForm != null) {
            this.myForm.apply(this.myService);
        }
    }

    public void reset() {
        if (this.myForm != null) {
            this.myForm.reset(this.myService);
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myDisposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/php/composer/ComposerConfigurable", "<init>"));
    }
}

