/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.completion.smartEnter.PhpComplementor;
import com.jetbrains.php.completion.smartEnter.PhpComplementorFactory;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSmartEnterProcessor
extends SmartEnterProcessor {
    private static final Logger LOG = Logger.getInstance(PhpSmartEnterProcessor.class);

    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiElement statement;
        if (project == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(2);
        }
        if (!(psiFile instanceof PhpFile)) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset() - 1;
        FileViewProvider viewProvider = psiFile.getViewProvider();
        PsiElement currElement = viewProvider.findElementAt(offset, (Language)PhpLanguage.INSTANCE);
        if ((currElement = PhpSmartEnterProcessor.removeFunctionParenthesis(viewProvider, project, editor, currElement)) instanceof PsiWhiteSpace) {
            currElement = PsiTreeUtil.prevLeaf((PsiElement)currElement);
        }
        for (statement = currElement; statement != null && !PhpComplementorFactory.isStatement(statement); statement = statement.getParent()) {
        }
        if (statement == null) {
            return false;
        }
        return this.completeStatement(project, psiFile, editor, statement);
    }

    @Nullable
    private static PsiElement removeFunctionParenthesis(@NotNull FileViewProvider viewProvider, @NotNull Project project, @NotNull Editor editor, @Nullable PsiElement currElement) {
        PsiElement prev;
        PsiElement lastChild;
        PsiElement parent;
        if (viewProvider == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(3);
        }
        if (project == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(5);
        }
        if (PhpPsiUtil.isOfType(currElement, PhpTokenTypes.chRPAREN) && !PhpSmartEnterProcessor.isFollowedByLineBreak(currElement) && !PhpSmartEnterProcessor.isLastElement(currElement) && ((parent = currElement.getParent()) instanceof FunctionReference || parent instanceof NewExpression) && !PhpPsiUtil.isOfType(lastChild = parent.getLastChild(), PhpTokenTypes.opSEMICOLON) && (prev = currElement.getPrevSibling()) != null && PhpPsiUtil.isOfType(prev, PhpElementTypes.PARAMETER_LIST) && prev.getFirstChild() == null) {
            Document document = editor.getDocument();
            int offset = currElement.getTextRange().getStartOffset();
            document.deleteString(offset, offset + currElement.getTextRange().getLength());
            PsiDocumentManager.getInstance((Project)project).commitDocument(document);
            return viewProvider.findElementAt(offset);
        }
        return currElement;
    }

    private static boolean isFollowedByLineBreak(@Nullable PsiElement element) {
        if (element != null && !(element instanceof PsiFile)) {
            PsiElement next = element.getNextSibling();
            if (next instanceof PsiErrorElement) {
                next = next.getNextSibling();
            }
            if (next == null) {
                return PhpSmartEnterProcessor.isFollowedByLineBreak(element.getParent());
            }
            return next instanceof PsiWhiteSpace && next.textContains('\n');
        }
        return false;
    }

    private static boolean isLastElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(6);
        }
        for (PsiElement current = element; current != null && !(current instanceof PsiFile); current = current.getParent()) {
            PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(current, true);
            if (nextSibling instanceof PsiErrorElement) {
                nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nextSibling, true);
            }
            if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.PHP_CLOSING_TAG) || PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.opSEMICOLON)) {
                return true;
            }
            if (nextSibling == null) continue;
            return false;
        }
        return true;
    }

    private boolean completeStatement(@NotNull Project project, PsiFile file, Editor editor, PsiElement statement) {
        if (project == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(7);
        }
        StringBuffer complementBuf = new StringBuffer();
        PhpSmartEnterProcessor.appendComplement(complementBuf, statement);
        String appendStr = complementBuf.toString();
        if (appendStr.length() > 0) {
            this.appendAndAdvance(project, file, statement, appendStr, editor);
            return true;
        }
        return false;
    }

    private static void appendComplement(StringBuffer buf, PsiElement element) {
        for (PsiElement child = element.getFirstChild(); child != null && !(child instanceof PsiErrorElement) && !PhpComplementorFactory.isStatement(child); child = child.getNextSibling()) {
            PhpSmartEnterProcessor.appendComplement(buf, child);
        }
        PhpComplementor complementor = PhpComplementorFactory.getComplementor(element);
        if (complementor != null) {
            buf.append(complementor.getComplement(element));
        }
    }

    private void appendAndAdvance(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement statement, String str, @NotNull Editor editor) {
        int enterOffset;
        if (project == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(8);
        }
        if (file == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(9);
        }
        if (statement == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(11);
        }
        int rangeStart = statement.getTextRange().getStartOffset();
        IElementType statementType = statement.getNode().getElementType();
        PsiElement afterElement = PhpSmartEnterProcessor.findElementToInsertAfter(statement, str.startsWith("("));
        int offset = afterElement.getTextRange().getStartOffset() + afterElement.getTextRange().getLength();
        int rangeEnd = offset--;
        if (afterElement.getText().endsWith("\n")) {
            // empty if block
        }
        editor.getDocument().insertString(offset, (CharSequence)str);
        int newOffset = offset + str.length();
        editor.getCaretModel().moveToOffset(newOffset);
        RangeMarker marker = editor.getDocument().createRangeMarker(rangeStart, rangeEnd += str.length());
        this.commit(editor);
        CodeStyleManager.getInstance((Project)project).reformatText(file, marker.getStartOffset(), marker.getEndOffset());
        this.commit(editor);
        PsiElement newStatement = PhpSmartEnterProcessor.findStatementAt(file, marker.getStartOffset(), statementType);
        if (newStatement == null) {
            PsiElement elementAtOffset = file.findElementAt(marker.getStartOffset());
            if (!PhpPsiUtil.isOfType(elementAtOffset, PhpTokenTypes.PHP_CLOSING_TAG) || !"__halt_compiler()".equals(statement.getText())) {
                StringBuilder message = new StringBuilder();
                message.append("Failed to find a statement of type ").append(statement.getNode().getElementType());
                if (elementAtOffset != null) {
                    message.append(", found ").append(elementAtOffset.getNode().getElementType());
                }
                LOG.error((Object)message);
            }
        } else if (!PhpSmartEnterProcessor.moveToError(newStatement, editor, file) && (enterOffset = PhpSmartEnterProcessor.getEnterOffset(newStatement)) >= 0) {
            this.doEnter(editor, enterOffset);
        }
        marker.dispose();
    }

    @Nullable
    private static PsiElement findStatementAt(@NotNull PsiFile psiFile, int offset, IElementType statementType) {
        if (psiFile == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(12);
        }
        PsiElement currElement = psiFile.findElementAt(offset);
        return !((currElement = PsiTreeUtil.findFirstParent((PsiElement)currElement, element -> element instanceof PsiFile || PhpPsiUtil.isOfType(element, statementType))) instanceof PsiFile) ? currElement : null;
    }

    @NotNull
    private static PsiElement findElementToInsertAfter(@NotNull PsiElement statement, boolean withParentheses) {
        PsiElement elementBeforeClosingTag;
        PsiElement child;
        if (statement == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(13);
        }
        PsiElement prevElement = child = statement.getFirstChild();
        IElementType statementType = statement.getNode().getElementType();
        while (child != null) {
            PsiElement firstChild;
            IElementType childType;
            ASTNode childNode = child.getNode();
            IElementType iElementType = childType = childNode != null ? childNode.getElementType() : null;
            if (PhpElementTypes.STATEMENTS.contains(childType) || childType == PhpTokenTypes.PHP_CLOSING_TAG || PhpSmartEnterProcessor.isStatementTerminatingSemicolon(statement, child)) {
                PsiElement prevNonSpace;
                if (prevElement instanceof PsiWhiteSpace && (prevNonSpace = prevElement.getPrevSibling()) != null) {
                    PsiElement psiElement = prevNonSpace;
                    if (psiElement == null) {
                        PhpSmartEnterProcessor.$$$reportNull$$$0(14);
                    }
                    return psiElement;
                }
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    PhpSmartEnterProcessor.$$$reportNull$$$0(15);
                }
                return psiElement;
            }
            if ((statementType == PhpElementTypes.CASE || statementType == PhpElementTypes.CASE_DEFAULT) && child instanceof PsiErrorElement) {
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    PhpSmartEnterProcessor.$$$reportNull$$$0(16);
                }
                return psiElement;
            }
            if (withParentheses && (childType == PhpTokenTypes.kwIF || childType == PhpTokenTypes.kwFOR || childType == PhpTokenTypes.kwWHILE || childType == PhpTokenTypes.kwSWITCH || childType == PhpTokenTypes.kwFOREACH)) {
                PsiElement psiElement = child;
                if (psiElement == null) {
                    PhpSmartEnterProcessor.$$$reportNull$$$0(17);
                }
                return psiElement;
            }
            if (childType == PhpTokenTypes.LINE_COMMENT || childType == PhpTokenTypes.C_STYLE_COMMENT || childType == PhpDocElementTypes.DOC_COMMENT) {
                PsiElement beforeSpace;
                if (prevElement instanceof PsiWhiteSpace && (beforeSpace = prevElement.getPrevSibling()) != null) {
                    PsiElement psiElement = beforeSpace;
                    if (psiElement == null) {
                        PhpSmartEnterProcessor.$$$reportNull$$$0(18);
                    }
                    return psiElement;
                }
                PsiElement psiElement = prevElement;
                if (psiElement == null) {
                    PhpSmartEnterProcessor.$$$reportNull$$$0(19);
                }
                return psiElement;
            }
            if (childType == PhpElementTypes.POSTFIX_EXPRESSION && (firstChild = child.getFirstChild()).getNode().getElementType() == PhpElementTypes.FUNCTION_CALL) {
                PsiElement psiElement = firstChild;
                if (psiElement == null) {
                    PhpSmartEnterProcessor.$$$reportNull$$$0(20);
                }
                return psiElement;
            }
            prevElement = child;
            child = child.getNextSibling();
        }
        PsiElement lastClosingTag = PhpSmartEnterProcessor.findFirstClosingTag(statement);
        if (lastClosingTag != null && (elementBeforeClosingTag = PhpSmartEnterProcessor.getElementBefore(lastClosingTag)) != null) {
            PsiElement psiElement = elementBeforeClosingTag;
            if (psiElement == null) {
                PhpSmartEnterProcessor.$$$reportNull$$$0(21);
            }
            return psiElement;
        }
        PsiElement psiElement = statement;
        if (psiElement == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(22);
        }
        return psiElement;
    }

    private static boolean isStatementTerminatingSemicolon(@NotNull PsiElement statement, @NotNull PsiElement element) {
        IElementType type;
        if (statement == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(23);
        }
        if (element == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(24);
        }
        return (type = element.getNode().getElementType()) == PhpTokenTypes.opSEMICOLON && statement.getLastChild() == element;
    }

    @Nullable
    private static PsiElement findFirstClosingTag(@NotNull PsiElement element) {
        if (element == null) {
            PhpSmartEnterProcessor.$$$reportNull$$$0(25);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.PHP_CLOSING_TAG)) {
                return child;
            }
            PsiElement closingTag = PhpSmartEnterProcessor.findFirstClosingTag(child);
            if (closingTag == null) continue;
            return closingTag;
        }
        return null;
    }

    @Nullable
    private static PsiElement getElementBefore(@Nullable PsiElement element) {
        if (element == null || element instanceof PsiFile) {
            return null;
        }
        PsiElement prev = element.getPrevSibling();
        return prev != null ? prev : PhpSmartEnterProcessor.getElementBefore(element.getParent());
    }

    private static boolean moveToError(PsiElement element, Editor editor, PsiFile psiFile) {
        if (psiFile == null) {
            return false;
        }
        PsiElement errorElement = PsiTreeUtil.findChildOfType((PsiElement)element, PsiErrorElement.class);
        if (errorElement != null) {
            PsiElement next;
            int offset = errorElement.getTextOffset();
            if (PhpPsiUtil.isOfType(element, PhpElementTypes.CASE) && (next = errorElement.getNextSibling()) instanceof PsiWhiteSpace) {
                offset = next.getTextRange().getEndOffset();
            }
            editor.getCaretModel().moveToOffset(offset);
            return true;
        }
        return false;
    }

    private void doEnter(Editor editor, int enterOffset) {
        editor.getDocument().insertString(enterOffset, (CharSequence)"\n");
        editor.getCaretModel().moveToOffset(++enterOffset);
        Project project = editor.getProject();
        if (project != null) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(editor.getDocument(), enterOffset);
        }
        this.commit(editor);
    }

    private static int getEnterOffset(PsiElement statement) {
        PsiElement colon;
        PsiElement lBrace;
        PsiElement catchOrFinallyGroup;
        PsiElement lastTryChild;
        IElementType statementType = statement.getNode().getElementType();
        PsiElement group = PhpElementTypes.ANY_GROUP_STATEMENT.contains(statementType) ? statement : PhpPsiUtil.getChildOfType(statement, PhpElementTypes.ANY_GROUP_STATEMENT);
        if (statementType == PhpElementTypes.TRY && (lastTryChild = statement.getLastChild()) != null && PhpPsiUtil.isOfType(lastTryChild, PhpElementTypes.CATCH, PhpElementTypes.FINALLY) && PhpPsiUtil.isOfType(catchOrFinallyGroup = lastTryChild.getLastChild(), PhpElementTypes.ANY_GROUP_STATEMENT)) {
            group = catchOrFinallyGroup;
        }
        if (group != null && (lBrace = PhpPsiUtil.getChildOfType(group, PhpTokenTypes.chLBRACE)) != null) {
            return lBrace.getTextRange().getStartOffset() + 1;
        }
        if (statementType == PhpElementTypes.HASH_ARRAY_ELEMENT || PhpComplementorFactory.isSimpleArrayValue(statement.getNode())) {
            PsiElement next = statement.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (PhpPsiUtil.isOfType(next, PhpTokenTypes.opCOMMA)) {
                return next.getTextRange().getEndOffset();
            }
        }
        if ((statementType == PhpStubElementTypes.CLASS || statementType == PhpElementTypes.SWITCH) && (lBrace = PhpPsiUtil.getChildOfType(statement, PhpTokenTypes.chLBRACE)) != null) {
            return lBrace.getTextRange().getEndOffset();
        }
        if ((statementType == PhpElementTypes.CASE || statementType == PhpElementTypes.CASE_DEFAULT || PhpComplementorFactory.isControlStatement(statement)) && (colon = PhpPsiUtil.getChildOfType(statement, PhpTokenTypes.opCOLON)) != null) {
            return colon.getTextRange().getEndOffset();
        }
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewProvider";
                break;
            }
            case 6: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/smartEnter/PhpSmartEnterProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/smartEnter/PhpSmartEnterProcessor";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementToInsertAfter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeFunctionParenthesis";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isLastElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "completeStatement";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "appendAndAdvance";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findStatementAt";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findElementToInsertAfter";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isStatementTerminatingSemicolon";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findFirstClosingTag";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

