/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.phpunit;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.completion.accessors.PhpAccessorsCompletionProvider;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.phpunit.PhpUnitTestDescriptor;
import com.jetbrains.php.phpunit.PhpUnitUtil;
import java.util.Collection;
import java.util.Properties;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PhpUnitTestMethodsCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PhpUnitTestMethodsCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpClass.class), new PhpUnitTestMethodsCompletionProvider());
    }

    private static class PhpUnitTestMethodsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpUnitTestMethodsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            Collection<PhpClass> targetClasses;
            PhpClass testClass;
            PsiElement position;
            if (parameters == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(2);
            }
            if (PhpAccessorsCompletionProvider.isValidPosition(position = parameters.getPosition().getOriginalElement()) && (testClass = (PhpClass)PhpPsiUtil.getParentByCondition(position, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && PhpUnitUtil.isTestClass(testClass) && !(targetClasses = PhpUnitTestDescriptor.INSTANCE.findClasses(testClass, testClass.getName())).isEmpty()) {
                PhpUnitTestMethodsCompletionProvider.addTestMethods(result, targetClasses, ContainerUtil.map2Set((Object[])testClass.getOwnMethods(), PhpNamedElement::getName));
            }
        }

        private static void addTestMethods(@NotNull CompletionResultSet result, @NotNull Collection<PhpClass> targetClasses, @NotNull Set<String> existingTestMethodsNames) {
            if (result == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (targetClasses == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(4);
            }
            if (existingTestMethodsNames == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(5);
            }
            for (PhpClass targetClass : targetClasses) {
                Project project = targetClass.getProject();
                String targetClassName = targetClass.getName();
                ((StreamEx)((StreamEx)StreamEx.of((Object[])targetClass.getOwnMethods()).filter(targetMethod -> targetMethod.getAccess().isPublic())).map(PhpNamedElement::getName).filter(targetMethodName -> !existingTestMethodsNames.contains("test" + StringUtil.capitalize((String)targetMethodName)))).map(targetMethodName -> PhpUnitTestMethodsCompletionProvider.createTestMethodLookupElement(project, targetClassName, targetMethodName)).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
            }
        }

        @NotNull
        private static Properties dummyProperties(@NotNull String targetClassName, @NotNull String targetMethodName) {
            if (targetClassName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(6);
            }
            if (targetMethodName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(7);
            }
            Properties properties = new Properties();
            properties.setProperty("TESTED_NAME", targetClassName);
            properties.setProperty("NAME", targetMethodName);
            properties.setProperty("CAPITALIZED_NAME", StringUtil.capitalize((String)targetMethodName));
            Properties properties2 = properties;
            if (properties2 == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(8);
            }
            return properties2;
        }

        private static LookupElement createTestMethodLookupElement(@NotNull Project project, @NotNull String targetClassName, @NotNull String targetMethodName) {
            if (project == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(9);
            }
            if (targetClassName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(10);
            }
            if (targetMethodName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(11);
            }
            return LookupElementBuilder.create((String)targetMethodName).withTypeText("create PHPUnit test", PhpIcons.PHP_TEST_METHOD, true).withTypeIconRightAligned(true).withInsertHandler((context, item) -> PhpUnitTestMethodsCompletionProvider.insertTestMethod(project, targetClassName, targetMethodName, context));
        }

        private static void insertTestMethod(@NotNull Project project, @NotNull String targetClassName, @NotNull String targetMethodName, InsertionContext context) {
            if (project == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(12);
            }
            if (targetClassName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(13);
            }
            if (targetMethodName == null) {
                PhpUnitTestMethodsCompletionProvider.$$$reportNull$$$0(14);
            }
            String methodText = PhpCodeUtil.getCodeTemplate("PHPUnit Test Method", PhpUnitTestMethodsCompletionProvider.dummyProperties(targetClassName, targetMethodName), project);
            PhpAccessorsCompletionProvider.AccessorLookupElement.insertMethod(context, methodText);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 8: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetClasses";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "existingTestMethodsNames";
                    break;
                }
                case 6: 
                case 10: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetClassName";
                    break;
                }
                case 7: 
                case 11: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetMethodName";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/completion/phpunit/PhpUnitTestMethodsCompletionContributor$PhpUnitTestMethodsCompletionProvider";
                    break;
                }
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/completion/phpunit/PhpUnitTestMethodsCompletionContributor$PhpUnitTestMethodsCompletionProvider";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "dummyProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addTestMethods";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "dummyProperties";
                    break;
                }
                case 8: {
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "createTestMethodLookupElement";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "insertTestMethod";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

