/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.ml;

import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.completion.ml.PhpContextFeatureProvider;
import com.jetbrains.php.completion.ml.PhpElementScope;
import com.jetbrains.php.lang.psi.PhpExpressionCodeFragment;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/php/completion/ml/PhpContextFeatureProvider;", "Lcom/intellij/codeInsight/completion/ml/ContextFeatureProvider;", "()V", "PHP_SCOPE_CONDITION", "Lcom/intellij/openapi/util/Condition;", "Lcom/intellij/psi/PsiElement;", "calculateFeatures", "", "", "Lcom/intellij/codeInsight/completion/ml/MLFeatureValue;", "lookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "findElementScope", "Lcom/jetbrains/php/completion/ml/PhpElementScope;", "element", "findMethodScope", "scope", "Lcom/jetbrains/php/lang/psi/elements/Method;", "getName", "intellij.php.impl"})
public final class PhpContextFeatureProvider
implements ContextFeatureProvider {
    private final Condition<PsiElement> PHP_SCOPE_CONDITION = PHP_SCOPE_CONDITION.1.INSTANCE;

    @NotNull
    public String getName() {
        return "php_position";
    }

    @NotNull
    public Map<String, MLFeatureValue> calculateFeatures(@NotNull Lookup lookup) {
        Intrinsics.checkNotNullParameter((Object)lookup, (String)"lookup");
        PsiElement psiElement = lookup.getPsiElement();
        if (psiElement == null) {
            return MapsKt.emptyMap();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"lookup.psiElement ?: return emptyMap()");
        PsiElement element = psiElement;
        return MapsKt.hashMapOf((Pair[])new Pair[]{TuplesKt.to((Object)"scope", (Object)MLFeatureValue.Companion.categorical((Enum)this.findElementScope(element)))});
    }

    private final PhpElementScope findElementScope(PsiElement element) {
        Object scope = PhpPsiUtil.getParentByCondition(element, this.PHP_SCOPE_CONDITION);
        if (scope instanceof PhpExpressionCodeFragment) {
            return PhpElementScope.CODE_FRAGMENT;
        }
        if (scope instanceof PhpNamespace) {
            return PhpElementScope.NAMESPACE;
        }
        if (scope instanceof PhpClass) {
            return PhpElementScope.CLASS;
        }
        if (scope instanceof Method) {
            return this.findMethodScope((Method)scope);
        }
        if (scope instanceof Function) {
            return PhpElementScope.FUNCTION;
        }
        if (scope instanceof PsiFile) {
            return PhpElementScope.FILE;
        }
        return PhpElementScope.OTHER;
    }

    private final PhpElementScope findMethodScope(Method scope) {
        return scope.isStatic() ? PhpElementScope.STATIC_METHOD : PhpElementScope.METHOD;
    }
}

