/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.TokenType;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpReturnInstructionImpl;
import com.jetbrains.php.completion.insert.PhpInsertHandlerUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.NotNull;

public class PhpReturnKeywordInsertHandler
implements InsertHandler<LookupElement> {
    private static final PhpReturnKeywordInsertHandler INSTANCE = new PhpReturnKeywordInsertHandler();

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Function function;
        PsiElement elementAt;
        PhpReturn phpReturn;
        if (context == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(0);
        }
        if (item == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(1);
        }
        if ((phpReturn = (PhpReturn)PhpPsiUtil.getParentByCondition(elementAt = context.getFile().findElementAt(context.getStartOffset()), (Condition<? super PsiElement>)PhpReturn.INSTANCEOF)) == null) {
            return;
        }
        if (phpReturn.getArgument() == null && (function = (Function)PhpPsiUtil.getParentByCondition(elementAt, (Condition<? super PsiElement>)Function.INSTANCEOF)) != null) {
            PhpType declaredType = FunctionImpl.getDeclaredType(function);
            FunctionReturnsState functionReturnsState = PhpReturnKeywordInsertHandler.hasOnlyNonEmptyReturns(function, phpReturn);
            if (PhpType.VOID.equals((Object)declaredType)) {
                if (PhpReturnKeywordInsertHandler.insertSemicolonAtCaret(context, true)) {
                    return;
                }
            } else if (!(PhpType.intersects((PhpType)declaredType, (PhpType)PhpType.VOID) || functionReturnsState != FunctionReturnsState.ALL_NON_EMPTY && declaredType.isEmpty() || PhpPsiUtil.isOfType(elementAt.getNextSibling(), TokenType.WHITE_SPACE))) {
                PhpInsertHandlerUtil.insertStringAtCaret(context.getEditor(), " ");
                return;
            }
        }
        PhpReturnKeywordInsertHandler.moveToTheEndOfParentStatement(context, elementAt);
    }

    private static FunctionReturnsState hasOnlyNonEmptyReturns(Function function, final PhpReturn completedReturn) {
        final Ref state = new Ref((Object)FunctionReturnsState.NO_RETURNS);
        PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                if (((PhpReturnInstructionImpl)instruction).getReturnStatement() == completedReturn) {
                    return true;
                }
                PsiElement argument = instruction.getArgument();
                if (argument == null) {
                    state.set((Object)FunctionReturnsState.EMPTY_EXISTS);
                    return false;
                }
                state.set((Object)FunctionReturnsState.ALL_NON_EMPTY);
                return true;
            }
        });
        return (FunctionReturnsState)((Object)state.get());
    }

    public static boolean insertSemicolonAtCaret(@NotNull InsertionContext context, boolean moveCaretToSemicolon) {
        PsiElement nextSibling;
        if (context == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(2);
        }
        if (!LookupEvent.isSpecialCompletionChar((char)context.getCompletionChar())) {
            return false;
        }
        Editor editor = context.getEditor();
        PsiElement elementAt = context.getFile().findElementAt(editor.getCaretModel().getOffset());
        PsiElement psiElement = nextSibling = elementAt != null ? PhpPsiUtil.getNextSiblingIgnoreWhitespace(elementAt, false) : null;
        if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.opSEMICOLON)) {
            return false;
        }
        PhpInsertHandlerUtil.insertStringAtCaret(editor, ";");
        if (!moveCaretToSemicolon) {
            editor.getCaretModel().moveCaretRelatively(-1, 0, false, false, true);
        }
        return true;
    }

    private static void moveToTheEndOfParentStatement(@NotNull InsertionContext context, @NotNull PsiElement elementAt) {
        Object parentStatement;
        if (context == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(3);
        }
        if (elementAt == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(4);
        }
        if ((parentStatement = PhpPsiUtil.getParentByCondition(elementAt, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
            context.getEditor().getCaretModel().moveToOffset(parentStatement.getTextRange().getEndOffset());
        }
    }

    @NotNull
    public static PhpReturnKeywordInsertHandler getInstance() {
        PhpReturnKeywordInsertHandler phpReturnKeywordInsertHandler = INSTANCE;
        if (phpReturnKeywordInsertHandler == null) {
            PhpReturnKeywordInsertHandler.$$$reportNull$$$0(5);
        }
        return phpReturnKeywordInsertHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/insert/PhpReturnKeywordInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/insert/PhpReturnKeywordInsertHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "insertSemicolonAtCaret";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "moveToTheEndOfParentStatement";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum FunctionReturnsState {
        ALL_NON_EMPTY,
        EMPTY_EXISTS,
        NO_RETURNS;

    }
}

