/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpKeywordInsertHandler
implements InsertHandler<LookupElement> {
    private static final InsertHandler<LookupElement> SPACE_BEFORE = ParenthesesInsertHandler.getInstance((boolean)true, (boolean)true, (boolean)false, (boolean)true, (boolean)false);
    private static final InsertHandler<LookupElement> NO_SPACE_BEFORE = ParenthesesInsertHandler.getInstance((boolean)true, (boolean)false, (boolean)false, (boolean)true, (boolean)false);
    private final IElementType keyword;

    public PhpKeywordInsertHandler(@NotNull IElementType keyword) {
        if (keyword == null) {
            PhpKeywordInsertHandler.$$$reportNull$$$0(0);
        }
        this.keyword = keyword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        InsertHandler<LookupElement> delegate;
        if (context == null) {
            PhpKeywordInsertHandler.$$$reportNull$$$0(1);
        }
        if (item == null) {
            PhpKeywordInsertHandler.$$$reportNull$$$0(2);
        }
        if ((delegate = this.getInsertHandler(context.getFile())) != null) {
            try {
                delegate.handleInsert(context, item);
            }
            finally {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getDocument());
            }
        }
    }

    @Nullable
    private InsertHandler<LookupElement> getInsertHandler(@NotNull PsiFile file) {
        if (file == null) {
            PhpKeywordInsertHandler.$$$reportNull$$$0(3);
        }
        CommonCodeStyleSettings commonSettings = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE);
        PhpCodeStyleSettings customSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        if (this.keyword == PhpTokenTypes.kwIF || this.keyword == PhpTokenTypes.kwELSEIF) {
            return PhpKeywordInsertHandler.getInsertHandler(commonSettings.SPACE_BEFORE_IF_PARENTHESES);
        }
        if (this.keyword == PhpTokenTypes.kwWHILE) {
            return PhpKeywordInsertHandler.getInsertHandler(commonSettings.SPACE_BEFORE_WHILE_PARENTHESES);
        }
        if (this.keyword == PhpTokenTypes.kwFOR || this.keyword == PhpTokenTypes.kwFOREACH) {
            return PhpKeywordInsertHandler.getInsertHandler(commonSettings.SPACE_BEFORE_FOR_PARENTHESES);
        }
        if (this.keyword == PhpTokenTypes.kwSWITCH) {
            return PhpKeywordInsertHandler.getInsertHandler(commonSettings.SPACE_BEFORE_SWITCH_PARENTHESES);
        }
        if (this.keyword == PhpTokenTypes.kwCATCH) {
            return PhpKeywordInsertHandler.getInsertHandler(commonSettings.SPACE_BEFORE_CATCH_PARENTHESES);
        }
        if (this.keyword == PhpTokenTypes.kwFUNCTION) {
            return PhpKeywordInsertHandler.getInsertHandler(customSettings.SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS);
        }
        if (this.keyword == PhpTokenTypes.kwFN) {
            return PhpKeywordInsertHandler.getInsertHandler(customSettings.SPACE_BEFORE_SHORT_CLOSURE_LEFT_PARENTHESIS);
        }
        if (this.keyword == PhpTokenTypes.kwUSE) {
            return PhpKeywordInsertHandler.getInsertHandler(true);
        }
        if (this.keyword == PhpTokenTypes.kwMATCH) {
            return PhpKeywordInsertHandler.getInsertHandler(true);
        }
        return null;
    }

    @NotNull
    private static InsertHandler<LookupElement> getInsertHandler(boolean spaceBeforeParentheses) {
        InsertHandler<LookupElement> insertHandler = spaceBeforeParentheses ? SPACE_BEFORE : NO_SPACE_BEFORE;
        if (insertHandler == null) {
            PhpKeywordInsertHandler.$$$reportNull$$$0(4);
        }
        return insertHandler;
    }

    public String toString() {
        return "PhpKeywordInsertHandler{keyword=" + this.keyword + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/insert/PhpKeywordInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/insert/PhpKeywordInsertHandler";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInsertHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getInsertHandler";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

