/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion.insert;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.jetbrains.php.lang.PhpLangUtil;
import org.jetbrains.annotations.NotNull;

public final class PhpInsertHandlerUtil {
    private PhpInsertHandlerUtil() {
    }

    public static boolean isStringAtCaret(@NotNull Editor editor, @NotNull String string) {
        if (editor == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(0);
        }
        if (string == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(1);
        }
        int startOffset = editor.getCaretModel().getOffset();
        String fileText = editor.getDocument().getText();
        return fileText.startsWith(string, startOffset);
    }

    public static void insertStringAtCaret(@NotNull Editor editor, String string) {
        if (editor == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(2);
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
        PsiDocumentManager.getInstance((Project)editor.getProject()).commitDocument(editor.getDocument());
    }

    public static void insertStringAtCaret(@NotNull InsertionContext context, @NotNull String string) {
        if (context == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(3);
        }
        if (string == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(4);
        }
        Editor editor = context.getEditor();
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)string);
        PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(editor.getDocument());
    }

    public static void insertQualifier(@NotNull InsertionContext context, @NotNull String qualifier) {
        String parentNamespace;
        if (context == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(5);
        }
        if (qualifier == null) {
            PhpInsertHandlerUtil.$$$reportNull$$$0(6);
        }
        if (!(parentNamespace = PhpLangUtil.getParentQualifiedName(qualifier)).isEmpty()) {
            StringBuilder textToInsertBuilder = new StringBuilder();
            textToInsertBuilder.append(parentNamespace);
            textToInsertBuilder.append("\\");
            context.getDocument().insertString(context.getStartOffset(), (CharSequence)textToInsertBuilder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/insert/PhpInsertHandlerUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isStringAtCaret";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStringAtCaret";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "insertQualifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

