/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Condition;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import org.jetbrains.annotations.NotNull;

public class PhpOverriddenMembersCompletionContributor
extends CompletionContributor
implements DumbAware {
    public PhpOverriddenMembersCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Method.class), new PhpOverriddenMethodsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(Field.class), new PhpOverriddenFieldsCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(PhpClass.class), new PhpOverriddenMembersCompletionProvider());
    }

    private static class PhpOverriddenMembersCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpOverriddenMembersCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement prev;
            PsiElement position;
            PhpClass currentClass;
            if (parameters == null) {
                PhpOverriddenMembersCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpOverriddenMembersCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpOverriddenMembersCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((currentClass = (PhpClass)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && !PhpPsiUtil.isOfType(prev = PhpPsiUtil.getPrevSibling(position, PhpPsiUtil.PSI_WHITE_SPACE_INSTANCEOF, PhpPsiUtil.PSI_ERROR_ELEMENT_INSTANCEOF), PhpTokenTypes.tsKEYWORDS.getTypes()) && !(prev instanceof PhpModifierList)) {
                boolean includeMagic;
                boolean bl = includeMagic = parameters.getInvocationCount() > 1 || position.getText().startsWith("_");
                if (!includeMagic) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
                result.addAllElements(PhpVariantsUtil.getLookupItemsToSuggestName(currentClass, null, includeMagic));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpOverriddenMembersCompletionContributor$PhpOverriddenMembersCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpOverriddenFieldsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpOverriddenFieldsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            Field field;
            if (parameters == null) {
                PhpOverriddenFieldsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpOverriddenFieldsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpOverriddenFieldsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((field = (Field)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), false, (Condition<? super PsiElement>)Field.INSTANCEOF)) != null) {
                result.addAllElements(PhpVariantsUtil.getLookupItemsToSuggestName((PhpClassMember)field, false));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpOverriddenMembersCompletionContributor$PhpOverriddenFieldsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PhpOverriddenMethodsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private PhpOverriddenMethodsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
            PsiElement position;
            Method method;
            if (parameters == null) {
                PhpOverriddenMethodsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpOverriddenMethodsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result == null) {
                PhpOverriddenMethodsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((method = (Method)PhpPsiUtil.getParentByCondition(position = parameters.getPosition().getOriginalElement(), false, (Condition<? super PsiElement>)Method.INSTANCEOF)) != null) {
                boolean includeMagic;
                boolean bl = includeMagic = parameters.getInvocationCount() > 1 || parameters.getPosition().getText().startsWith("__");
                if (!includeMagic) {
                    result.addLookupAdvertisement(PhpBundle.message("completion.press.again.to.see.more.variants", PhpCompletionContributor.getCompletionActionShortcut()));
                }
                result.addAllElements(PhpVariantsUtil.getLookupItemsToSuggestName((PhpClassMember)method, includeMagic));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/completion/PhpOverriddenMembersCompletionContributor$PhpOverriddenMethodsCompletionProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

