/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.PhpVariantsUtil;
import com.jetbrains.php.completion.statistics.PhpCompletionUsageCollector;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class PhpFqnLookupElement
extends PhpLookupElement {
    private final String myBareFqn;

    public PhpFqnLookupElement(@NotNull PhpNamedElement namedElement) {
        if (namedElement == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(0);
        }
        super(namedElement);
        this.myBareFqn = this.myFQN.replaceAll("\\\\", "");
    }

    public Set<String> getAllLookupStrings() {
        return ImmutableSet.of((Object)this.getLookupString(), (Object)this.myBareFqn);
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(1);
        }
        if (PhpVariantsUtil.fqcnCompletionEnabled()) {
            this.triggerFqcnUsage(context);
        }
        super.handleInsert(context);
    }

    private void triggerFqcnUsage(@NotNull InsertionContext context) {
        ClassReference classReference;
        if (context == null) {
            PhpFqnLookupElement.$$$reportNull$$$0(2);
        }
        if ((classReference = (ClassReference)PhpPsiUtil.getParentByCondition(context.getFile().findElementAt(context.getStartOffset()), false, (Condition<? super PsiElement>)ClassReference.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) == null || !classReference.getImmediateNamespaceName().isEmpty()) {
            return;
        }
        PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
        if (scope != null && PhpLangUtil.isFqn(PhpCodeInsightUtil.createQualifiedName(scope, this.myFQN))) {
            PhpCompletionUsageCollector.triggerInsertFqcn(this.getProject());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namedElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/completion/PhpFqnLookupElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "triggerFqcnUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

