/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.completion.insert.PhpFunctionInsertHandler;
import com.jetbrains.php.completion.insert.PhpReferenceInsertHandler;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.refactoring.move.member.PhpMoveMemberProcessor;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClassStaticMemberLookupElement
extends PhpLookupElement {
    private static final InsertHandler HANDLER = new InsertHandler(){

        public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
            PhpClassMember classMember;
            if (context == null) {
                1.$$$reportNull$$$0(0);
            }
            if (item == null) {
                1.$$$reportNull$$$0(1);
            }
            if ((classMember = (PhpClassMember)ObjectUtils.tryCast((Object)item.getObject(), PhpClassMember.class)) != null) {
                this.tryToReplaceClassReferenceWithSelf(context, item, classMember);
                if (classMember instanceof Method) {
                    PhpFunctionInsertHandler.getInstance().handleInsert(context, item);
                } else {
                    PhpReferenceInsertHandler.getInstance().handleInsert(context, item);
                }
            }
        }

        private void tryToReplaceClassReferenceWithSelf(@NotNull InsertionContext context, @NotNull LookupElement item, PhpClassMember classMember) {
            boolean targetCanBeReferencedAsSelf;
            if (context == null) {
                1.$$$reportNull$$$0(2);
            }
            if (item == null) {
                1.$$$reportNull$$$0(3);
            }
            PhpClass containingClass = PhpClassStaticMemberLookupElement.getContainingClass((PhpNamedElement)classMember);
            PhpPsiElement usage = (PhpPsiElement)PhpPsiUtil.getParentByCondition(PsiUtilCore.getElementAtOffset((PsiFile)context.getFile(), (int)context.getStartOffset()), (Condition<? super PsiElement>)((Condition)PhpPsiElement.class::isInstance));
            if (usage != null && containingClass != null && (targetCanBeReferencedAsSelf = PhpMoveMemberProcessor.targetCanBeReferencedAsSelf(usage, Collections.emptyList(), containingClass.getFQN()))) {
                PsiDocumentManager.getInstance((Project)context.getProject()).doPostponedOperationsAndUnblockDocument(context.getDocument());
                String containingClassName = containingClass.getName();
                int startOffset = context.getEditor().getCaretModel().getOffset() - item.getLookupString().length();
                context.getEditor().getDocument().replaceString(startOffset, startOffset + containingClassName.length(), (CharSequence)"self");
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/completion/PhpClassStaticMemberLookupElement$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleInsert";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "tryToReplaceClassReferenceWithSelf";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    public PhpClassStaticMemberLookupElement(PhpClassMember phpClassMember) {
        super((PhpNamedElement)phpClassMember);
        this.handler = HANDLER;
    }

    public PhpClassStaticMemberLookupElement(PhpClassMember phpClassMember, InsertHandler<PhpLookupElement> insertHandler) {
        super((PhpNamedElement)phpClassMember);
        this.handler = insertHandler;
    }

    @Override
    protected void updatePresentation(PhpNamedElement myNamedElement) {
        super.updatePresentation(myNamedElement);
        PhpClass containingClass = PhpClassStaticMemberLookupElement.getContainingClass(myNamedElement);
        if (containingClass != null) {
            this.lookupString = containingClass.getName() + "::" + myNamedElement.getName();
        }
    }

    @Nullable
    private static PhpClass getContainingClass(PhpNamedElement myNamedElement) {
        return myNamedElement instanceof PhpClassMember ? ((PhpClassMember)myNamedElement).getContainingClass() : null;
    }

    public Set<String> getAllLookupStrings() {
        PhpNamedElement element = (PhpNamedElement)ObjectUtils.tryCast((Object)this.getNamedElement(), PhpNamedElement.class);
        Set result = super.getAllLookupStrings();
        if (element != null) {
            THashSet lookupStrings = new THashSet((Collection)result);
            lookupStrings.add(element.getName());
            return lookupStrings;
        }
        return result;
    }
}

