/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpLookupElement;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpUndefinedCallbackInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpClassAndMethodNamesInStringLiteralCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        PsiElement position;
        ArrayCreationExpression arrayCreationExpression;
        if (parameters == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(2);
        }
        if ((arrayCreationExpression = (ArrayCreationExpression)PhpPsiUtil.getParentByCondition(position = parameters.getPosition(), false, (Condition<? super PsiElement>)ArrayCreationExpression.INSTANCEOF)) == null || arrayCreationExpression.getHashElements().iterator().hasNext()) {
            return;
        }
        List values = PhpPsiUtil.getChildren((PsiElement)arrayCreationExpression, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.ARRAY_VALUE)));
        if (values.isEmpty() || values.size() > 2) {
            return;
        }
        Parameter parameter = PhpWorkaroundUtil.getFunctionParameter((PsiElement)arrayCreationExpression);
        if (parameter == null || !PhpUndefinedCallbackInspection.isCallableParameter(parameter, (PsiElement)arrayCreationExpression, false)) {
            return;
        }
        if (PsiTreeUtil.isAncestor((PsiElement)((PsiElement)values.get(0)), (PsiElement)position, (boolean)true)) {
            PhpCompletionContributor.PhpStringLiteralClassesCompletionProvider.addCompletions(parameters, result);
        } else {
            String classFqn;
            PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder callback = (PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder)ObjectUtils.tryCast((Object)PhpCallbackFunctionUtil.createCallback((PsiElement)arrayCreationExpression), PhpCallbackFunctionUtil.PhpMemberCallbackInfoHolder.class);
            PsiElement element = callback != null ? callback.getClassElement() : null;
            String string = classFqn = element != null ? PhpUndefinedCallbackInspection.checkClassReference(element) : null;
            if (classFqn != null) {
                PhpClassAndMethodNamesInStringLiteralCompletionProvider.addMethodsLookupElements(position.getProject(), PhpLangUtil.toFQN(classFqn), element instanceof StringLiteralExpression, result);
            }
        }
    }

    private static void addMethodsLookupElements(Project project, String classFqn, boolean staticContext, @NotNull CompletionResultSet result) {
        if (result == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(3);
        }
        PhpIndex index = PhpIndex.getInstance((Project)project);
        index.getClassesByFQN(classFqn).stream().flatMap(e -> e.getMethods().stream()).filter(e -> e.isStatic() || !staticContext).map(PhpClassAndMethodNamesInStringLiteralCompletionProvider::createLookupElementWithoutHandler).forEach(arg_0 -> ((CompletionResultSet)result).addElement(arg_0));
    }

    @NotNull
    private static PhpLookupElement createLookupElementWithoutHandler(Method method) {
        PhpLookupElement element = new PhpLookupElement((PhpNamedElement)method);
        element.handler = null;
        PhpLookupElement phpLookupElement = element;
        if (phpLookupElement == null) {
            PhpClassAndMethodNamesInStringLiteralCompletionProvider.$$$reportNull$$$0(4);
        }
        return phpLookupElement;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/completion/PhpClassAndMethodNamesInStringLiteralCompletionProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/completion/PhpClassAndMethodNamesInStringLiteralCompletionProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElementWithoutHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addCompletions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMethodsLookupElements";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

