/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCaseConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpExitPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpBaseCaseConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpConditionInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionWithInversedEx;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeStateInferredAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpInstructionExplicitStopListener;
import com.jetbrains.php.codeInsight.typeInference.PhpTypeAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableTypeDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.resolve.types.PhpUnaryInfixPostfixTP;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpVariableInferredTypeAnalyzerProcessor
extends PhpTypeAnalyzerProcessor
implements PhpInstructionExplicitStopListener {
    private static final Function<PhpType, PhpType> REPLACE_NULL_WITH_ARRAY = t -> PhpType.intersects((PhpType)t, (PhpType)PhpType.NULL) ? PhpVariableInferredTypeAnalyzerProcessor.exchangeNullWithArray(t) : t;
    private static final Function<PhpType, PhpType> ADD_ARRAY = PhpVariableInferredTypeAnalyzerProcessor::exchangeNullWithArray;
    @NotNull
    private final Variable myVariable;
    @NotNull
    private final CharSequence myVariableName;
    @NotNull
    private final PhpScopeHolder myScopeHolder;
    private final HashSet<PhpInstruction> myVisited;
    private final boolean myOriginalReadOrReadRef;
    private final PhpInstruction myOriginalInstruction;
    private Function<PhpType, PhpType> myArrayAccessTypeAdjuster;
    private final Map<PhpInstructionWithInversedEx, PhpType> myComputedDFAStateTypes;
    private final Collection<PhpInstructionWithInversedEx> myNonComputedDFAStates;
    private final Collection<TextRange> myProcessedConditionInstructionRanges;
    private final PhpType myTypeFromExplicitPassByRef;
    private boolean myAssignedByRef;
    private boolean myTraversalWasTerminated;
    private boolean myReadOrOreadRefAccessExists;

    @NotNull
    private static PhpType exchangeNullWithArray(PhpType t) {
        PhpType phpType = new PhpType().add(t.filterNull()).add(PhpType.ARRAY);
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    public PhpVariableInferredTypeAnalyzerProcessor(@NotNull Variable variable, @NotNull CharSequence variableName, @NotNull PhpScopeHolder scopeHolder, PhpInstruction originalInstruction) {
        if (variable == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(1);
        }
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(2);
        }
        if (scopeHolder == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(3);
        }
        this.myComputedDFAStateTypes = new HashMap<PhpInstructionWithInversedEx, PhpType>();
        this.myNonComputedDFAStates = new HashSet<PhpInstructionWithInversedEx>();
        this.myProcessedConditionInstructionRanges = new HashSet<TextRange>();
        this.myTypeFromExplicitPassByRef = new PhpType();
        this.myAssignedByRef = false;
        this.myTraversalWasTerminated = false;
        this.myReadOrOreadRefAccessExists = false;
        this.myVariable = variable;
        this.myVariableName = variableName;
        this.myScopeHolder = scopeHolder;
        this.myVisited = new HashSet();
        this.myOriginalInstruction = originalInstruction;
        this.myOriginalReadOrReadRef = this.myOriginalInstruction instanceof PhpAccessVariableInstruction && ((PhpAccessVariableInstruction)this.myOriginalInstruction).getAccess() instanceof PhpAccessInstruction.ReadOrReadRefAccess;
    }

    public boolean processInstruction(PhpInstruction instruction) {
        this.myVisited.add(instruction);
        return super.processInstruction(instruction);
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpPsiElement curAnchor;
        if (instruction.getAnchor() != this.myVariable && this.myVariableName.equals(instruction.getVariableName()) && (curAnchor = instruction.getAnchor()) instanceof Variable) {
            PhpAccessInstruction.Access access = instruction.getAccess();
            if (access instanceof PhpAccessInstruction.ReadOrReadRefAccess) {
                this.myReadOrOreadRefAccessExists = true;
            }
            if (access.isWrite() || access.isWriteRef()) {
                SelfAssignmentExpression expression;
                PsiElement parent;
                if (!this.myAssignedByRef && access.isWriteRef() && PhpVariableInferredTypeAnalyzerProcessor.assignmentByRef(curAnchor)) {
                    this.myAssignedByRef = true;
                }
                if ((parent = curAnchor.getParent()) instanceof UnaryExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.POSTFIX_EXPRESSION)) {
                    this.setType(PhpUnaryInfixPostfixTP.getType((UnaryExpression)parent));
                    super.processAccessVariableInstruction(instruction);
                    return false;
                }
                if (((PhpAccessVariableInstructionImpl)instruction).assignedValueContainsVariable(this.myVariable)) {
                    this.setType(PhpType.MIXED);
                    return true;
                }
                PhpType assignedType = this.getType((PhpAccessInstruction)instruction);
                this.setType(assignedType);
                if (assignedType.isEmpty()) {
                    this.setType(PhpType.MIXED);
                }
                if ((expression = (SelfAssignmentExpression)ObjectUtils.tryCast((Object)parent, SelfAssignmentExpression.class)) == null || expression.getOperationType() == PhpTokenTypes.opCONCAT_ASGN) {
                    super.processAccessVariableInstruction(instruction);
                    return false;
                }
            } else if (!(access instanceof PhpAccessInstruction.ReadOrReadRefAccess) && access.isReadRef() && !PhpLangUtil.isThisReference((PsiElement)curAnchor)) {
                if (PhpVariableInferredTypeAnalyzerProcessor.isAssignedByRef((PsiElement)curAnchor)) {
                    this.myAssignedByRef = true;
                } else {
                    this.myTypeFromExplicitPassByRef.add(this.getTypeFromReadRefAccess((Variable)curAnchor));
                }
            } else if (this.myOriginalReadOrReadRef && (access instanceof PhpAccessInstruction.ReadOrReadRefAccess || access.isRead()) && this.myOriginalInstruction.num() > instruction.num() && !this.myVisited.contains(instruction)) {
                super.processAccessVariableInstruction(instruction);
                this.processAccessInstruction((PhpAccessInstruction)instruction);
                return false;
            }
        }
        super.processAccessVariableInstruction(instruction);
        return true;
    }

    @Override
    public void handleExplicitTraversalTermination() {
        this.myTraversalWasTerminated = true;
    }

    private static boolean assignmentByRef(PhpPsiElement curAnchor) {
        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)curAnchor, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
        return assignment != null && PhpWorkaroundUtil.isAssignByReference(assignment) && assignment.getVariable() == curAnchor && assignment.getValue() instanceof Variable;
    }

    private PhpType getTypeFromReadRefAccess(Variable anchor) {
        PhpType typeFromUsedByRef = this.getTypeFromUsedByRef(anchor);
        if (typeFromUsedByRef != null) {
            return typeFromUsedByRef;
        }
        return PhpType.MIXED;
    }

    private static boolean isAssignedByRef(PsiElement anchor) {
        AssignmentExpression assignment = (AssignmentExpression)PhpPsiUtil.getParentByCondition(anchor, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF);
        if (assignment != null && PhpWorkaroundUtil.isAssignByReference(assignment) && assignment.getValue() == anchor) {
            return assignment.getVariable() instanceof Variable;
        }
        return false;
    }

    public boolean isAssignedByRef() {
        return this.myAssignedByRef;
    }

    private PhpType getTypeFromUsedByRef(Variable variable) {
        com.jetbrains.php.lang.psi.elements.Function closure = (com.jetbrains.php.lang.psi.elements.Function)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)com.jetbrains.php.lang.psi.elements.Function.INSTANCEOF);
        if (closure != null && closure.isClosure() && PhpPsiUtil.getUsedVariables(closure).contains(variable)) {
            PhpExitPointInstruction exitPoint = closure.getControlFlow().getExitPoint();
            return PhpVariableInferredTypeAnalyzerProcessor.inferType(variable, variable.getNameCS(), this.myScopeHolder, (PhpInstruction)exitPoint);
        }
        return null;
    }

    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        super.processEntryPointInstruction(instruction);
        if (PhpLangUtil.isThisReference(this.myVariableName)) {
            PhpClass containingClass;
            PhpScopeHolder curScopeHolder = this.myScopeHolder;
            while (!(curScopeHolder instanceof Method) && curScopeHolder instanceof com.jetbrains.php.lang.psi.elements.Function && ((com.jetbrains.php.lang.psi.elements.Function)curScopeHolder).isClosure()) {
                PsiElement parent = curScopeHolder.getParent();
                curScopeHolder = parent != null ? PhpPsiUtil.getScopeHolder(parent) : null;
            }
            if (curScopeHolder instanceof Method && (containingClass = ((Method)curScopeHolder).getContainingClass()) != null) {
                this.setType(containingClass.getType());
                return false;
            }
        } else if (PhpLangUtil.isSuperGlobal(this.myVariableName)) {
            this.setType(PhpType.ARRAY);
            return false;
        }
        if (this.myScopeHolder instanceof PhpFile) {
            if (!PhpLangUtil.isThisReference(this.myVariableName)) {
                this.setType(new PhpType().add(PhpTypeSignatureKey.VARIABLE.sign(this.myVariableName)));
            }
            return false;
        }
        if (this.myScopeHolder instanceof Method) {
            Method method = (Method)this.myScopeHolder;
            if (PhpLangUtil.isThisReference(this.myVariableName) && !method.isStatic()) {
                PhpClass aClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)method, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                if (aClass != null && PhpLangUtil.isThisReference(this.myVariableName)) {
                    this.setType(aClass.getType());
                    return false;
                }
                return false;
            }
            this.addParameterTypeWithAdjusting((com.jetbrains.php.lang.psi.elements.Function)method);
        } else if (this.myScopeHolder instanceof com.jetbrains.php.lang.psi.elements.Function) {
            com.jetbrains.php.lang.psi.elements.Function function = (com.jetbrains.php.lang.psi.elements.Function)this.myScopeHolder;
            if (function.isClosure()) {
                if (FunctionImpl.isShortArrowFunction(function) && this.inferTypeFromInstructionFromOuterControlFlow(function)) {
                    return false;
                }
                Collection<Variable> variables = PhpPsiUtil.getUsedVariables(function);
                PhpType type = PhpVariableInferredTypeAnalyzerProcessor.getTypeFromDeclarations(this.myVariableName, variables);
                if (type != null) {
                    this.setType(type);
                    return false;
                }
            }
            this.addParameterTypeWithAdjusting(function);
        }
        return false;
    }

    public void addParameterTypeWithAdjusting(com.jetbrains.php.lang.psi.elements.Function function) {
        boolean parameterExists;
        boolean bl = parameterExists = !this.addParameterType(function);
        if (this.myArrayAccessTypeAdjuster != null && !this.myReadOrOreadRefAccessExists) {
            this.setType(this.myArrayAccessTypeAdjuster.apply(parameterExists ? this.getType() : PhpType.NULL));
        }
    }

    private boolean addParameterType(com.jetbrains.php.lang.psi.elements.Function function) {
        Parameter parameter = (Parameter)ContainerUtil.find((Object[])function.getParameters(), p -> PhpLangUtil.equalsParameterNames(this.myVariableName, p.getName()));
        if (parameter == null) {
            return true;
        }
        boolean declaredTypeIsEmpty = parameter.getDeclaredType().isEmpty() && parameter.getDocType().isEmpty();
        PhpType parameterType = parameter.getType();
        if (this.isVariadic(parameter)) {
            parameterType = parameterType.pluralise();
        }
        if (declaredTypeIsEmpty && (this.getType().isEmpty() && PhpVariableInferredTypeAnalyzerProcessor.parameterTypeInferredOnlyFromDefaultValue(parameter, parameterType) || !this.getType().isEmpty() && this.myTraversalWasTerminated)) {
            parameterType = PhpType.or((PhpType)parameterType, (PhpType)PhpType.MIXED);
        }
        this.setType(parameterType);
        if (!parameterType.filterUnknown().isEmpty()) {
            this.removeAmbiguousDfaTypes();
        }
        return false;
    }

    private boolean isVariadic(Parameter parameter) {
        if (parameter.isVariadic()) {
            return true;
        }
        PhpDocParamTag tag = parameter.getDocTag();
        return tag != null && tag.isVariadic();
    }

    private static boolean parameterTypeInferredOnlyFromDefaultValue(Parameter parameter, PhpType parameterType) {
        return !parameterType.isEmpty() && parameterType.equals((Object)new PhpType().add(parameter.getDefaultValue()));
    }

    private void removeAmbiguousDfaTypes() {
        this.myComputedDFAStateTypes.keySet().removeIf(key -> this.myNonComputedDFAStates.contains(key.getInverseInstruction()));
    }

    private boolean inferTypeFromInstructionFromOuterControlFlow(@NotNull com.jetbrains.php.lang.psi.elements.Function function) {
        PhpAccessVariableInstruction instructionInOuterControlFlow;
        PhpScopeHolder outerScopeHolder;
        if (function == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(4);
        }
        if ((outerScopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)function)) != null && (instructionInOuterControlFlow = (PhpAccessVariableInstruction)outerScopeHolder.getControlFlow().getInstruction((PhpPsiElement)this.myVariable, PhpAccessVariableInstruction.class)) != null) {
            this.setType(PhpVariableInferredTypeAnalyzerProcessor.inferTypeDfaBasedTypeStateAware(this.myVariable, this.myVariableName, outerScopeHolder, (PhpInstruction)instructionInOuterControlFlow));
            return true;
        }
        return false;
    }

    @Nullable
    private static PhpType getTypeFromDeclarations(@NotNull CharSequence variableName, Collection<? extends PhpNamedElement> variables) {
        if (variableName == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(5);
        }
        for (PhpNamedElement phpNamedElement : variables) {
            if (phpNamedElement == null || !PhpLangUtil.equalsVariableNames(variableName, phpNamedElement.getName())) continue;
            return phpNamedElement.getType();
        }
        return null;
    }

    public boolean processCaseConditionInstruction(PhpCaseConditionInstruction instruction) {
        super.processCaseConditionInstruction(instruction);
        PsiElement argument = instruction.getSwitchArgument();
        if (argument instanceof Variable && PhpLangUtil.equalsVariableNames(((Variable)argument).getName(), this.myVariableName) || PhpLangUtil.isTrue(argument)) {
            return this.performDataFlowAnalyze(instruction.getCaseArgument(), instruction.getResult(), (PhpBaseCaseConditionInstructionImpl)instruction);
        }
        return true;
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        super.processConditionInstruction(instruction);
        PsiElement condition = instruction.getCondition();
        if (condition == null) {
            return true;
        }
        TextRange range = condition.getTextRange();
        if (condition == this.myVariable || this.myProcessedConditionInstructionRanges.stream().anyMatch(t -> !t.equals((Object)range) && t.contains(range))) {
            return true;
        }
        this.myProcessedConditionInstructionRanges.add(condition.getTextRange());
        return this.performDataFlowAnalyze(condition, instruction.getResult(), (PhpConditionInstructionImpl)instruction);
    }

    private boolean performDataFlowAnalyze(@Nullable PsiElement condition, boolean result, @NotNull PhpInstructionWithInversedEx instruction) {
        PhpVariableTypeDFAnalyzer analyzer;
        Map typeMap;
        if (instruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(6);
        }
        if ((typeMap = (Map)(analyzer = new PhpVariableTypeDFAnalyzer(this.myVariableName)).performDFA(condition, result)).containsKey(this.myVariableName)) {
            PhpType type = (PhpType)typeMap.get(this.myVariableName);
            if (!type.isEmpty()) {
                this.myComputedDFAStateTypes.computeIfAbsent(instruction, i -> new PhpType()).add(type);
            }
            return !analyzer.completeTypeComputed();
        }
        this.myNonComputedDFAStates.add(instruction);
        return true;
    }

    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        MultiDimensionalArrayAccessInfo info;
        if (instruction.getAccess().isWrite() && (info = PhpVariableInferredTypeAnalyzerProcessor.getMultiDimensionalArrayAccessInfo(instruction)) != null && this.myVariableName.equals(info.myBaseVariableName)) {
            this.myArrayAccessTypeAdjuster = info.myDimension > 1 ? ADD_ARRAY : REPLACE_NULL_WITH_ARRAY;
        }
        return true;
    }

    @Nullable
    public static MultiDimensionalArrayAccessInfo getMultiDimensionalArrayAccessInfo(PhpArrayAccessInstruction instruction) {
        CharSequence variableName = instruction.getVariableName();
        if (variableName != null) {
            return new MultiDimensionalArrayAccessInfo(variableName, 1);
        }
        return PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction.getAnchor(), 0);
    }

    @Nullable
    public static CharSequence getBaseVariableName(PhpArrayAccessInstruction instruction) {
        MultiDimensionalArrayAccessInfo info = PhpVariableInferredTypeAnalyzerProcessor.getMultiDimensionalArrayAccessInfo(instruction);
        return info != null ? info.myBaseVariableName : null;
    }

    private static MultiDimensionalArrayAccessInfo getBaseVariableName(PhpPsiElement element, int dimension) {
        if (element instanceof Variable) {
            return new MultiDimensionalArrayAccessInfo(element.getName(), dimension);
        }
        if (element instanceof ArrayAccessExpression) {
            return PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(((ArrayAccessExpression)element).getValue(), dimension + 1);
        }
        return null;
    }

    @Override
    @NotNull
    public PhpType getType() {
        PhpType type = this.getTypeAmbiguousDfaStatesAware();
        if (!type.isEmpty()) {
            PhpType phpType = PhpType.or((PhpType)type, (PhpType)this.myTypeFromExplicitPassByRef);
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(7);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(8);
        }
        return phpType;
    }

    @NotNull
    private PhpType getTypeAmbiguousDfaStatesAware() {
        PhpType type = super.getType();
        if (this.myComputedDFAStateTypes.isEmpty()) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(9);
            }
            return phpType;
        }
        type = new PhpType().add(type);
        this.myComputedDFAStateTypes.entrySet().stream().map(e -> this.myNonComputedDFAStates.contains(((PhpInstructionWithInversedEx)e.getKey()).getInverseInstruction()) ? PhpType.or((PhpType)PhpType.MIXED, (PhpType)((PhpType)e.getValue())) : (PhpType)e.getValue()).forEach(arg_0 -> ((PhpType)type).add(arg_0));
        PhpType phpType = type;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(10);
        }
        return phpType;
    }

    @Override
    protected boolean processAccessInstruction(@NotNull PhpAccessInstruction accessInstruction) {
        if (accessInstruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(11);
        }
        this.setType(this.getType(accessInstruction));
        return false;
    }

    private PhpType getType(@NotNull PhpAccessInstruction accessInstruction) {
        PhpPsiElement curAnchor;
        if (accessInstruction == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(12);
        }
        if ((curAnchor = accessInstruction.getAnchor()) instanceof PhpTypedElement) {
            PhpType type = PhpTypeInfo.getType((PsiElement)curAnchor);
            return this.myArrayAccessTypeAdjuster != null ? this.myArrayAccessTypeAdjuster.apply(type) : type;
        }
        return PhpType.EMPTY;
    }

    @NotNull
    public static PhpType inferTypeDfaBasedTypeStateAware(Variable variable, CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction instruction) {
        PhpType type = PhpVariableInferredTypeAnalyzerProcessor.inferType(variable, variableName, scopeHolder, instruction);
        if (PhpLangUtil.isThisReference((PsiElement)variable)) {
            PhpType phpType = type;
            if (phpType == null) {
                PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(13);
            }
            return phpType;
        }
        return PhpVariableInferredTypeAnalyzerProcessor.processDfaBasedTypeState(variable, variableName, instruction, type);
    }

    @NotNull
    protected static PhpType inferType(Variable variable, CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction originalInstruction) {
        PhpVariableInferredTypeAnalyzerProcessor processor = new PhpVariableInferredTypeAnalyzerProcessor(variable, variableName, scopeHolder, originalInstruction);
        PhpControlFlowUtil.processPredecessors(originalInstruction, false, processor);
        PhpType variableType = processor.getType();
        if (processor.isAssignedByRef()) {
            PhpType assignedByRefTypes = new PhpType();
            Collection<PhpAccessVariableInstruction> instructions = PhpVariableInferredTypeAnalyzerProcessor.getByRefAssignedVariablesInstructions(variable, originalInstruction);
            if (!instructions.isEmpty()) {
                Ref ambiguousType = new Ref((Object)Boolean.FALSE);
                List<PhpType> typesFromIndirectByRefAssignment = instructions.stream().map(variablesInstruction -> PhpVariableInferredTypeAnalyzerProcessor.inferTypeFromByRefIndirectAssignment(variableName, scopeHolder, originalInstruction, variableType, variablesInstruction, (Ref<Boolean>)ambiguousType)).filter(Objects::nonNull).collect(Collectors.toList());
                typesFromIndirectByRefAssignment.forEach(arg_0 -> ((PhpType)assignedByRefTypes).add(arg_0));
                if (!typesFromIndirectByRefAssignment.isEmpty()) {
                    if (((Boolean)ambiguousType.get()).booleanValue()) {
                        PhpType phpType = PhpType.or((PhpType)variableType, (PhpType)assignedByRefTypes);
                        if (phpType == null) {
                            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(14);
                        }
                        return phpType;
                    }
                    PhpType phpType = assignedByRefTypes;
                    if (phpType == null) {
                        PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(15);
                    }
                    return phpType;
                }
            }
        }
        PhpType phpType = variableType;
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(16);
        }
        return phpType;
    }

    private static PhpType inferTypeFromByRefIndirectAssignment(final CharSequence variableName, PhpScopeHolder scopeHolder, PhpInstruction originalInstruction, final PhpType variableType, final PhpAccessVariableInstruction writeByRefInstruction, final Ref<Boolean> ambiguousType) {
        CharSequence variableNameLinkedByRef;
        Variable v = (Variable)ObjectUtils.tryCast((Object)writeByRefInstruction.getAnchor(), Variable.class);
        if (v == null) {
            return PhpType.EMPTY;
        }
        CharSequence charSequence = variableNameLinkedByRef = PhpLangUtil.equalsVariableNames(writeByRefInstruction.getVariableName(), variableName) ? PhpVariableInferredTypeAnalyzerProcessor.getAssignedVariableName(writeByRefInstruction) : writeByRefInstruction.getVariableName();
        if (variableNameLinkedByRef == null) {
            return PhpType.EMPTY;
        }
        PhpVariableInferredTypeAnalyzerProcessor p = new PhpVariableInferredTypeAnalyzerProcessor(v, variableNameLinkedByRef, scopeHolder, originalInstruction){

            @Override
            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (instruction.num() <= writeByRefInstruction.num()) {
                    if (instruction.num() == writeByRefInstruction.num()) {
                        ambiguousType.set((Object)Boolean.TRUE);
                    }
                    return false;
                }
                if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variableName)) {
                    this.setType(variableType);
                    return false;
                }
                return super.processAccessVariableInstruction(instruction);
            }
        };
        PhpControlFlowUtil.processPredecessors(originalInstruction, false, p);
        return p.getType();
    }

    @Nullable
    private static CharSequence getAssignedVariableName(PhpAccessVariableInstruction instruction) {
        Variable assignedVariable = (Variable)ObjectUtils.tryCast((Object)((PhpAccessVariableInstructionImpl)instruction).getAssignedValue(), Variable.class);
        return assignedVariable != null ? assignedVariable.getNameCS() : null;
    }

    private static Collection<PhpAccessVariableInstruction> getByRefAssignedVariablesInstructions(Variable variable, PhpInstruction instruction) {
        final String variableName = variable.getName();
        final HashSet<PhpAccessVariableInstruction> res = new HashSet<PhpAccessVariableInstruction>();
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction i) {
                PhpAccessInstruction.Access access = i.getAccess();
                if (access.isWrite() || access.isWriteRef()) {
                    Variable assignedValue;
                    if (PhpLangUtil.equalsVariableNames(i.getVariableName(), variableName)) {
                        if (PhpVariableInferredTypeAnalyzerProcessor.assignmentByRef(i.getAnchor())) {
                            res.add(i);
                        }
                        return false;
                    }
                    if (access.isWriteRef() && (assignedValue = (Variable)ObjectUtils.tryCast((Object)((PhpAccessVariableInstructionImpl)i).getAssignedValue(), Variable.class)) != null && PhpLangUtil.equalsVariableNames(assignedValue.getName(), variableName)) {
                        res.add(i);
                        return false;
                    }
                }
                return super.processAccessVariableInstruction(i);
            }
        });
        return res;
    }

    @NotNull
    private static PhpType processDfaBasedTypeState(Variable variable, CharSequence variableName, PhpInstruction instruction, PhpType type) {
        PhpDfaBasedTypeStateInferredAnalyzerProcessor dfaStateProcessor = new PhpDfaBasedTypeStateInferredAnalyzerProcessor(variableName, variable, false);
        PhpControlFlowUtil.processPredecessors(instruction, false, dfaStateProcessor);
        PhpType phpType = dfaStateProcessor.apply(type);
        if (phpType == null) {
            PhpVariableInferredTypeAnalyzerProcessor.$$$reportNull$$$0(17);
        }
        return phpType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableInferredTypeAnalyzerProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "exchangeNullWithArray";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpVariableInferredTypeAnalyzerProcessor";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeAmbiguousDfaStatesAware";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "inferTypeDfaBasedTypeStateAware";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "inferType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "processDfaBasedTypeState";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "inferTypeFromInstructionFromOuterControlFlow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromDeclarations";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "performDataFlowAnalyze";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processAccessInstruction";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MultiDimensionalArrayAccessInfo {
        private final int myDimension;
        private final CharSequence myBaseVariableName;

        MultiDimensionalArrayAccessInfo(CharSequence name, int dimension) {
            this.myDimension = dimension;
            this.myBaseVariableName = name;
        }
    }
}

