/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessFieldByVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpArrayAccessTypeDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFieldReferenceArrayAccessTypeAnalyzer
extends PhpArrayAccessTypeAnalyzer {
    private final String myName;
    @NotNull
    private final PsiElement myClassReference;

    public PhpFieldReferenceArrayAccessTypeAnalyzer(@NotNull PsiElement classReference, String fieldName, PsiElement key) {
        if (classReference == null) {
            PhpFieldReferenceArrayAccessTypeAnalyzer.$$$reportNull$$$0(0);
        }
        super(key);
        this.myClassReference = classReference;
        this.myName = fieldName;
    }

    @Override
    protected boolean isSameValue(PhpArrayAccessInstruction curInstruction) {
        return curInstruction.getVariableName() == null && this.sameFieldReference((ArrayAccessExpression)curInstruction.getAnchor());
    }

    private boolean sameFieldReference(ArrayAccessExpression anchor) {
        return this.sameFieldReference((PsiElement)anchor.getValue());
    }

    private boolean sameFieldReference(@Nullable PsiElement anchor) {
        FieldReference fieldReference = (FieldReference)ObjectUtils.tryCast((Object)anchor, FieldReference.class);
        if (fieldReference == null) {
            return false;
        }
        PhpExpression classReference = fieldReference.getClassReference();
        return classReference != null && PhpLangUtil.equalsFieldNames(fieldReference.getName(), this.myName) && PsiEquivalenceUtil.areElementsEquivalent((PsiElement)classReference, (PsiElement)this.myClassReference, (o1, o2) -> 0, null, null, (boolean)false);
    }

    @Override
    public boolean processAccessFieldByVariableInstruction(PhpAccessFieldByVariableInstruction instruction) {
        if (this.sameFieldReference((PsiElement)instruction.getAnchor()) && this.elementOverwritten(instruction.getAccess(), (PsiElement)instruction.getAnchor())) {
            this.handlePreliminaryTraversalEnd();
            return false;
        }
        return super.processAccessFieldByVariableInstruction(instruction);
    }

    @Override
    @NotNull
    protected PhpArrayAccessTypeDFAnalyzer createAnalyzer(@Nullable PsiElement key) {
        return new PhpFieldReferenceArrayAccessTypeDFAnalyzer(key);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classReference", "com/jetbrains/php/codeInsight/typeInference/PhpFieldReferenceArrayAccessTypeAnalyzer", "<init>"));
    }

    private final class PhpFieldReferenceArrayAccessTypeDFAnalyzer
    extends PhpArrayAccessTypeDFAnalyzer {
        private PhpFieldReferenceArrayAccessTypeDFAnalyzer(PsiElement key) {
            super(key);
        }

        @Override
        protected boolean isSameArrayValue(PsiElement arrayValue) {
            return PhpFieldReferenceArrayAccessTypeAnalyzer.this.sameFieldReference(arrayValue);
        }
    }
}

