/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBaseStateConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpExcludeTypeTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpOptionalCompletionTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDfaDelegateBasedTypeState
extends PhpDfaBasedTypeState {
    public static final PhpDfaBasedTypeState NOT_PRIMITIVE = new PhpDfaDelegateBasedTypeState("NOT_PRIMITIVE", new PhpDfaBasedTypeState[]{NOT_NULL}){

        @Override
        public PhpType applyTypeAfterDelegates(PhpType type) {
            return type.filterScalarPrimitives();
        }
    };
    public static final PhpDfaBasedTypeState NOT_FALSE_NOT_NULL = new PhpDfaDelegateBasedTypeState("NOT_FALSE_NOT_NULL", NOT_FALSE, NOT_NULL);
    protected final PhpDfaBasedTypeState[] myDelegates;

    public PhpDfaDelegateBasedTypeState(@NotNull String name, PhpDfaBasedTypeState ... delegates) {
        if (name == null) {
            PhpDfaDelegateBasedTypeState.$$$reportNull$$$0(0);
        }
        super(name);
        this.myDelegates = delegates;
    }

    @Override
    public PhpType applyType(PhpType type) {
        for (PhpDfaBasedTypeState delegate : this.myDelegates) {
            type = delegate.applyType(type);
        }
        return this.applyTypeAfterDelegates(type);
    }

    @Override
    public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
        if (state == null) {
            PhpDfaDelegateBasedTypeState.$$$reportNull$$$0(1);
        }
        return super.coveredBy(project, state, global) || Arrays.stream(this.myDelegates).anyMatch(t -> t.coveredBy(project, state, global));
    }

    @Override
    public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
        if (state == null) {
            PhpDfaDelegateBasedTypeState.$$$reportNull$$$0(2);
        }
        return super.excludedBy(project, state, global) || Arrays.stream(this.myDelegates).anyMatch(t -> t.excludedBy(project, state, global));
    }

    protected PhpType applyTypeAfterDelegates(PhpType type) {
        return type;
    }

    static {
        PhpDfaDelegateBasedTypeState.registerPair(NULL, NOT_FALSE_NOT_NULL);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaDelegateBasedTypeState";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "coveredBy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "excludedBy";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class PhpInstanceofTypeState
    extends PhpDfaDelegateBasedTypeState {
        @Nullable
        private final String myClassFqn;

        public PhpInstanceofTypeState(@Nullable String fqn) {
            super("NOT_NULL_BY_INSTANCEOF: " + fqn, NOT_FALSE_NOT_NULL, NOT_PRIMITIVE);
            this.myClassFqn = fqn;
        }

        @Override
        public boolean is(PhpDfaBasedTypeState state) {
            return super.is(state) || state instanceof PhpInstanceofTypeState && this.sameInstanceofArgument((PhpInstanceofTypeState)state);
        }

        private boolean sameInstanceofArgument(PhpInstanceofTypeState state) {
            return PhpLangUtil.equalsClassNames(this.myClassFqn, state.myClassFqn);
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            PhpType myType;
            PhpType followingType;
            if (state == null) {
                PhpInstanceofTypeState.$$$reportNull$$$0(0);
            }
            if (state instanceof PhpInstanceofTypeState && global && this.myClassFqn != null && ((PhpInstanceofTypeState)state).myClassFqn != null && (followingType = new PhpType().add(((PhpInstanceofTypeState)state).myClassFqn)).isConvertibleFrom(myType = new PhpType().add(this.myClassFqn), PhpIndex.getInstance((Project)project))) {
                return true;
            }
            return super.coveredBy(project, state, global);
        }

        @Override
        protected PhpType applyTypeAfterDelegates(PhpType type) {
            PhpType t = super.applyTypeAfterDelegates(type).filterMixed();
            return this.myClassFqn != null ? new PhpType().add(t).add(this.myClassFqn).filterObject().filterOutIncompleteTypesAware((PhpType.PhpTypeExclusion)new PhpExcludeTypeTP.PhpTypesOutsideClassHierarchyExclusion(this.myClassFqn)) : t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/codeInsight/typeInference/PhpDfaDelegateBasedTypeState$PhpInstanceofTypeState", "coveredBy"));
        }
    }

    public static class PhpPrimitiveTypeCheckByStrictComparison
    extends PhpDfaDelegateBasedTypeState {
        private final boolean myNegatedCheck;

        public PhpPrimitiveTypeCheckByStrictComparison(@NotNull Collection<String> primitiveTypeCheckerName, @Nullable PsiElement comparisonOperand, boolean negatedCheck) {
            if (primitiveTypeCheckerName == null) {
                PhpPrimitiveTypeCheckByStrictComparison.$$$reportNull$$$0(0);
            }
            super("Primitive type check by strict comparison", PhpPrimitiveTypeCheckByStrictComparison.getDelegates(primitiveTypeCheckerName, comparisonOperand, negatedCheck));
            this.myNegatedCheck = negatedCheck;
        }

        private static PhpDfaBasedTypeState[] getDelegates(@NotNull Collection<String> primitiveTypeCheckerName, @Nullable PsiElement comparisonOperand, boolean negatedCheck) {
            if (primitiveTypeCheckerName == null) {
                PhpPrimitiveTypeCheckByStrictComparison.$$$reportNull$$$0(1);
            }
            List delegates = ContainerUtil.map(primitiveTypeCheckerName, PhpNotNullByPrimitiveTypeChecker::new);
            if (comparisonOperand != null) {
                delegates.add(new PhpPrimitiveTypeCheckByComparison(comparisonOperand, negatedCheck));
            }
            if (!PhpDfaBaseStateConditionDFAnalyzer.nonStrictNullValue(comparisonOperand) && !negatedCheck) {
                delegates.add(NOT_FALSE_NOT_NULL);
            }
            return delegates.toArray(new PhpDfaBasedTypeState[0]);
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpPrimitiveTypeCheckByStrictComparison.$$$reportNull$$$0(2);
            }
            if (state instanceof PhpPrimitiveTypeCheckByStrictComparison) {
                PhpPrimitiveTypeCheckByComparison prev = this.getPrimitiveTypeCheckByComparison();
                PhpPrimitiveTypeCheckByComparison following = ((PhpPrimitiveTypeCheckByStrictComparison)state).getPrimitiveTypeCheckByComparison();
                if (((PhpPrimitiveTypeCheckByStrictComparison)state).myNegatedCheck == this.myNegatedCheck && prev != null && following != null && prev.coveredBy(project, following, global)) {
                    return true;
                }
            }
            return !this.myNegatedCheck && super.coveredBy(project, state, global);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpPrimitiveTypeCheckByStrictComparison.$$$reportNull$$$0(3);
            }
            if (state instanceof PhpPrimitiveTypeCheckByStrictComparison) {
                PhpPrimitiveTypeCheckByComparison comparison = ((PhpPrimitiveTypeCheckByStrictComparison)state).getPrimitiveTypeCheckByComparison();
                PsiElement operand = comparison.myComparisonOperand;
                PsiElement myOperand = this.getPrimitiveTypeCheckByComparison().myComparisonOperand;
                if (this.myNegatedCheck && !((PhpPrimitiveTypeCheckByStrictComparison)state).myNegatedCheck && new PhpPrimitiveTypeCheckByComparison(myOperand, false).coveredBy(project, comparison, global)) {
                    return true;
                }
                if (!this.myNegatedCheck && !((PhpPrimitiveTypeCheckByStrictComparison)state).myNegatedCheck && PhpPrimitiveTypeCheckByComparison.excludedBy(operand, myOperand)) {
                    return true;
                }
            }
            return !this.myNegatedCheck && super.excludedBy(project, state, global);
        }

        public PhpPrimitiveTypeCheckByComparison getPrimitiveTypeCheckByComparison() {
            return StreamEx.of((Object[])this.myDelegates).select(PhpPrimitiveTypeCheckByComparison.class).findAny().orElse(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primitiveTypeCheckerName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaDelegateBasedTypeState$PhpPrimitiveTypeCheckByStrictComparison";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getDelegates";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpPrimitiveTypeCheckByComparison
    extends PhpDfaBasedTypeState {
        @NotNull
        private final PsiElement myComparisonOperand;
        private final boolean myNegatedCheck;

        public PhpPrimitiveTypeCheckByComparison(@NotNull PsiElement comparisonOperand, boolean negatedCheck) {
            if (comparisonOperand == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(0);
            }
            super("COMPARISON OPERAND " + comparisonOperand.getText());
            this.myComparisonOperand = comparisonOperand;
            this.myNegatedCheck = negatedCheck;
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(1);
            }
            if (state instanceof PhpPrimitiveTypeCheckByComparison && PhpPrimitiveTypeCheckByComparison.areOperandsEquivalent(((PhpPrimitiveTypeCheckByComparison)state).myComparisonOperand, this.myComparisonOperand) && ((PhpPrimitiveTypeCheckByComparison)state).myNegatedCheck == this.myNegatedCheck) {
                return true;
            }
            if (this.myNegatedCheck && state instanceof PhpPrimitiveTypeCheckByStrictComparison && ((PhpPrimitiveTypeCheckByStrictComparison)state).myNegatedCheck) {
                return this.coveredBy(project, ((PhpPrimitiveTypeCheckByStrictComparison)state).getPrimitiveTypeCheckByComparison(), global);
            }
            return super.coveredBy(project, state, global);
        }

        public static boolean areOperandsEquivalent(@NotNull PsiElement operand, @NotNull PsiElement otherOperand) {
            if (operand == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(2);
            }
            if (otherOperand == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(3);
            }
            if (operand instanceof StringLiteralExpression || otherOperand instanceof StringLiteralExpression) {
                return PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(operand) && PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(otherOperand) && PhpStringUtil.unescapeText((StringLiteralExpression)operand).equals(PhpStringUtil.unescapeText((StringLiteralExpression)otherOperand));
            }
            return PsiEquivalenceUtil.areElementsEquivalent((PsiElement)operand, (PsiElement)otherOperand, null, (boolean)false);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static boolean isStringWithoutInterpolations(@NotNull PsiElement operand) {
            if (operand == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(4);
            }
            if (!(operand instanceof StringLiteralExpression)) return false;
            if (!PhpPsiUtil.getChildren(operand, (Condition<? super PsiElement>)((Condition)Variable.class::isInstance)).isEmpty()) return false;
            return true;
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpPrimitiveTypeCheckByComparison.$$$reportNull$$$0(5);
            }
            if (state instanceof PhpPrimitiveTypeCheckByComparison) {
                PsiElement operand = ((PhpPrimitiveTypeCheckByComparison)state).myComparisonOperand;
                if (!this.myNegatedCheck && !((PhpPrimitiveTypeCheckByComparison)state).myNegatedCheck && operand instanceof StringLiteralExpression == this.myComparisonOperand instanceof StringLiteralExpression && PhpPrimitiveTypeCheckByComparison.excludedBy(operand, this.myComparisonOperand)) {
                    return true;
                }
                if (this.myNegatedCheck && !((PhpPrimitiveTypeCheckByComparison)state).myNegatedCheck && new PhpPrimitiveTypeCheckByComparison(this.myComparisonOperand, false).coveredBy(project, state, global)) {
                    return true;
                }
            }
            if (this.myNegatedCheck && state instanceof PhpPrimitiveTypeCheckByStrictComparison && !((PhpPrimitiveTypeCheckByStrictComparison)state).myNegatedCheck) {
                return new PhpPrimitiveTypeCheckByComparison(this.myComparisonOperand, false).coveredBy(project, ((PhpPrimitiveTypeCheckByStrictComparison)state).getPrimitiveTypeCheckByComparison(), global);
            }
            return super.excludedBy(project, state, global);
        }

        private static boolean excludedBy(PsiElement f, PsiElement s) {
            if (PhpDfaBaseStateConditionDFAnalyzer.isStaticConstantReference(f) || PhpDfaBaseStateConditionDFAnalyzer.isStaticConstantReference(s)) {
                return false;
            }
            return PhpPrimitiveTypeCheckByComparison.nonStringOrSimpleString(s) && PhpPrimitiveTypeCheckByComparison.nonStringOrSimpleString(f) && !PhpPrimitiveTypeCheckByComparison.areOperandsEquivalent(s, f);
        }

        private static boolean nonStringOrSimpleString(PsiElement operand) {
            return !(operand instanceof StringLiteralExpression) || PhpPrimitiveTypeCheckByComparison.isStringWithoutInterpolations(operand);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comparisonOperand";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "operand";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherOperand";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaDelegateBasedTypeState$PhpPrimitiveTypeCheckByComparison";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "areOperandsEquivalent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isStringWithoutInterpolations";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class PhpNotNullByPrimitiveTypeChecker
    extends PhpDfaDelegateBasedTypeState {
        public static final PhpDfaBasedTypeState IS_ARRAY_CHECK = new PhpNotNullByPrimitiveTypeChecker("is_array"){

            @Override
            public PhpType applyType(PhpType type) {
                PhpType onlyPlurals = type.filterOut(this::isNonPluralResolvedPrimitiveType);
                PhpType phpType = type.hasUnresolved() || PhpType.intersects((PhpType)type, (PhpType)PhpType.MIXED) || !this.pluralExists(type) ? PhpType.or((PhpType)onlyPlurals, (PhpType)PhpType.ARRAY) : onlyPlurals;
                return super.applyType(phpType);
            }

            private boolean pluralExists(PhpType type) {
                return ContainerUtil.exists((Iterable)type.getTypes(), PhpType::isPluralType);
            }

            private boolean isNonPluralResolvedPrimitiveType(String t) {
                return !PhpType.isUnresolved((String)t) && !"\\mixed".equals(t) && !"\\array".equals(t) && !PhpType.isPluralType((String)t) && PhpType.isNotExtendablePrimitiveType((String)t);
            }
        };
        private final String myPrimitiveTypeCheckerName;

        public PhpNotNullByPrimitiveTypeChecker(@NotNull String primitiveTypeCheckerName) {
            if (primitiveTypeCheckerName == null) {
                PhpNotNullByPrimitiveTypeChecker.$$$reportNull$$$0(0);
            }
            super("NOT_NULL_BY_PRIMITIVE: " + primitiveTypeCheckerName, NOT_NULL);
            this.myPrimitiveTypeCheckerName = primitiveTypeCheckerName;
        }

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpNotNullByPrimitiveTypeChecker.$$$reportNull$$$0(1);
            }
            if (state instanceof PhpPrimitiveTypeCheckByStrictComparison) {
                return false;
            }
            if (state instanceof PhpNotNullByPrimitiveTypeChecker) {
                return this.is(state);
            }
            return state instanceof PhpStrictVariableDfaState && super.coveredBy(project, ((PhpStrictVariableDfaState)state).getDelegate(), global);
        }

        @Override
        public boolean excludedBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                PhpNotNullByPrimitiveTypeChecker.$$$reportNull$$$0(2);
            }
            return state instanceof PhpStrictVariableDfaState && super.excludedBy(project, state, global);
        }

        @Override
        protected PhpType applyTypeAfterDelegates(PhpType type) {
            PhpType res = super.applyTypeAfterDelegates(type).filterMixed();
            if (!res.hasUnresolved()) {
                return res;
            }
            return res.map(s -> PhpType.isUnresolved((String)s) ? PhpOptionalCompletionTP.TYPE_KEY.sign((CharSequence)s) : s);
        }

        @Override
        public boolean is(PhpDfaBasedTypeState state) {
            return super.is(state) || state instanceof PhpNotNullByPrimitiveTypeChecker && PhpLangUtil.equalsFunctionNames(((PhpNotNullByPrimitiveTypeChecker)state).myPrimitiveTypeCheckerName, this.myPrimitiveTypeCheckerName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "primitiveTypeCheckerName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaDelegateBasedTypeState$PhpNotNullByPrimitiveTypeChecker";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "coveredBy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "excludedBy";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

