/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpDfaBasedAnalyzerProcessor<E>
extends PhpInstructionProcessor {
    @Nullable
    protected final CharSequence myVariableName;
    @Nullable
    protected final PsiElement myAnchor;
    protected final MultiMap<TextRange, PhpVariableDfaState<E>> myProcessedRanges = MultiMap.create();
    protected boolean myAmbiguous;
    protected PhpInstruction myLastDfaInstruction;
    protected final Collection<PhpInstruction> myAmbiguousConditionPredecessors = new HashSet<PhpInstruction>();

    public PhpDfaBasedAnalyzerProcessor(@Nullable CharSequence name, @Nullable PsiElement anchor) {
        this.myVariableName = name;
        this.myAnchor = anchor;
    }

    public boolean processInstruction(PhpInstruction instruction) {
        this.myAmbiguousConditionPredecessors.addAll(((PhpInstructionImpl)instruction).getAmbiguousConditionsInstructions());
        return super.processInstruction(instruction);
    }

    public boolean processConditionInstruction(PhpConditionInstruction instruction) {
        super.processConditionInstruction(instruction);
        PsiElement condition = instruction.getCondition();
        if (!this.myAmbiguousConditionPredecessors.contains(instruction)) {
            return this.processCondition(instruction, condition, instruction.getResult());
        }
        return true;
    }

    public boolean processCondition(PhpConditionInstruction instruction, PsiElement condition, boolean result) {
        if (condition == null || this.myAnchor != null && condition == this.myAnchor) {
            return true;
        }
        TextRange outerRange = condition.getTextRange();
        if (this.myProcessedRanges.keySet().stream().anyMatch(arg_0 -> ((TextRange)outerRange).intersects(arg_0))) {
            Collection states = this.myProcessedRanges.get((Object)outerRange);
            PhpVariableDfaState alreadyComputedState = (PhpVariableDfaState)((Object)ContainerUtil.getFirstItem((Collection)states));
            if (alreadyComputedState != null) {
                this.myProcessedRanges.putValue((Object)outerRange, new PhpVariableDfaStateWithInstruction<E>(alreadyComputedState.getVariableName(), this.getUnknown(), (PhpInstruction)instruction));
            }
            return true;
        }
        @NotNull PhpConditionDFAnalyzer<PhpVariableDfaState<E>> analyzer = this.createAnalyzer();
        @NotNull PhpVariableDfaState<E> state = analyzer.performDFA(condition, result);
        this.myProcessedRanges.putValue((Object)outerRange, new PhpVariableDfaStateWithInstruction<E>(state.getVariableName(), state.getState(), (PhpInstruction)instruction));
        if (!this.isUnknown(state) && this.sameVariableName(state.getVariableName())) {
            this.myLastDfaInstruction = instruction;
            return false;
        }
        return true;
    }

    @NotNull
    protected abstract E getUnknown();

    protected abstract boolean isUnknown(@NotNull PhpVariableDfaState<E> var1);

    @NotNull
    protected abstract PhpConditionDFAnalyzer<? extends PhpVariableDfaState<E>> createAnalyzer();

    protected boolean sameVariableName(CharSequence name) {
        return this.myVariableName == null || PhpLangUtil.equalsVariableNames(name, this.myVariableName);
    }

    public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
        PhpAccessInstruction.Access access;
        super.processAccessVariableInstruction(instruction);
        if (this.sameVariableName(instruction.getVariableName()) && ((access = instruction.getAccess()).isWriteRef() || access.isUnset() || access.isWrite())) {
            return false;
        }
        return super.processAccessVariableInstruction(instruction);
    }

    public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
        super.processArrayAccessInstruction(instruction);
        CharSequence name = PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction);
        PhpAccessInstruction.Access access = instruction.getAccess();
        if (this.sameVariableName(name) && (access.isWrite() || access.isWriteRef()) || this.sameVariableName(instruction.getVariableName()) && access.isUnset()) {
            return false;
        }
        return super.processArrayAccessInstruction(instruction);
    }

    protected void setState(PhpVariableDfaStateWithInstruction<E> value) {
        this.myProcessedRanges.putValue((Object)TextRange.EMPTY_RANGE, value);
    }

    public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
        super.processEntryPointInstruction(instruction);
        this.myAmbiguous = true;
        return super.processEntryPointInstruction(instruction);
    }

    @Nullable
    public PhpVariableDfaStateWithInstruction<E> getState() {
        if (this.myAmbiguous) {
            return null;
        }
        List states = this.myProcessedRanges.values().stream().filter(s -> s != this.getEmpty()).filter(s -> this.sameVariableName(s.getVariableName())).collect(Collectors.toList());
        if (ContainerUtil.exists(states, s -> this.isUnknown((PhpVariableDfaState<E>)((Object)s)))) {
            return new PhpVariableDfaStateWithInstruction<E>(this.myVariableName, this.getUnknown(), this.myLastDfaInstruction);
        }
        PhpVariableDfaState firstState = (PhpVariableDfaState)((Object)ContainerUtil.getFirstItem(states));
        if (firstState == null) {
            return null;
        }
        Object composedState = states.stream().map(PhpVariableDfaState::getState).reduce((delegates, delegates2) -> this.createAmbiguousState(delegates, delegates2)).orElse(null);
        if (composedState == null) {
            return null;
        }
        return new PhpVariableDfaStateWithInstruction<Object>(firstState.getVariableName(), composedState, this.myLastDfaInstruction);
    }

    protected abstract E createAmbiguousState(E var1, E var2);

    @NotNull
    protected abstract PhpVariableDfaState<E> getEmpty();

    public static class PhpVariableDfaState<E>
    extends Pair<CharSequence, E> {
        public PhpVariableDfaState(CharSequence variableName, E state) {
            super((Object)variableName, state);
        }

        public CharSequence getVariableName() {
            return (CharSequence)this.first;
        }

        public E getState() {
            return (E)this.second;
        }
    }

    public static class PhpVariableDfaStateWithInstruction<E>
    extends PhpVariableDfaState<E> {
        private final PhpInstruction myInstruction;

        public PhpVariableDfaStateWithInstruction(CharSequence variableName, E state, PhpInstruction instruction) {
            super(variableName, state);
            this.myInstruction = instruction;
        }

        public PhpInstruction getInstruction() {
            return this.myInstruction;
        }
    }
}

