/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.typeInference;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.codeInsight.typeInference.PhpAmbiguousCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpBitLogicalOpsVariableDfaState;
import com.jetbrains.php.codeInsight.typeInference.PhpCompositeTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedAnalyzerProcessor;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpDfaDelegateBasedTypeState;
import com.jetbrains.php.codeInsight.typeInference.PhpStrictVariableDfaState;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpEmpty;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Collection;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDfaBaseStateConditionDFAnalyzer
extends PhpConditionDFAnalyzer<PhpVariableDfaState> {
    private static final PhpDfaBasedTypeState ISSET = new PhpStrictVariableDfaState(PhpDfaBasedTypeState.NOT_NULL);
    private static final PhpDfaBasedTypeState NOT_ISSET = new PhpDfaBasedTypeState("NOT_ISSET"){

        @Override
        public boolean coveredBy(Project project, @NotNull PhpDfaBasedTypeState state, boolean global) {
            if (state == null) {
                1.$$$reportNull$$$0(0);
            }
            return state == this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer$1", "coveredBy"));
        }
    };
    private static final PhpDfaBasedTypeState ALWAYS_TRUE = new PhpDfaDelegateBasedTypeState("ALWAYS_TRUE", PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL);
    public static final PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker ALWAYS_BOOL = new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker("is_bool");
    public static final PhpAmbiguousCompositeTypeState PROBABLY_FALSE = new PhpAmbiguousCompositeTypeState(PhpDfaBasedTypeState.NULL, PhpDfaBasedTypeState.ALWAYS_FALSE);
    private final boolean myGlobal;

    public PhpDfaBaseStateConditionDFAnalyzer(boolean global) {
        this.myGlobal = global;
    }

    public static boolean isNotNullByPrimitiveTypeCheckers(@NotNull FunctionReference condition) {
        String name;
        if (condition == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        return StringUtil.equalsIgnoreCase((CharSequence)(name = condition.getName()), (CharSequence)"is_object") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_countable") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_iterable") || StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)"is_array") || PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(name) != null;
    }

    @Override
    @NotNull
    public PhpVariableDfaState performDFA(@Nullable PsiElement condition, boolean result) {
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType operationType = binaryExpression.getOperationType();
            if (operationType == PhpTokenTypes.opNOT_EQUAL || operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opEQUAL || operationType == PhpTokenTypes.opIDENTICAL) {
                PsiElement right = binaryExpression.getRightOperand();
                PsiElement left = binaryExpression.getLeftOperand();
                PhpVariableDfaState stateFromNullGuard = this.computeStateFromConditionalGuard(left, right, operationType, result);
                if (stateFromNullGuard != null) {
                    PhpVariableDfaState phpVariableDfaState = stateFromNullGuard;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return phpVariableDfaState;
                }
                PhpVariableDfaState flippedStateFromNullGuard = this.computeStateFromConditionalGuard(right, left, operationType, result);
                if (flippedStateFromNullGuard != null) {
                    PhpVariableDfaState phpVariableDfaState = flippedStateFromNullGuard;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(2);
                    }
                    return phpVariableDfaState;
                }
            } else if (operationType == PhpTokenTypes.kwINSTANCEOF && result) {
                PsiElement left = binaryExpression.getLeftOperand();
                if (left instanceof Variable && this.needToProcessElement(left)) {
                    ClassReference rightOperand = (ClassReference)ObjectUtils.tryCast((Object)binaryExpression.getRightOperand(), ClassReference.class);
                    String fqnToCheck = rightOperand != null ? rightOperand.getSignature().substring(2) : null;
                    return new PhpVariableDfaState((CharSequence)((Variable)left).getName(), new PhpDfaDelegateBasedTypeState.PhpInstanceofTypeState(fqnToCheck));
                }
            } else if (operationType == PhpTokenTypes.opBIT_AND || operationType == PhpTokenTypes.opBIT_OR) {
                PhpVariableDfaState state = (PhpVariableDfaState)((Object)super.performDFA(condition, result));
                return new PhpVariableDfaState(state.getVariableName(), new PhpBitLogicalOpsVariableDfaState((PhpDfaBasedTypeState)state.getState()));
            }
        } else {
            if (condition instanceof PhpIsset) {
                PhpVariableDfaState phpVariableDfaState = StreamEx.of((Object[])((PhpIsset)condition).getVariables()).map(e -> this.createIssetDFAState((PsiElement)e, result)).reduce((s, s1) -> this.and((PhpVariableDfaState)((Object)s), (PhpVariableDfaState)((Object)s1), result)).orElseGet(this::getEmpty);
                if (phpVariableDfaState == null) {
                    PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(3);
                }
                return phpVariableDfaState;
            }
            if (condition instanceof FunctionReference && StringUtil.equalsIgnoreCase((CharSequence)((FunctionReference)condition).getName(), (CharSequence)"is_null")) {
                PhpVariableDfaState state;
                PsiElement parameter = ((FunctionReference)condition).getParameter(0);
                if (parameter instanceof PhpTypedElement && (state = this.computeNullabilityState(parameter, !result)) != null) {
                    PhpVariableDfaState phpVariableDfaState = PhpDfaBaseStateConditionDFAnalyzer.updateStrict(state, true);
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(4);
                    }
                    return phpVariableDfaState;
                }
            } else if (result && condition instanceof FunctionReference && PhpLangUtil.equalsFunctionNames("is_object", ((FunctionReference)condition).getName())) {
                PsiElement parameter = ((FunctionReference)condition).getParameter(0);
                if (parameter != null && this.needToProcessElement(parameter)) {
                    return new PhpVariableDfaState((CharSequence)((Variable)parameter).getName(), PhpDfaDelegateBasedTypeState.NOT_PRIMITIVE);
                }
            } else if (result && condition instanceof FunctionReference && PhpDfaBaseStateConditionDFAnalyzer.isNotNullByPrimitiveTypeCheckers((FunctionReference)condition)) {
                PsiElement parameter = ((FunctionReference)condition).getParameter(0);
                if (parameter != null && this.needToProcessElement(parameter)) {
                    PhpDfaBasedTypeState nullabilityState = new PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker(Objects.requireNonNull(((FunctionReference)condition).getName()));
                    if (PhpLangUtil.equalsFunctionNames("is_array", ((FunctionReference)condition).getName())) {
                        nullabilityState = PhpDfaDelegateBasedTypeState.PhpNotNullByPrimitiveTypeChecker.IS_ARRAY_CHECK;
                    }
                    return new PhpVariableDfaState((CharSequence)((Variable)parameter).getName(), nullabilityState);
                }
            } else if (condition instanceof PhpEmpty) {
                PhpTypedElement elementToCheckType;
                PhpVariableDfaState state;
                if (!result && (state = this.computeNullabilityState((PsiElement)(elementToCheckType = (PhpTypedElement)StreamEx.of((Object[])((PhpEmpty)condition).getVariables()).select(PhpTypedElement.class).findFirst().orElse(null)), true)) != null) {
                    PhpVariableDfaState phpVariableDfaState = state;
                    if (phpVariableDfaState == null) {
                        PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(5);
                    }
                    return phpVariableDfaState;
                }
            } else if (condition instanceof Variable && this.needToProcessElement(condition)) {
                return new PhpVariableDfaState((CharSequence)((Variable)condition).getName(), result ? PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL : PROBABLY_FALSE);
            }
        }
        PhpVariableDfaState phpVariableDfaState = (PhpVariableDfaState)((Object)super.performDFA(condition, result));
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(6);
        }
        return phpVariableDfaState;
    }

    @Override
    @Nullable
    protected PhpVariableDfaState performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        if (PhpDfaBaseStateConditionDFAnalyzer.strictComparisonWithTrue(left, right, operationType, result)) {
            return null;
        }
        return (PhpVariableDfaState)((Object)super.performDFAFromBooleanComparison(left, right, operationType, result));
    }

    public static boolean strictComparisonWithTrue(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        return left instanceof Variable && (operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opIDENTICAL) && EQUALITY_TOKENS.contains(operationType) != result && PhpLangUtil.isTrue(right);
    }

    private PhpVariableDfaState createIssetDFAState(PsiElement elementToCheckType, boolean result) {
        if (elementToCheckType instanceof Variable && this.needToProcessElement(elementToCheckType)) {
            PhpDfaBasedTypeState nullabilityState = result ? ISSET : NOT_ISSET;
            return new PhpVariableDfaState((CharSequence)((Variable)elementToCheckType).getName(), nullabilityState);
        }
        return this.getEmpty();
    }

    private PhpVariableDfaState computeStateFromConditionalGuard(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        boolean strict;
        if (!this.needToProcessElement(left)) {
            return null;
        }
        boolean notEqualCheck = operationType == PhpTokenTypes.opNOT_EQUAL || operationType == PhpTokenTypes.opNOT_IDENTICAL;
        boolean negatedCheck = notEqualCheck == result;
        boolean bl = strict = operationType == PhpTokenTypes.opNOT_IDENTICAL || operationType == PhpTokenTypes.opIDENTICAL;
        if (PhpLangUtil.isNull(right)) {
            PhpDfaBasedTypeState nullabilityState = negatedCheck ? (strict ? PhpDfaBasedTypeState.NOT_NULL : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL) : PhpDfaBasedTypeState.NULL;
            return PhpDfaBaseStateConditionDFAnalyzer.updateStrict(new PhpVariableDfaState((CharSequence)((Variable)left).getName(), nullabilityState), strict);
        }
        String name = ((Variable)left).getName();
        if (negatedCheck && PhpLangUtil.isFalse(right)) {
            PhpDfaBasedTypeState state = strict ? PhpDfaBasedTypeState.NOT_FALSE : PhpDfaDelegateBasedTypeState.NOT_FALSE_NOT_NULL;
            return PhpDfaBaseStateConditionDFAnalyzer.updateStrict(new PhpVariableDfaState((CharSequence)name, state), strict);
        }
        if (!negatedCheck || this.myGlobal && notEqualCheck) {
            if (!negatedCheck && PhpLangUtil.isTrue(right)) {
                PhpDfaDelegateBasedTypeState state = new PhpDfaDelegateBasedTypeState(ALWAYS_TRUE.toString(), strict ? new PhpStrictVariableDfaState(ALWAYS_TRUE) : ALWAYS_TRUE, ALWAYS_BOOL);
                return new PhpVariableDfaState((CharSequence)name, state);
            }
            Pair<PhpType, PsiElement> scalar = this.getTypeFromIdentityCheckOnScalar(right);
            Collection<String> primitiveTypeCheckerTypeFromName = PhpTypeConditionDFAnalyzer.getPrimitiveTypeCheckerTypeFromName((PhpType)scalar.first);
            if (!primitiveTypeCheckerTypeFromName.isEmpty()) {
                PhpDfaBasedTypeState state = strict ? new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByStrictComparison(primitiveTypeCheckerTypeFromName, (PsiElement)scalar.second, negatedCheck) : new PhpDfaDelegateBasedTypeState.PhpPrimitiveTypeCheckByComparison((PsiElement)scalar.second, negatedCheck);
                return new PhpVariableDfaState((CharSequence)name, state);
            }
        }
        return null;
    }

    private Pair<PhpType, PsiElement> getTypeFromIdentityCheckOnScalar(PsiElement element) {
        if (element instanceof PhpExpression && (PhpPsiUtil.isOfType(element, PhpElementTypes.SCALARS) || PhpLangUtil.isTrue(element) || PhpLangUtil.isFalse(element) || this.myGlobal && PhpDfaBaseStateConditionDFAnalyzer.isStaticConstantReference(element))) {
            return Pair.create((Object)((PhpExpression)element).getGlobalType(), (Object)element);
        }
        return Pair.create((Object)PhpType.EMPTY, null);
    }

    protected static boolean isStaticConstantReference(PsiElement element) {
        return element instanceof ClassConstantReference && ((ClassConstantReference)element).getClassReference() instanceof ClassReference || element instanceof ConstantReference;
    }

    protected static boolean nonStrictNullValue(@Nullable PsiElement element) {
        if (element instanceof StringLiteralExpression) {
            return ((StringLiteralExpression)element).getContents().isEmpty();
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.NUMBER)) {
            String text = element.getText();
            return text.equals("0") || text.equals("0.0");
        }
        return PhpLangUtil.isFalse(element);
    }

    private static PhpVariableDfaState updateStrict(PhpVariableDfaState state, boolean strict) {
        return strict ? new PhpVariableDfaState(state.getVariableName(), new PhpStrictVariableDfaState((PhpDfaBasedTypeState)state.getState())) : state;
    }

    @Nullable
    private PhpVariableDfaState computeNullabilityState(PsiElement elementToCheck, boolean isNotNullCheck) {
        if (!this.needToProcessElement(elementToCheck)) {
            return null;
        }
        PhpDfaBasedTypeState nullabilityState = isNotNullCheck ? PhpDfaBasedTypeState.NOT_NULL : PhpDfaBasedTypeState.NULL;
        return new PhpVariableDfaState((CharSequence)((Variable)elementToCheck).getName(), nullabilityState);
    }

    protected boolean needToProcessElement(PsiElement elementToProcess) {
        return elementToProcess instanceof Variable;
    }

    private static PhpVariableDfaState merge(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean ambiguousResult) {
        PhpVariableDfaState merge;
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(7);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(8);
        }
        if (ambiguousResult) {
            rightOperand = PhpDfaBaseStateConditionDFAnalyzer.expandDfaStateType(rightOperand);
            leftOperand = PhpDfaBaseStateConditionDFAnalyzer.expandDfaStateType(leftOperand);
        }
        return (merge = PhpDfaBaseStateConditionDFAnalyzer.mergeInner(leftOperand, rightOperand, ambiguousResult)) != null && !StringUtil.isEmpty((CharSequence)merge.getVariableName()) ? merge : PhpVariableDfaState.EMPTY;
    }

    @NotNull
    private static PhpVariableDfaState expandDfaStateType(@NotNull PhpVariableDfaState state) {
        if (state == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(9);
        }
        if (PhpDfaBaseStateConditionDFAnalyzer.isForcingNullState(state)) {
            return new PhpVariableDfaState(state.getVariableName(), PhpExpandedNullDfaState.INSTANCE);
        }
        PhpVariableDfaState phpVariableDfaState = state;
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(10);
        }
        return phpVariableDfaState;
    }

    private static boolean isForcingNullState(@NotNull PhpVariableDfaState state) {
        if (state == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(11);
        }
        return ((PhpDfaBasedTypeState)state.getState()).applyType(PhpType.EMPTY).equals((Object)PhpType.NULL);
    }

    private static PhpVariableDfaState createState(PhpVariableDfaState merge, boolean ambiguousResult) {
        return ambiguousResult ? new PhpVariableDfaState(merge.getVariableName(), PhpDfaBasedTypeState.AMBIGUOUS) : merge;
    }

    private static PhpVariableDfaState mergeInner(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean ambiguousResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(12);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(13);
        }
        if (leftOperand.getState() == PhpDfaBasedTypeState.UNKNOWN) {
            return PhpDfaBaseStateConditionDFAnalyzer.createState(rightOperand, ambiguousResult);
        }
        if (rightOperand.getState() == PhpDfaBasedTypeState.UNKNOWN) {
            return PhpDfaBaseStateConditionDFAnalyzer.createState(leftOperand, ambiguousResult);
        }
        if (rightOperand.equals((Object)leftOperand)) {
            return rightOperand;
        }
        if (PhpLangUtil.equalsVariableNames(leftOperand.getVariableName(), rightOperand.getVariableName())) {
            PhpCompositeTypeState state = ambiguousResult ? new PhpAmbiguousCompositeTypeState((PhpDfaBasedTypeState)leftOperand.getState(), (PhpDfaBasedTypeState)rightOperand.getState()) : new PhpCompositeTypeState((PhpDfaBasedTypeState)leftOperand.getState(), (PhpDfaBasedTypeState)rightOperand.getState());
            return new PhpVariableDfaState(leftOperand.getVariableName(), state);
        }
        return null;
    }

    @Override
    @NotNull
    public PhpVariableDfaState and(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(14);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(15);
        }
        PhpVariableDfaState phpVariableDfaState = PhpDfaBaseStateConditionDFAnalyzer.merge(leftOperand, rightOperand, !conditionResult);
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(16);
        }
        return phpVariableDfaState;
    }

    @Override
    @NotNull
    public PhpVariableDfaState or(@NotNull PhpVariableDfaState leftOperand, @NotNull PhpVariableDfaState rightOperand, boolean conditionResult) {
        if (leftOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(17);
        }
        if (rightOperand == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(18);
        }
        PhpVariableDfaState phpVariableDfaState = PhpDfaBaseStateConditionDFAnalyzer.merge(leftOperand, rightOperand, conditionResult);
        if (phpVariableDfaState == null) {
            PhpDfaBaseStateConditionDFAnalyzer.$$$reportNull$$$0(19);
        }
        return phpVariableDfaState;
    }

    @Override
    protected PhpVariableDfaState getEmpty() {
        return PhpVariableDfaState.EMPTY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer";
                break;
            }
            case 7: 
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "leftOperand";
                break;
            }
            case 8: 
            case 13: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rightOperand";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/typeInference/PhpDfaBaseStateConditionDFAnalyzer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "expandDfaStateType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "or";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isNotNullByPrimitiveTypeCheckers";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "expandDfaStateType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isForcingNullState";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "mergeInner";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "or";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 16: 
            case 19: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class PhpExpandedNullDfaState
    extends PhpDfaBasedTypeState {
        private static final PhpDfaBasedTypeState INSTANCE = new PhpExpandedNullDfaState();

        private PhpExpandedNullDfaState() {
            super("EXPANDED NULL");
        }

        @Override
        public PhpType applyType(PhpType type) {
            return PhpType.or((PhpType)type, (PhpType)PhpType.NULL).filterMixed();
        }
    }

    public static class PhpVariableDfaState
    extends PhpDfaBasedAnalyzerProcessor.PhpVariableDfaState<PhpDfaBasedTypeState> {
        static final PhpVariableDfaState EMPTY = new PhpVariableDfaState((CharSequence)"", PhpDfaBasedTypeState.UNKNOWN);

        public PhpVariableDfaState(CharSequence variableName, PhpDfaBasedTypeState state) {
            super(variableName, state);
        }
    }
}

