/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersHandlerFactory;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpStringPartDescriptor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightFormatStringParametersUsagesHandler
extends HighlightUsagesHandlerBase<StringLiteralExpression> {
    private final int myFormatExpressionIndex;
    private final int mySelectedParameterIndex;
    private final PsiElement[] myParameters;

    PhpHighlightFormatStringParametersUsagesHandler(Editor editor, PsiFile file, int formatExpressionIndex, int selectedParameterIndex, PsiElement[] parameters) {
        super(editor, file);
        this.myFormatExpressionIndex = formatExpressionIndex;
        this.mySelectedParameterIndex = selectedParameterIndex;
        this.myParameters = parameters;
    }

    @NotNull
    public List<StringLiteralExpression> getTargets() {
        PsiElement parameter = this.myParameters[this.myFormatExpressionIndex];
        if (parameter instanceof StringLiteralExpression) {
            List<StringLiteralExpression> list = Collections.singletonList((StringLiteralExpression)parameter);
            if (list == null) {
                PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(0);
            }
            return list;
        }
        if (PhpConcatenationStringRepresentationConverter.isConcatenation(parameter)) {
            return PhpHighlightFormatStringParametersUsagesHandler.getLiteralExpressions((BinaryExpression)parameter);
        }
        List<StringLiteralExpression> list = Collections.emptyList();
        if (list == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    public static List<StringLiteralExpression> getLiteralExpressions(BinaryExpression parameter) {
        List parts = ContainerUtil.map(PhpConcatenationStringRepresentationConverter.INSTANCE.getStringParts(parameter, (Editor)null), PhpStringPartDescriptor::getElement);
        List expressions = (List)StreamEx.of((Collection)parts).select(StringLiteralExpression.class).collect(Collectors.toList());
        boolean allExpressionHaveSameQuotes = ((StreamEx)((StreamEx)StreamEx.of((Collection)expressions).distinct(StringLiteralExpression::isSingleQuote)).limit(2L)).count() <= 1L;
        List list = expressions.size() == parts.size() && allExpressionHaveSameQuotes ? expressions : Collections.emptyList();
        if (list == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(2);
        }
        return list;
    }

    protected void selectTargets(@NotNull List<? extends StringLiteralExpression> targets, @NotNull Consumer<? super List<? extends StringLiteralExpression>> selectionConsumer) {
        if (targets == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(3);
        }
        if (selectionConsumer == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(4);
        }
        selectionConsumer.consume(targets);
    }

    public void computeUsages(@NotNull List<? extends StringLiteralExpression> targets) {
        StringLiteralExpression formatExpression;
        if (targets == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(5);
        }
        if ((formatExpression = (StringLiteralExpression)ContainerUtil.getFirstItem(targets)) == null) {
            return;
        }
        String contents = PhpInterpolationStringRepresentationConverter.createExpressionContent(targets);
        MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specificationsWithIndices = PhpConversionSpecificationParser.parseConversionSpecifications(contents, formatExpression.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)formatExpression));
        MultiMap<Integer, RelativeRange> relativeSpecificationRanges = PhpHighlightFormatStringParametersUsagesHandler.getRelativeSpecificationRanges(specificationsWithIndices, targets);
        int specificationIndex = this.mySelectedParameterIndex == this.myFormatExpressionIndex ? this.resolveConversionIndexFromCaret(relativeSpecificationRanges) : this.mySelectedParameterIndex - this.myFormatExpressionIndex;
        this.addSpecificationsUsages(relativeSpecificationRanges, specificationIndex);
        if (relativeSpecificationRanges.get((Object)specificationIndex).isEmpty()) {
            return;
        }
        int parameterIndex = specificationIndex >= 0 ? this.myFormatExpressionIndex + specificationIndex : specificationIndex;
        PsiElement parameter = this.getParameter(parameterIndex);
        if (parameter == null) {
            return;
        }
        this.myReadUsages.add(PhpHighlightFormatStringParametersHandlerFactory.getArgumentRangeUnpackingAware(parameter));
        if (parameter == ArrayUtil.getLastElement((Object[])this.myParameters) && PhpPsiUtil.isArgumentUnpacking(parameter)) {
            relativeSpecificationRanges.keySet().stream().filter(index -> index != specificationIndex && index > this.myParameters.length - this.myFormatExpressionIndex - 2).forEach(index -> this.addSpecificationsUsages(relativeSpecificationRanges, (int)index));
        }
    }

    @Nullable
    private PsiElement getParameter(int parameterIndex) {
        if (parameterIndex >= 0 && parameterIndex < this.myParameters.length) {
            return this.myParameters[parameterIndex];
        }
        PsiElement lastParameter = (PsiElement)ArrayUtil.getLastElement((Object[])this.myParameters);
        return PhpPsiUtil.isArgumentUnpacking(lastParameter) ? lastParameter : null;
    }

    protected void addSpecificationsUsages(MultiMap<Integer, RelativeRange> relativeSpecificationRanges, int specificationIndex) {
        for (RelativeRange pair : relativeSpecificationRanges.get((Object)specificationIndex)) {
            this.myReadUsages.add(PhpHighlightFormatStringParametersUsagesHandler.getRangeInsideDocument(pair.getContainingExpression(), pair.getRangeInsideExpression()));
        }
    }

    @NotNull
    public static MultiMap<Integer, RelativeRange> getRelativeSpecificationRanges(MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications, List<? extends StringLiteralExpression> targets) {
        Map<TextRange, StringLiteralExpression> rangesInsideResultingFormatString = PhpHighlightFormatStringParametersUsagesHandler.getRangesWithExpressionInsideResultingFormatString(targets);
        MultiMap result = new MultiMap();
        for (Map.Entry entry : specifications.entrySet()) {
            for (PhpConversionSpecificationParser.ConversionSpecification specification : (Collection)entry.getValue()) {
                for (Map.Entry<TextRange, StringLiteralExpression> e : rangesInsideResultingFormatString.entrySet()) {
                    TextRange expressionRangeInsideFormatString = e.getKey();
                    TextRange specificationRangeInsideFormatString = expressionRangeInsideFormatString.intersection(specification.getRangeInElement());
                    if (specificationRangeInsideFormatString == null || specificationRangeInsideFormatString.isEmpty()) continue;
                    result.putValue((Object)((Integer)entry.getKey()), (Object)new RelativeRange(e.getValue(), specificationRangeInsideFormatString.shiftLeft(expressionRangeInsideFormatString.getStartOffset())));
                }
            }
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(6);
        }
        return multiMap;
    }

    @NotNull
    private static Map<TextRange, StringLiteralExpression> getRangesWithExpressionInsideResultingFormatString(List<? extends StringLiteralExpression> targets) {
        int lastOffset = 0;
        THashMap result = new THashMap();
        for (StringLiteralExpression stringLiteralExpression : targets) {
            int length = stringLiteralExpression.getContents().length();
            TextRange range = TextRange.create((int)lastOffset, (int)(lastOffset + length));
            result.put(range, stringLiteralExpression);
            lastOffset = range.getEndOffset();
        }
        THashMap tHashMap = result;
        if (tHashMap == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(7);
        }
        return tHashMap;
    }

    @NotNull
    private static TextRange getRangeInsideDocument(@NotNull StringLiteralExpression formatExpression, @NotNull TextRange rangeInsideExpression) {
        if (formatExpression == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(8);
        }
        if (rangeInsideExpression == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(9);
        }
        TextRange textRange = InjectedLanguageManager.getInstance((Project)formatExpression.getProject()).injectedToHost((PsiElement)formatExpression, rangeInsideExpression).shiftRight(formatExpression.getTextOffset()).shiftRight(formatExpression.getValueRange().getStartOffset());
        if (textRange == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(10);
        }
        return textRange;
    }

    private int resolveConversionIndexFromCaret(@NotNull MultiMap<Integer, RelativeRange> specificationRelativeRanges) {
        if (specificationRelativeRanges == null) {
            PhpHighlightFormatStringParametersUsagesHandler.$$$reportNull$$$0(11);
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        StringLiteralExpression selectedLiteralExpression = (StringLiteralExpression)PhpPsiUtil.getParentByCondition(this.myFile.findElementAt(caretOffset), false, (Condition<? super PsiElement>)StringLiteralExpression.INSTANCEOF);
        return StreamEx.of((Collection)specificationRelativeRanges.entrySet()).findFirst(e -> PhpHighlightFormatStringParametersUsagesHandler.specificationAtCaretOffsetExists(caretOffset, selectedLiteralExpression, (Collection)e.getValue())).map(Map.Entry::getKey).orElse(-1);
    }

    private static boolean specificationAtCaretOffsetExists(int caretOffset, StringLiteralExpression formatExpression, Collection<RelativeRange> specifications) {
        return specifications.stream().filter(e -> e.getContainingExpression() == formatExpression).map(e -> PhpHighlightFormatStringParametersUsagesHandler.getRangeInsideDocument(formatExpression, e.getRangeInsideExpression())).anyMatch(range -> range.containsOffset(caretOffset));
    }

    public boolean highlightReferences() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionConsumer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatExpression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeInsideExpression";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specificationRelativeRanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralExpressions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeSpecificationRanges";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesWithExpressionInsideResultingFormatString";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInsideDocument";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "selectTargets";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeUsages";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getRangeInsideDocument";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "resolveConversionIndexFromCaret";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class RelativeRange {
        @NotNull
        private final StringLiteralExpression containingExpression;
        @NotNull
        private final TextRange rangeInsideExpression;

        private RelativeRange(@NotNull StringLiteralExpression containingExpression, @NotNull TextRange rangeInsideExpression) {
            if (containingExpression == null) {
                RelativeRange.$$$reportNull$$$0(0);
            }
            if (rangeInsideExpression == null) {
                RelativeRange.$$$reportNull$$$0(1);
            }
            this.containingExpression = containingExpression;
            this.rangeInsideExpression = rangeInsideExpression;
        }

        @NotNull
        public StringLiteralExpression getContainingExpression() {
            StringLiteralExpression stringLiteralExpression = this.containingExpression;
            if (stringLiteralExpression == null) {
                RelativeRange.$$$reportNull$$$0(2);
            }
            return stringLiteralExpression;
        }

        @NotNull
        public TextRange getRangeInsideExpression() {
            TextRange textRange = this.rangeInsideExpression;
            if (textRange == null) {
                RelativeRange.$$$reportNull$$$0(3);
            }
            return textRange;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingExpression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeInsideExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler$RelativeRange";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersUsagesHandler$RelativeRange";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContainingExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRangeInsideExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

