/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.highlighting;

import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerBase;
import com.intellij.codeInsight.highlighting.HighlightUsagesHandlerFactoryBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersUsagesHandler;
import com.jetbrains.php.config.PhpCustomFormatFunction;
import com.jetbrains.php.config.PhpCustomFormatFunctionsProvider;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.Statement;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHighlightFormatStringParametersHandlerFactory
extends HighlightUsagesHandlerFactoryBase {
    @Nullable
    public HighlightUsagesHandlerBase createHighlightUsagesHandler(@NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement target) {
        ParameterList parameterList;
        if (editor == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(1);
        }
        if (target == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(2);
        }
        if ((parameterList = (ParameterList)PhpPsiUtil.getParentByCondition(target, true, (Condition<? super PsiElement>)ParameterList.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF)) != null) {
            int selectedIndex;
            Object[] parameters;
            PsiElement selectedParameter;
            FunctionReference functionCall = (FunctionReference)ObjectUtils.tryCast((Object)parameterList.getParent(), FunctionReference.class);
            int formatStringIndex = PhpHighlightFormatStringParametersHandlerFactory.getFormatStringIndex(target.getProject(), functionCall);
            if (formatStringIndex >= 0 && (selectedParameter = (PsiElement)StreamEx.of((Object[])(parameters = parameterList.getParameters())).findFirst(p -> PhpHighlightFormatStringParametersHandlerFactory.getArgumentRangeUnpackingAware(p).containsOffset(editor.getCaretModel().getOffset())).orElse(null)) != null && (selectedIndex = PhpCodeInsightUtil.getParameterIndex(selectedParameter)) >= formatStringIndex && selectedIndex < parameters.length) {
                return new PhpHighlightFormatStringParametersUsagesHandler(editor, file, formatStringIndex, selectedIndex, (PsiElement[])parameters);
            }
        }
        return null;
    }

    public static TextRange getArgumentRangeUnpackingAware(@NotNull PsiElement argument) {
        if (argument == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(3);
        }
        if (PhpPsiUtil.isArgumentUnpacking(argument)) {
            return TextRange.create((int)argument.getPrevSibling().getTextRange().getStartOffset(), (int)argument.getTextRange().getEndOffset());
        }
        return argument.getTextRange();
    }

    public static int getFormatStringIndex(@NotNull Project project, @Nullable FunctionReference functionReference) {
        String formatFunctionFqn;
        if (project == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(4);
        }
        Function function = functionReference != null ? (Function)ObjectUtils.tryCast((Object)functionReference.resolve(), Function.class) : null;
        String string = formatFunctionFqn = function != null ? function.getFQN() : null;
        if (formatFunctionFqn == null) {
            return -1;
        }
        return PhpHighlightFormatStringParametersHandlerFactory.getCustomFormatFunctions(project).findFirst(e -> StringUtil.equals((CharSequence)e.getFunctionFqn(), (CharSequence)formatFunctionFqn)).map(PhpCustomFormatFunction::getFormatParameterIndex).orElse(-1);
    }

    @NotNull
    private static StreamEx<PhpCustomFormatFunction> getCustomFormatFunctions(@NotNull Project project) {
        if (project == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(5);
        }
        StreamEx streamEx = StreamEx.of((Object[])((PhpCustomFormatFunctionsProvider[])PhpCustomFormatFunctionsProvider.EP_NAME.getExtensions())).flatMap(e -> e.getCustomFormatFunctions(project).stream());
        if (streamEx == null) {
            PhpHighlightFormatStringParametersHandlerFactory.$$$reportNull$$$0(6);
        }
        return streamEx;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argument";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersHandlerFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/highlighting/PhpHighlightFormatStringParametersHandlerFactory";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomFormatFunctions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightUsagesHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentRangeUnpackingAware";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getFormatStringIndex";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getCustomFormatFunctions";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

