/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.dataFlow.type;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.codeInsight.dataFlow.PhpConditionDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpTypeConditionDFAnalyzer<E>
extends PhpConditionDFAnalyzer<E> {
    private static final Map<String, PhpTypeContract> myPrimitiveTypeCheckerFunctions = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
    private static final PhpTypeContract FIRST_PARAMETER_STRING_CONTRACT = new PhpTypeContract(PhpType.STRING, 0, false);
    private static final PhpTypeContract SECOND_PARAMETER_STRING_CONTRACT = new PhpTypeContract(PhpType.STRING, 1, false);
    public static final PhpTypeContract NUMERIC_TYPE_CONTRACT = new PhpTypeContract(PhpType.NUMERIC);
    protected boolean myCompleteTypeComputed;

    public boolean completeTypeComputed() {
        return this.myCompleteTypeComputed;
    }

    @NotNull
    protected static PhpType add(PhpType type, @Nullable PsiElement other, boolean filterPrimitives) {
        if (other instanceof PhpTypedElement) {
            PhpType otherType = ((PhpTypedElement)other).getType();
            type.add(filterPrimitives ? otherType.filterPrimitives() : otherType);
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        return phpType;
    }

    @Override
    @NotNull
    public E performDFA(@Nullable PsiElement condition, boolean result) {
        if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType type = binaryExpression.getOperationType();
            if (type == PhpTokenTypes.kwINSTANCEOF) {
                E eval = this.inferTypeFromIdentityCheck(binaryExpression, result);
                if (eval != null) {
                    E e = eval;
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(1);
                    }
                    return e;
                }
            } else {
                if (PhpTokenTypes.tsAND_OPS.contains(type)) {
                    E left = this.performDFA(binaryExpression.getLeftOperand(), result);
                    E right = this.performDFA(binaryExpression.getRightOperand(), result);
                    E e = this.and(left, right, result);
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(2);
                    }
                    return e;
                }
                if (PhpTokenTypes.tsOR_OPS.contains(type)) {
                    E left = this.performDFA(binaryExpression.getLeftOperand(), result);
                    E right = this.performDFA(binaryExpression.getRightOperand(), result);
                    E e = this.or(left, right, result);
                    if (e == null) {
                        PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(3);
                    }
                    return e;
                }
                if (type == PhpTokenTypes.opNOT_EQUAL || type == PhpTokenTypes.opNOT_IDENTICAL || type == PhpTokenTypes.opEQUAL || type == PhpTokenTypes.opIDENTICAL) {
                    PsiElement right = binaryExpression.getRightOperand();
                    PsiElement left = binaryExpression.getLeftOperand();
                    E eval = this.evalIdentityCheck(result, type, left, right);
                    if (eval != null) {
                        E e = eval;
                        if (e == null) {
                            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(4);
                        }
                        return e;
                    }
                    E evalFlipped = this.evalIdentityCheck(result, type, right, left);
                    if (evalFlipped != null) {
                        E e = evalFlipped;
                        if (e == null) {
                            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(5);
                        }
                        return e;
                    }
                }
            }
        } else if (!(condition instanceof MethodReference) && condition instanceof FunctionReference) {
            E eval;
            PsiElement parameter;
            PhpTypeContract typeContract;
            FunctionReference functionReference = (FunctionReference)condition;
            if (result && (typeContract = this.getTypeFromTypeCheckerFunction(functionReference)) != null && (parameter = functionReference.getParameter(typeContract.myParameterIndex)) != null && (eval = this.tryEvaluate(parameter, typeContract.myType)) != null) {
                this.myCompleteTypeComputed = typeContract.myTotalTypeComputed;
                E e = eval;
                if (e == null) {
                    PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(6);
                }
                return e;
            }
        }
        Object e = super.performDFA(condition, result);
        if (e == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(7);
        }
        return e;
    }

    @Nullable
    private E evalIdentityCheck(boolean result, IElementType type, PsiElement left, PsiElement right) {
        E evalFromIdentityCheck;
        boolean isIdenticalCheck;
        E evalFromGetClass;
        if ((type == PhpTokenTypes.opIDENTICAL || type == PhpTokenTypes.opEQUAL) == result && (evalFromGetClass = this.getEvalFromGetClass(left, right)) != null) {
            return evalFromGetClass;
        }
        boolean bl = isIdenticalCheck = type == PhpTokenTypes.opIDENTICAL;
        if ((isIdenticalCheck || type == PhpTokenTypes.opNOT_IDENTICAL) && (evalFromIdentityCheck = this.inferTypeFromIdentityCheck(left, right, isIdenticalCheck == result, false)) != null) {
            return evalFromIdentityCheck;
        }
        return null;
    }

    @Nullable
    private E getEvalFromGetClass(PsiElement left, PsiElement right) {
        E evalFromGetClass;
        String className;
        if (left instanceof FunctionReference && PhpLangUtil.equalsFunctionNames(((FunctionReference)left).getName(), "get_class") && (className = PhpTypeConditionDFAnalyzer.inferClassName(right)) != null && (evalFromGetClass = this.tryEvaluate(((FunctionReference)left).getParameter(0), new PhpType().add(className))) != null) {
            return evalFromGetClass;
        }
        return null;
    }

    @Nullable
    private E inferTypeFromIdentityCheck(BinaryExpression binaryExpression, boolean result) {
        return this.inferTypeFromIdentityCheck(binaryExpression.getLeftOperand(), binaryExpression.getRightOperand(), result, true);
    }

    @Nullable
    private E inferTypeFromIdentityCheck(PsiElement left, PsiElement right, boolean result, boolean filterPrimitives) {
        if (result && right instanceof PhpTypedElement) {
            if (PhpLangUtil.isNull(right)) {
                return null;
            }
            E eval = this.tryEvaluate(left, right, filterPrimitives);
            if (eval != null) {
                return eval;
            }
        }
        return null;
    }

    protected void updateComputedTypeIfPrimitive(PhpType phpType) {
        if (phpType.filterNull().isNotExtendablePrimitiveType()) {
            this.myCompleteTypeComputed = true;
        }
    }

    @Nullable
    private PhpTypeContract getTypeFromTypeCheckerFunction(@NotNull FunctionReference functionReference) {
        PsiElement arrParameter;
        String className;
        String name;
        if (functionReference == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(8);
        }
        if (StringUtil.isEmpty((String)(name = functionReference.getName()))) {
            return null;
        }
        if ((name.equalsIgnoreCase("is_subclass_of") || name.equalsIgnoreCase("is_a")) && (className = PhpTypeConditionDFAnalyzer.inferClassName(functionReference.getParameter(1))) != null) {
            return new PhpTypeContract(new PhpType().add(className));
        }
        if (PhpTypeConditionDFAnalyzer.isStrictInArrayCall(functionReference) && (arrParameter = functionReference.getParameter(1)) instanceof PhpTypedElement) {
            return new PhpTypeContract(((PhpTypedElement)arrParameter).getType().elementType());
        }
        PhpTypeContract typeFromCheckersByContract = PhpTypeConditionDFAnalyzer.getTypeFromContractBasedTypeCheckers(functionReference);
        if (typeFromCheckersByContract != null) {
            return typeFromCheckersByContract;
        }
        return this.getTypeFromPrimitiveTypeCheckers(name);
    }

    @Nullable
    protected PhpTypeContract getTypeFromPrimitiveTypeCheckers(String name) {
        return PhpTypeConditionDFAnalyzer.getTypeFromPrimitiveTypeChecker(name);
    }

    @Nullable
    public static PhpTypeContract getTypeFromPrimitiveTypeChecker(String name) {
        PhpTypeContract contract = myPrimitiveTypeCheckerFunctions.get(name);
        if (PhpLangUtil.equalsFunctionNames(name, "is_numeric")) {
            return new PhpTypeContract(PhpType.or((PhpType)contract.myType, (PhpType)PhpType.STRING));
        }
        return contract;
    }

    @NotNull
    public static Collection<String> getPrimitiveTypeCheckerTypeFromName(@NotNull PhpType phpType) {
        if (phpType == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(9);
        }
        Collection collection = myPrimitiveTypeCheckerFunctions.entrySet().stream().filter(e -> PhpType.intersects((PhpType)((PhpTypeContract)e.getValue()).myType, (PhpType)phpType) || ((PhpTypeContract)e.getValue()).myType.isBoolean() && phpType.isBoolean()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (collection == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static PhpTypeContract getTypeFromContractBasedTypeCheckers(FunctionReference reference) {
        String name = reference.getName();
        if (PhpLangUtil.equalsFunctionNames(name, "function_exists") || PhpLangUtil.equalsFunctionNames(name, "class_exists") || PhpLangUtil.equalsFunctionNames(name, "interface_exists") || PhpLangUtil.equalsFunctionNames(name, "defined")) {
            return FIRST_PARAMETER_STRING_CONTRACT;
        }
        if (PhpLangUtil.equalsFunctionNames(name, "method_exists") || PhpLangUtil.equalsFunctionNames(name, "property_exists")) {
            return SECOND_PARAMETER_STRING_CONTRACT;
        }
        return null;
    }

    private static boolean isStrictInArrayCall(@NotNull FunctionReference functionReference) {
        if (functionReference == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(11);
        }
        if (StringUtil.equals((CharSequence)functionReference.getName(), (CharSequence)"in_array")) {
            return PhpLangUtil.isTrue(functionReference.getParameter(2));
        }
        return false;
    }

    @Nullable
    public static String inferClassName(PsiElement parameter) {
        String referenceName;
        PhpExpression classReference;
        if (parameter instanceof StringLiteralExpression) {
            return PhpTypeConditionDFAnalyzer.getClassFqnFromContent((StringLiteralExpression)parameter);
        }
        if (parameter instanceof ClassConstantReference && (classReference = ((ClassConstantReference)parameter).getClassReference()) instanceof ClassReference && (referenceName = ((ClassConstantReference)parameter).getName()) != null && referenceName.equals("class")) {
            return ((ClassReference)classReference).getFQN();
        }
        return null;
    }

    @NotNull
    public static String getClassFqnFromContent(@NotNull StringLiteralExpression string) {
        if (string == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(12);
        }
        String contentForFQN = string.isSingleQuote() ? StringUtil.unescapeBackSlashes((String)string.getContents()) : string.getContents();
        String string2 = PhpLangUtil.toFQN(contentForFQN);
        if (string2 == null) {
            PhpTypeConditionDFAnalyzer.$$$reportNull$$$0(13);
        }
        return string2;
    }

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PsiElement var2, boolean var3);

    @Nullable
    public abstract E tryEvaluate(@Nullable PsiElement var1, @NotNull PhpType var2);

    static {
        myPrimitiveTypeCheckerFunctions.put("is_bool", new PhpTypeContract(PhpType.BOOLEAN));
        myPrimitiveTypeCheckerFunctions.put("is_callable", new PhpTypeContract(PhpType.CALLABLE));
        myPrimitiveTypeCheckerFunctions.put("is_double", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_float", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_int", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_integer", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_long", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_numeric", new PhpTypeContract(PhpType.INT));
        myPrimitiveTypeCheckerFunctions.put("is_real", new PhpTypeContract(PhpType.FLOAT));
        myPrimitiveTypeCheckerFunctions.put("is_resource", new PhpTypeContract(PhpType.RESOURCE));
        myPrimitiveTypeCheckerFunctions.put("is_scalar", new PhpTypeContract(PhpType.SCALAR));
        myPrimitiveTypeCheckerFunctions.put("is_string", new PhpTypeContract(PhpType.STRING));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "add";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveTypeCheckerTypeFromName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassFqnFromContent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTypeFromTypeCheckerFunction";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveTypeCheckerTypeFromName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isStrictInArrayCall";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getClassFqnFromContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class PhpTypeContract {
        @NotNull
        private final PhpType myType;
        private final int myParameterIndex;
        private final boolean myTotalTypeComputed;

        private PhpTypeContract(@NotNull PhpType type, int index, boolean totalTypeComputed) {
            if (type == null) {
                PhpTypeContract.$$$reportNull$$$0(0);
            }
            this.myType = type;
            this.myParameterIndex = index;
            this.myTotalTypeComputed = totalTypeComputed;
        }

        PhpTypeContract(@NotNull PhpType type) {
            if (type == null) {
                PhpTypeContract.$$$reportNull$$$0(1);
            }
            this(type, 0, type.filterNull().isNotExtendablePrimitiveType());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/jetbrains/php/codeInsight/dataFlow/type/PhpTypeConditionDFAnalyzer$PhpTypeContract", "<init>"));
        }
    }
}

