/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.dataFlow;

import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpConditionInstruction;
import com.jetbrains.php.codeInsight.dataFlow.PhpDFAnalyzer;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.TernaryExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpConditionDFAnalyzer<E>
extends PhpDFAnalyzer<E> {
    protected static final TokenSet EQUALITY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opEQUAL, PhpTokenTypes.opIDENTICAL});
    private final TokenSet NOT_EQUALITY_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opNOT_EQUAL, PhpTokenTypes.opNOT_IDENTICAL});
    private final TokenSet COMPARISON_EQUALITY_OPS = TokenSet.orSet((TokenSet[])new TokenSet[]{EQUALITY_TOKENS, this.NOT_EQUALITY_TOKENS});

    @Override
    @NotNull
    public E performDFA(@NotNull PhpConditionInstruction instruction) {
        if (instruction == null) {
            PhpConditionDFAnalyzer.$$$reportNull$$$0(0);
        }
        E e = this.performDFA(instruction.getCondition(), instruction.getResult());
        if (e == null) {
            PhpConditionDFAnalyzer.$$$reportNull$$$0(1);
        }
        return e;
    }

    @NotNull
    public E performDFA(@Nullable PsiElement condition, boolean result) {
        if (condition == null) {
            E e = this.getEmpty();
            if (e == null) {
                PhpConditionDFAnalyzer.$$$reportNull$$$0(2);
            }
            return e;
        }
        if (condition instanceof UnaryExpression) {
            IElementType operationType;
            UnaryExpression unaryExpression = (UnaryExpression)condition;
            PsiElement operation = unaryExpression.getOperation();
            if (operation != null && (operationType = operation.getNode().getElementType()) == PhpTokenTypes.opNOT) {
                E e = this.performDFA((PsiElement)unaryExpression.getValue(), !result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(3);
                }
                return e;
            }
        } else if (condition instanceof BinaryExpression) {
            BinaryExpression binaryExpression = (BinaryExpression)condition;
            IElementType operationType = binaryExpression.getOperationType();
            if (PhpTokenTypes.tsAND_OPS.contains(operationType)) {
                E leftOperand = this.performDFA(binaryExpression.getLeftOperand(), result);
                E rightOperand = this.performDFA(binaryExpression.getRightOperand(), result);
                E e = this.and(leftOperand, rightOperand, result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(4);
                }
                return e;
            }
            if (PhpTokenTypes.tsOR_OPS.contains(operationType)) {
                E leftOperand = this.performDFA(binaryExpression.getLeftOperand(), result);
                E rightOperand = this.performDFA(binaryExpression.getRightOperand(), result);
                E e = this.or(leftOperand, rightOperand, result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(5);
                }
                return e;
            }
            if (this.COMPARISON_EQUALITY_OPS.contains(operationType)) {
                PsiElement right;
                PsiElement left = binaryExpression.getLeftOperand();
                E dfaFromBooleanComparison = this.performDFAFromBooleanComparison(left, right = binaryExpression.getRightOperand(), operationType, result);
                if (dfaFromBooleanComparison != null) {
                    E e = dfaFromBooleanComparison;
                    if (e == null) {
                        PhpConditionDFAnalyzer.$$$reportNull$$$0(6);
                    }
                    return e;
                }
                E flippedDfaFromBooleanComparison = this.performDFAFromBooleanComparison(right, left, operationType, result);
                if (flippedDfaFromBooleanComparison != null) {
                    E e = flippedDfaFromBooleanComparison;
                    if (e == null) {
                        PhpConditionDFAnalyzer.$$$reportNull$$$0(7);
                    }
                    return e;
                }
            }
        } else {
            if (condition instanceof ParenthesizedExpression) {
                E e = this.performDFA((PsiElement)((ParenthesizedExpression)condition).extract(), result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(8);
                }
                return e;
            }
            if (condition instanceof TernaryExpression) {
                E trueVariant = this.performDFA((PsiElement)((TernaryExpression)condition).getTrueVariant(), result);
                E falseVariant = this.performDFA((PsiElement)((TernaryExpression)condition).getFalseVariant(), result);
                E e = this.or(trueVariant, falseVariant, result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(9);
                }
                return e;
            }
            if (condition instanceof AssignmentExpression) {
                E e = this.performDFA((PsiElement)((AssignmentExpression)condition).getValue(), result);
                if (e == null) {
                    PhpConditionDFAnalyzer.$$$reportNull$$$0(10);
                }
                return e;
            }
        }
        E e = this.getEmpty();
        if (e == null) {
            PhpConditionDFAnalyzer.$$$reportNull$$$0(11);
        }
        return e;
    }

    @Nullable
    protected E performDFAFromBooleanComparison(PsiElement left, PsiElement right, IElementType operationType, boolean result) {
        if (PhpLangUtil.isTrue(right)) {
            return this.performDFA(left, EQUALITY_TOKENS.contains(operationType) == result);
        }
        if (PhpLangUtil.isFalse(right)) {
            return this.performDFA(left, EQUALITY_TOKENS.contains(operationType) != result);
        }
        return null;
    }

    @NotNull
    public abstract E and(@NotNull E var1, @NotNull E var2, boolean var3);

    @NotNull
    public abstract E or(@NotNull E var1, @NotNull E var2, boolean var3);

    protected abstract E getEmpty();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/dataFlow/PhpConditionDFAnalyzer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/dataFlow/PhpConditionDFAnalyzer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "performDFA";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "performDFA";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

