/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpNoReturnProvider;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpExitPointFunctionData;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpExitPointFunctionIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgument;
import com.jetbrains.php.lang.psi.stubs.indexes.expectedArguments.PhpExpectedFunctionArgumentsIndex;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpExitPointNoReturnProvider
implements PhpNoReturnProvider {
    public boolean isCustomNoReturn(@NotNull FunctionReference functionCall) {
        if (functionCall == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(0);
        }
        return PhpExitPointNoReturnProvider.isCustomExitPoint(functionCall);
    }

    public static boolean isCustomExitPoint(FunctionReference reference) {
        String name = reference.getName();
        if (name == null) {
            return false;
        }
        ArrayList exitPoints = new ArrayList();
        FileBasedIndex.getInstance().processValues(PhpExitPointFunctionIndex.KEY, (Object)name, null, (file, value) -> {
            exitPoints.addAll(value);
            return true;
        }, GlobalSearchScope.allScope((Project)reference.getProject()));
        if (exitPoints.isEmpty()) {
            return false;
        }
        Function function = PhpExitPointNoReturnProvider.getFunction((PhpReference)reference);
        if (function == null) {
            return false;
        }
        TIntObjectHashMap<PsiElement> actualParameters = PhpExitPointNoReturnProvider.getArgumentsWithResolvedIndices(reference);
        return exitPoints.stream().filter(exitPoint -> PhpExitPointNoReturnProvider.expectedParametersAreMatchingActual(exitPoint, actualParameters)).anyMatch(exitPoint -> PhpExitPointNoReturnProvider.matches(function, exitPoint));
    }

    @NotNull
    private static TIntObjectHashMap<PsiElement> getArgumentsWithResolvedIndices(FunctionReference reference) {
        PsiElement[] arguments = reference.getParameters();
        TIntObjectHashMap res = new TIntObjectHashMap(arguments.length);
        for (PsiElement parameter : arguments) {
            res.put(PhpWorkaroundUtil.resolveMappedParameterIndex(parameter), (Object)parameter);
        }
        TIntObjectHashMap tIntObjectHashMap = res;
        if (tIntObjectHashMap == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(1);
        }
        return tIntObjectHashMap;
    }

    public static boolean matches(@NotNull Function function, @NotNull PhpExitPointFunctionData exitPoint) {
        if (function == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(2);
        }
        if (exitPoint == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(3);
        }
        return PhpExitPointNoReturnProvider.matchesFunction(function, exitPoint) || function instanceof Method && PhpExitPointNoReturnProvider.matchingSuperMemberExists((Method)function, exitPoint);
    }

    private static boolean matchingSuperMemberExists(@NotNull Method function, @NotNull PhpExitPointFunctionData exitPoint) {
        if (function == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(4);
        }
        if (exitPoint == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(5);
        }
        Ref res = new Ref((Object)Boolean.FALSE);
        PhpClassHierarchyUtils.processSuperMethods((Method)function, (classMember, subClass, baseClass) -> {
            if (PhpExitPointNoReturnProvider.matchesFunction((Function)classMember, exitPoint)) {
                res.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        });
        return res.get() == Boolean.TRUE;
    }

    public static boolean matchesFunction(@NotNull Function function, @NotNull PhpExitPointFunctionData exitPoint) {
        if (function == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(6);
        }
        if (exitPoint == null) {
            PhpExitPointNoReturnProvider.$$$reportNull$$$0(7);
        }
        String namespaceFQN = PhpLangUtil.getParentNamespaceFQN(function.getFQN());
        String name = function.getName();
        String className = PhpExitPointNoReturnProvider.getContainingClassName((Method)ObjectUtils.tryCast((Object)function, Method.class));
        return StringUtil.equalsIgnoreCase((CharSequence)className, (CharSequence)exitPoint.getClassName()) && StringUtil.equalsIgnoreCase((CharSequence)name, (CharSequence)exitPoint.getFunctionName()) && StringUtil.equalsIgnoreCase((CharSequence)namespaceFQN, (CharSequence)exitPoint.getNamespaceFQN());
    }

    private static String getContainingClassName(@Nullable Method method) {
        if (method == null) {
            return null;
        }
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        return containingClass.getName();
    }

    private static boolean expectedParametersAreMatchingActual(PhpExitPointFunctionData point, TIntObjectHashMap<PsiElement> actualArguments) {
        Map map = StreamEx.of(point.getExpectedFunctionArguments()).groupingBy(PhpExpectedFunctionArgument::getArgumentIndex);
        for (Map.Entry argumentEntry : map.entrySet()) {
            int index = (Integer)argumentEntry.getKey();
            PsiElement argument = (PsiElement)actualArguments.get(index);
            if (argument == null) {
                return false;
            }
            Collection<PsiElement> actualArgumentsUnwrapped = PhpExpectedFunctionArgumentsIndex.unwrapOperands(argument);
            if (ContainerUtil.exists((Iterable)((Iterable)argumentEntry.getValue()), expectedArgument -> ContainerUtil.exists((Iterable)actualArgumentsUnwrapped, actualArgument -> PhpExitPointNoReturnProvider.matching(expectedArgument, actualArgument)))) continue;
            return false;
        }
        return true;
    }

    private static boolean matching(PhpExpectedFunctionArgument expectedArgument, PsiElement argument) {
        boolean bitExpression = PhpPsiUtil.isOfType(argument.getParent(), PhpElementTypes.BIT_EXPRESSION);
        return (!bitExpression || expectedArgument.isFlag()) && expectedArgument.matches(argument);
    }

    @Nullable
    private static Function getFunction(PhpReference reference) {
        return StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionCall";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpExitPointNoReturnProvider";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitPoint";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpExitPointNoReturnProvider";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsWithResolvedIndices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCustomNoReturn";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "matchingSuperMemberExists";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchesFunction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

