/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.codeInsight.controlFlow;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowBuilder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowException;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpArrayAccessInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpClassDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpFunctionDeclarationInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpHostInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpAccessVariableInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpInstructionImpl;
import com.jetbrains.php.codeInsight.controlFlow.instructions.impl.PhpLoopHostInstructionImpl;
import com.jetbrains.php.codeInsight.typeInference.PhpInstructionExplicitStopListener;
import com.jetbrains.php.codeInsight.typeInference.PhpVariableInferredTypeAnalyzerProcessor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpControlFlowUtil {
    private static final Logger LOG = Logger.getInstance(PhpControlFlowUtil.class);
    private static final AppendPredecessorsStrategy ALL_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber) -> {
        List predecessors = (List)instruction.getPredecessors();
        PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = (instruction, pool, initialNumber) -> {
        List predecessors = (List)instruction.getPredecessors();
        int num = instruction.num();
        PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
        int size = predecessors.size();
        for (int i = 0; i < size; ++i) {
            PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
            if (num <= predecessor.num() || PhpControlFlowUtil.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
            pool.add(predecessor);
        }
    };
    private static final AppendPredecessorsStrategy IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY = new MyIgnoreInitialBackEdgesAppendPredecessorsStrategy();
    private static final AppendPredecessorsStrategy IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY_WITHOUT_CHECKS = new MyIgnoreInitialBackEdgesAppendPredecessorsStrategy(){

        @Override
        protected boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skippedLoopInstruction, PhpInstruction predecessor) {
            return false;
        }
    };

    private PhpControlFlowUtil() {
    }

    public static boolean alwaysNonEmptyArray(PhpInstruction instruction, final String arrayName) {
        final Ref alwaysNonEmpty = new Ref((Object)Boolean.FALSE);
        final Ref ambiguity = new Ref((Object)Boolean.FALSE);
        PhpControlFlowUtil.processPredecessors(instruction, false, IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY_WITHOUT_CHECKS, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(instruction.getVariableName(), arrayName)) {
                    return true;
                }
                PhpAccessInstruction.Access access = instruction.getAccess();
                if (access instanceof PhpAccessInstruction.ReadOrReadRefAccess) {
                    ambiguity.set((Object)Boolean.TRUE);
                } else if (access.isWrite()) {
                    if (PhpControlFlowUtil.nonEmptyElement(((PhpAccessVariableInstructionImpl)instruction).getAssignedValue())) {
                        alwaysNonEmpty.set((Object)Boolean.TRUE);
                    } else {
                        ambiguity.set((Object)Boolean.TRUE);
                    }
                    return false;
                }
                return true;
            }

            public boolean processArrayAccessInstruction(PhpArrayAccessInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(PhpVariableInferredTypeAnalyzerProcessor.getBaseVariableName(instruction), arrayName) && instruction.getAccess().isWrite()) {
                    alwaysNonEmpty.set((Object)Boolean.TRUE);
                    return false;
                }
                return true;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                ambiguity.set((Object)Boolean.TRUE);
                return true;
            }
        });
        return (Boolean)ambiguity.get() == false && (Boolean)alwaysNonEmpty.get() != false;
    }

    private static boolean nonEmptyElement(@Nullable PsiElement value) {
        if (value instanceof BinaryExpression && ((BinaryExpression)value).getOperationType() == PhpTokenTypes.opPLUS) {
            return PhpControlFlowUtil.nonEmptyElement(((BinaryExpression)value).getLeftOperand()) || PhpControlFlowUtil.nonEmptyElement(((BinaryExpression)value).getRightOperand());
        }
        return value instanceof ArrayCreationExpression && ArrayCreationExpressionImpl.children((ArrayCreationExpression)value).limit(1).size() >= 1;
    }

    public static boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor, PhpInstruction predecessor) {
        return skipLoopPredecessor != null && predecessor == skipLoopPredecessor.getOriginalPredecessor() && PhpControlFlowUtil.alwaysNonEmptyArray(predecessor, skipLoopPredecessor.getArrayName());
    }

    public static void processSuccessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(1);
        }
        PhpControlFlowUtil.processSuccessors(instruction, visitSelf, processor, new BitSet());
    }

    public static void processSuccessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(3);
        }
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>();
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            instruction.appendSuccessors(processorPool);
        }
        int c = 0;
        while (processorPool.size() > 0) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visited.get(curInstruction.num())) {
                visited.set(curInstruction.num());
                if (curInstruction.process(processor)) {
                    curInstruction.appendSuccessors(processorPool);
                }
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 200000) continue;
            throw new PhpControlFlowException("Control flow (Successors) is too big. Initial instruction=" + instruction + " Last instruction=" + curInstruction);
        }
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(5);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, ALL_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    @ApiStatus.Internal
    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(7);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, ALL_APPEND_PREDECESSOR_STRATEGY, processor, visited);
    }

    public static void processPredecessorsIgnoreBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(8);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(9);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    public static void processPredecessorsIgnoreInitialBackEdges(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(10);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(11);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, IGNORE_INITIAL_BACK_EDGES_APPEND_PREDECESSOR_STRATEGY, processor);
    }

    @ApiStatus.Internal
    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, @NotNull PhpInstructionProcessor processor) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(13);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(14);
        }
        PhpControlFlowUtil.processPredecessors(instruction, visitSelf, appendPredecessorsStrategy, processor, new BitSet(instruction.num()));
    }

    public static void processPredecessors(@NotNull PhpInstruction instruction, boolean visitSelf, @NotNull AppendPredecessorsStrategy appendPredecessorsStrategy, @NotNull PhpInstructionProcessor processor, BitSet visited) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(15);
        }
        if (appendPredecessorsStrategy == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(17);
        }
        int initialNumber = instruction.num();
        ArrayDeque<PhpInstruction> processorPool = new ArrayDeque<PhpInstruction>(50);
        if (visitSelf) {
            processorPool.add(instruction);
        } else {
            appendPredecessorsStrategy.appendPredecessors(instruction, processorPool, initialNumber);
        }
        int c = 0;
        while (processorPool.size() > 0) {
            PhpInstruction curInstruction = (PhpInstruction)processorPool.getFirst();
            if (!visited.get(curInstruction.num())) {
                visited.set(curInstruction.num());
                boolean result = curInstruction.process(processor);
                if (result && !((PhpInstructionImpl)curInstruction).isTerminatesAfterFinally()) {
                    appendPredecessorsStrategy.appendPredecessors(curInstruction, processorPool, initialNumber);
                } else if (!result && processor instanceof PhpInstructionExplicitStopListener) {
                    ((PhpInstructionExplicitStopListener)processor).handleExplicitTraversalTermination();
                }
            }
            processorPool.removeFirst();
            ProgressManager.checkCanceled();
            if (c++ <= 200000) continue;
            throw new PhpControlFlowException("Control flow (Predecessors) is too big. Initial instruction=" + instruction + " Last instruction=" + curInstruction);
        }
    }

    public static int processFlow(@NotNull PhpControlFlow controlFlow, @NotNull PhpInstructionProcessor processor) {
        int i;
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(18);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(19);
        }
        PhpInstruction[] instructions = controlFlow.getInstructions();
        for (i = 0; i < instructions.length && instructions[i].process(processor); ++i) {
        }
        return i;
    }

    public static void processLoopInstructions(@NotNull PhpControlFlow controlFlow, final @NotNull Processor<PhpLoopHostInstructionImpl> processor) {
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(21);
        }
        PhpControlFlowUtil.processFlow(controlFlow, new PhpInstructionProcessor(){

            public boolean processHostInstruction(PhpHostInstruction instruction) {
                if (instruction instanceof PhpLoopHostInstructionImpl) {
                    return processor.process((Object)((PhpLoopHostInstructionImpl)instruction));
                }
                return true;
            }
        });
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstruction(@NotNull PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(23);
        }
        return PhpControlFlowUtil.getAccessInstructionInScopeHolder(PhpPsiUtil.getScopeHolder((PsiElement)anchor), anchor, instructionClass);
    }

    @Nullable
    public static <T extends PhpAccessInstruction> T getAccessInstructionInScopeHolder(@Nullable PhpScopeHolder scopeHolder, @NotNull PhpPsiElement anchor, @NotNull Class<T> instructionClass) {
        if (anchor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (instructionClass == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(25);
        }
        if (scopeHolder == null) {
            return null;
        }
        PhpControlFlow flow = scopeHolder.getControlFlow();
        return (T)flow.getInstruction(anchor, instructionClass);
    }

    @Nullable
    public static PhpCallInstruction getCallInstruction(@NotNull FunctionReference functionReference) {
        PhpInstruction[] instructions;
        PhpScopeHolder scopeHolder;
        if (functionReference == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(26);
        }
        if ((scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)functionReference)) == null) {
            return null;
        }
        for (PhpInstruction instruction : instructions = scopeHolder.getControlFlow().getInstructions()) {
            if (!(instruction instanceof PhpCallInstruction) || functionReference != ((PhpCallInstruction)instruction).getFunctionReference()) continue;
            return (PhpCallInstruction)instruction;
        }
        return null;
    }

    @Nullable
    public static PhpStatementInstruction getStatementInstruction(@NotNull PhpControlFlow controlFlow, final @NotNull Statement statement) {
        if (controlFlow == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(27);
        }
        if (statement == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(28);
        }
        PhpInstruction[] instructions = controlFlow.getInstructions();
        int i = PhpControlFlowUtil.processFlow(controlFlow, new PhpInstructionProcessor(){

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                return instruction.getStatement() != statement;
            }
        });
        return i == 0 || i == instructions.length ? null : (PhpStatementInstruction)instructions[i];
    }

    public static void processPreviousVariableAccesses(@NotNull PhpAccessVariableInstruction point, boolean processSelf, @NotNull PhpInstructionProcessor processor) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (processor == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(30);
        }
        PhpControlFlowUtil.processPredecessors((PhpInstruction)point, processSelf, new MyVariableInstructionProcessor(point.getVariableName(), processor));
    }

    public static PhpAccessVariableInstruction @NotNull [] getFollowingVariableAccessInstructions(@NotNull PhpInstruction point, final @NotNull CharSequence variableName, final boolean successorsOnly) {
        if (point == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(31);
        }
        if (variableName == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(32);
        }
        final ArrayList followingAccesses = new ArrayList();
        PhpControlFlowUtil.processSuccessors(point, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    followingAccesses.add(instruction);
                    return !successorsOnly;
                }
                return true;
            }
        });
        if (followingAccesses.size() == 0) {
            if (PhpAccessVariableInstruction.EMPTY_ARRAY == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(33);
            }
            return PhpAccessVariableInstruction.EMPTY_ARRAY;
        }
        PhpAccessVariableInstruction[] phpAccessVariableInstructionArray = followingAccesses.toArray(PhpAccessVariableInstruction.EMPTY_ARRAY);
        if (phpAccessVariableInstructionArray == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(34);
        }
        return phpAccessVariableInstructionArray;
    }

    public static boolean isPredecessor(@NotNull PhpInstruction instruction, final @NotNull PhpInstruction candidate) {
        if (instruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(35);
        }
        if (candidate == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(36);
        }
        final Ref isReachedRef = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors(instruction, false, new PhpInstructionProcessor(){

            public boolean processInstruction(PhpInstruction curInstruction) {
                if (curInstruction == candidate) {
                    isReachedRef.set((Object)true);
                }
                return (Boolean)isReachedRef.get() == false;
            }
        });
        return (Boolean)isReachedRef.get();
    }

    public static boolean isReferencedInUseList(@NotNull Function function, @NotNull Variable accessedVariable) {
        if (function == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(37);
        }
        if (accessedVariable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(38);
        }
        if (!function.isClosure()) {
            return false;
        }
        PhpUseList useList = (PhpUseList)PsiTreeUtil.findChildOfType((PsiElement)function, PhpUseList.class);
        if (useList == null) {
            return false;
        }
        Object[] variables = (Variable[])PsiTreeUtil.getChildrenOfType((PsiElement)useList, Variable.class);
        if (ArrayUtil.isEmpty((Object[])variables)) {
            return false;
        }
        if (!accessedVariable.canReadName()) {
            return false;
        }
        String accessedVariableName = accessedVariable.getName();
        for (Object variable : variables) {
            if (!PhpLangUtil.equalsVariableNames(variable.getName(), accessedVariableName) || !(accessedVariable.getParent() instanceof ArrayAccessExpression) && !PhpWorkaroundUtil.isReadReference((PsiElement)variable)) continue;
            return true;
        }
        return false;
    }

    public static boolean isPassByRefParameter(@NotNull Variable accessedVariable) {
        PsiElement resolvedElement;
        if (accessedVariable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(39);
        }
        return (resolvedElement = (PsiElement)accessedVariable.resolveLocal().stream().findFirst().orElse(null)) instanceof Parameter && ((Parameter)resolvedElement).isPassByRef();
    }

    public static Boolean hasPredecessorWithRefAccess(@NotNull PhpAccessVariableInstruction accessInstruction, final @NotNull Variable variable) {
        if (accessInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(40);
        }
        if (variable == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(41);
        }
        final Ref isReferenced = new Ref((Object)false);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)accessInstruction, true, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(@NotNull PhpAccessVariableInstruction instruction) {
                if (instruction == null) {
                    7.$$$reportNull$$$0(0);
                }
                if (PhpLangUtil.equalsVariableNames(variable.getName(), instruction.getVariableName())) {
                    PhpAccessInstruction.Access access = instruction.getAccess();
                    isReferenced.set((Object)((Boolean)isReferenced.get() != false || access.isWriteRef() || access.isReadRef() ? 1 : 0));
                }
                return (Boolean)isReferenced.get() == false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$7", "processAccessVariableInstruction"));
            }
        });
        return (Boolean)isReferenced.get();
    }

    public static boolean isReferenced(@NotNull PhpScopeHolder scopeHolder, @NotNull PhpAccessVariableInstruction accessInstruction) {
        PhpPsiElement anchor;
        if (scopeHolder == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(42);
        }
        if (accessInstruction == null) {
            PhpControlFlowUtil.$$$reportNull$$$0(43);
        }
        if ((anchor = accessInstruction.getAnchor()) instanceof Variable) {
            Function function;
            Variable accessedVariable = (Variable)anchor;
            if (!accessedVariable.canReadName()) {
                return false;
            }
            if (scopeHolder instanceof Function && (PhpControlFlowUtil.isReferencedInUseList(function = (Function)scopeHolder, accessedVariable) || PhpControlFlowUtil.isPassByRefParameter(accessedVariable))) {
                return true;
            }
            return PhpControlFlowUtil.hasPredecessorWithRefAccess(accessInstruction, accessedVariable);
        }
        return false;
    }

    public static void processFile(@NotNull PhpFile file, @NotNull PhpInstructionProcessor collector) {
        block4: {
            if (file == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(44);
            }
            if (collector == null) {
                PhpControlFlowUtil.$$$reportNull$$$0(45);
            }
            try {
                StreamEx.of((Collection)file.getTopLevelDefs().values()).select(PhpNamespace.class).map(PhpScopeHolder::getControlFlow).append((Object)file.getControlFlow()).forEach(cf -> PhpControlFlowUtil.processFlow(cf, collector));
            }
            catch (Exception e) {
                if (e instanceof ControlFlowException) break block4;
                LOG.warn("Exception while building control flow for " + file.getName(), (Throwable)e);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 33: 
            case 34: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 33: 
            case 34: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 14: 
            case 17: 
            case 19: 
            case 21: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appendPredecessorsStrategy";
                break;
            }
            case 18: 
            case 20: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionClass";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionReference";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variableName";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 38: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessedVariable";
                break;
            }
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessInstruction";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeHolder";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getFollowingVariableAccessInstructions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processSuccessors";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessors";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreBackEdges";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processPredecessorsIgnoreInitialBackEdges";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processFlow";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processLoopInstructions";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstruction";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAccessInstructionInScopeHolder";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getCallInstruction";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "getStatementInstruction";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processPreviousVariableAccesses";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getFollowingVariableAccessInstructions";
                break;
            }
            case 33: 
            case 34: {
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isPredecessor";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isReferencedInUseList";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "isPassByRefParameter";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "hasPredecessorWithRefAccess";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "isReferenced";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 33: 
            case 34: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpRecursiveInstructionProcessor
    extends PhpInstructionProcessor {
        private static final int DEPTH_LIMIT = 100;
        private int myDepth = 0;

        public boolean processFunctionDeclarationInstruction(PhpFunctionDeclarationInstruction instruction) {
            this.processFlow((PhpScopeHolder)instruction.getFunctionDeclaration());
            return super.processFunctionDeclarationInstruction(instruction);
        }

        public boolean processClassDeclarationInstruction(PhpClassDeclarationInstruction instruction) {
            for (Method method : instruction.getClassDeclaration().getOwnMethods()) {
                this.processFlow((PhpScopeHolder)method);
            }
            return super.processClassDeclarationInstruction(instruction);
        }

        private void processFlow(@NotNull PhpScopeHolder scopeHolder) {
            if (scopeHolder == null) {
                PhpRecursiveInstructionProcessor.$$$reportNull$$$0(0);
            }
            if (this.myDepth++ <= this.getLimit()) {
                PhpControlFlowUtil.processFlow(scopeHolder.getControlFlow(), this);
            }
            --this.myDepth;
        }

        protected int getLimit() {
            return 100;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scopeHolder", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$PhpRecursiveInstructionProcessor", "processFlow"));
        }
    }

    @ApiStatus.Experimental
    public static class PhpClosureVisitingInstructionProcessor
    extends PhpInstructionProcessor {
        public boolean processInstruction(PhpInstruction instruction) {
            if (!super.processInstruction(instruction)) {
                return false;
            }
            for (Function function : ((PhpInstructionImpl)instruction).getClosuresAfter()) {
                for (PhpInstruction closureInstruction : function.getControlFlow().getInstructions()) {
                    if (closureInstruction.process((PhpInstructionProcessor)this)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    private static class MyVariableInstructionProcessor
    extends PhpInstructionProcessor {
        private final PhpInstructionProcessor myProcessor;
        private final CharSequence myVariableName;

        MyVariableInstructionProcessor(@NotNull CharSequence variableName, PhpInstructionProcessor processor) {
            if (variableName == null) {
                MyVariableInstructionProcessor.$$$reportNull$$$0(0);
            }
            this.myVariableName = variableName;
            this.myProcessor = processor;
        }

        public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
            if (PhpLangUtil.equalsVariableNames(this.myVariableName, instruction.getVariableName())) {
                return this.myProcessor.processAccessVariableInstruction(instruction);
            }
            return true;
        }

        public boolean processInstruction(PhpInstruction instruction) {
            return instruction.process(this.myProcessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variableName", "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$MyVariableInstructionProcessor", "<init>"));
        }
    }

    private static class MyIgnoreInitialBackEdgesAppendPredecessorsStrategy
    implements AppendPredecessorsStrategy {
        private MyIgnoreInitialBackEdgesAppendPredecessorsStrategy() {
        }

        @Override
        public void appendPredecessors(@NotNull PhpInstruction instruction, @NotNull Collection<PhpInstruction> pool, int initialNumber) {
            if (instruction == null) {
                MyIgnoreInitialBackEdgesAppendPredecessorsStrategy.$$$reportNull$$$0(0);
            }
            if (pool == null) {
                MyIgnoreInitialBackEdgesAppendPredecessorsStrategy.$$$reportNull$$$0(1);
            }
            List predecessors = (List)instruction.getPredecessors();
            PhpControlFlowBuilder.PhpSkippedLoopInstruction skipLoopPredecessor = ((PhpInstructionImpl)instruction).getSkipLoopPredecessor();
            int size = predecessors.size();
            for (int i = 0; i < size; ++i) {
                PhpInstruction predecessor = (PhpInstruction)predecessors.get(i);
                if (initialNumber <= predecessor.num() || this.alwaysNonEmpty(skipLoopPredecessor, predecessor)) continue;
                pool.add(predecessor);
            }
        }

        protected boolean alwaysNonEmpty(PhpControlFlowBuilder.PhpSkippedLoopInstruction skippedLoopInstruction, PhpInstruction predecessor) {
            return PhpControlFlowUtil.alwaysNonEmpty(skippedLoopInstruction, predecessor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "instruction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pool";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/codeInsight/controlFlow/PhpControlFlowUtil$MyIgnoreInitialBackEdgesAppendPredecessorsStrategy";
            objectArray[2] = "appendPredecessors";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface AppendPredecessorsStrategy {
        public void appendPredecessors(@NotNull PhpInstruction var1, @NotNull Collection<PhpInstruction> var2, int var3);
    }
}

